/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.checker;

import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.dsl.checker.IStaticCheckerHandler;
import org.codehaus.groovy.eclipse.editor.highlighting.SemanticReferenceRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTypeCheckerRequestor
extends SemanticReferenceRequestor {
    private final IStaticCheckerHandler handler;
    private final Map<Integer, String> commentsMap;
    private final boolean onlyAssertions;

    StaticTypeCheckerRequestor(IStaticCheckerHandler handler, Map<Integer, String> commentsMap, boolean onlyAssertions) {
        this.handler = handler;
        this.commentsMap = commentsMap;
        this.onlyAssertions = onlyAssertions;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (node instanceof BlockStatement && ((BlockStatement)node).getStatements() == null) {
            return ITypeRequestor.VisitStatus.CANCEL_BRANCH;
        }
        if (!(node instanceof AnnotatedNode)) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (node.getEnd() <= 0 || node.getStart() == 0 && node.getEnd() == 1) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (!this.onlyAssertions && result.confidence == TypeLookupResult.TypeConfidence.UNKNOWN && node.getEnd() > 0) {
            this.handler.handleUnknownReference(node, StaticTypeCheckerRequestor.getPosition((ASTNode)node), node.getLineNumber());
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        String expectedType = this.commentsMap.remove(node.getLineNumber());
        if (expectedType != null && !this.typeMatches(result.type, expectedType)) {
            this.handler.handleTypeAssertionFailed(node, expectedType, this.printTypeName(result.type), StaticTypeCheckerRequestor.getPosition((ASTNode)node), node.getLineNumber());
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean typeMatches(ClassNode type, String expectedType) {
        String actualType = this.printTypeName(type);
        return expectedType.equals(actualType);
    }

    protected String printTypeName(ClassNode type) {
        return type != null ? String.valueOf(type.getName()) + this.printGenerics(type) : "null";
    }

    private String printGenerics(ClassNode type) {
        if (type.getGenericsTypes() == null || type.getGenericsTypes().length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        int i = 0;
        while (i < type.getGenericsTypes().length) {
            GenericsType gt = type.getGenericsTypes()[i];
            sb.append(this.printTypeName(gt.getType()));
            if (i < type.getGenericsTypes().length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append('>');
        return sb.toString();
    }
}

