/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.checker;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.eclipse.dsl.checker.IStaticCheckerHandler;
import org.codehaus.groovy.eclipse.dsl.checker.StaticTypeCheckerRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeChecker {
    private final IStaticCheckerHandler handler;
    private final List<IResource> resources;
    protected boolean onlyAssertions;
    protected final char[][] includes;
    protected final char[][] excludes;

    public ResourceTypeChecker(IStaticCheckerHandler handler, String projectName, char[][] includes, char[][] excludes, boolean onlyAssertions) {
        this(handler, ResourceTypeChecker.createProject(projectName), includes, excludes, onlyAssertions);
    }

    public ResourceTypeChecker(IStaticCheckerHandler handler, List<IResource> resources, char[][] includes, char[][] excludes, boolean onlyAssertions) {
        this.handler = handler;
        this.resources = resources;
        this.includes = includes;
        this.excludes = excludes;
        this.onlyAssertions = onlyAssertions;
    }

    private static List<IResource> createProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!GroovyNature.hasGroovyNature((IProject)project)) {
            throw new IllegalArgumentException("Invalid project: " + projectName);
        }
        return Collections.singletonList(project);
    }

    public boolean doCheck(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Static type analysis", this.resources.size());
        for (IResource resource : this.resources) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            CheckerVisitor visitor = new CheckerVisitor(monitor);
            resource.accept((IResourceVisitor)visitor);
            monitor.worked(1);
        }
        return this.handler.finish(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckerVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        CheckerVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.isDerived()) {
                return false;
            }
            ResourceTypeChecker.this.handler.handleResourceStart(resource);
            if (resource.getType() == 1 && ContentTypeUtils.isGroovyLikeFileName((String)resource.getName())) {
                if (Util.isExcluded((IResource)resource, (char[][])ResourceTypeChecker.this.includes, (char[][])ResourceTypeChecker.this.excludes)) {
                    return false;
                }
                GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.create((IFile)((IFile)resource));
                if (unit != null && unit.isOnBuildPath()) {
                    if (this.monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.monitor.subTask(resource.getName());
                    ResourceTypeChecker.this.handler.setResource((IFile)resource);
                    Map<Integer, String> commentsMap = this.findComments(unit);
                    StaticTypeCheckerRequestor requestor = new StaticTypeCheckerRequestor(ResourceTypeChecker.this.handler, commentsMap, ResourceTypeChecker.this.onlyAssertions);
                    TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                    try {
                        unit.becomeWorkingCopy(this.monitor);
                        visitor.visitCompilationUnit((ITypeRequestor)requestor);
                    }
                    finally {
                        unit.discardWorkingCopy();
                    }
                }
            }
            return true;
        }

        private Map<Integer, String> findComments(GroovyCompilationUnit unit) {
            List comments = unit.getModuleNode().getContext().getComments();
            HashMap<Integer, String> allComments = new HashMap<Integer, String>(comments.size());
            for (Comment comment : comments) {
                String candidate;
                String val;
                int typeIndex;
                StringTokenizer stok = new StringTokenizer(comment.toString());
                String type = null;
                if (stok.hasMoreTokens() && (typeIndex = (val = stok.nextToken()).indexOf("TYPE:")) > 0 && (type = val.substring(typeIndex + "TYPE:".length())).length() == 0) {
                    type = null;
                }
                if (stok.hasMoreTokens() && (candidate = stok.nextToken()).startsWith("TYPE:")) {
                    if (candidate.equals("TYPE:")) {
                        if (stok.hasMoreTokens()) {
                            type = stok.nextToken();
                        }
                    } else {
                        String[] split = candidate.split("\\:");
                        type = split[1];
                    }
                }
                if (type == null) continue;
                allComments.put(comment.sline, type);
            }
            return allComments;
        }
    }
}

