/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsLoader;
import org.codehaus.groovy.eclipse.dsl.script.DSLDScriptExecutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshDSLDJob
extends Job {
    private final List<IProject> projects;
    private DSLDStoreManager contextStoreManager = GroovyDSLCoreActivator.getDefault().getContextStoreManager();

    @Deprecated
    public RefreshDSLDJob(IProject project) {
        this(Collections.singletonList(project));
    }

    @Deprecated
    public RefreshDSLDJob(List<IProject> projects) {
        super("Refresh DSLD scripts");
        this.projects = this.contextStoreManager.addInProgress(projects);
    }

    protected boolean isDSLD(IStorage file) {
        return this.isFile(file, "dsld");
    }

    protected boolean isSuggestionFile(IStorage file) {
        return this.isFile(file, "xdsl");
    }

    protected boolean isFile(IStorage file, String extension) {
        if (file instanceof IFile) {
            IFile iFile = (IFile)file;
            return !iFile.isDerived() && extension.equals(iFile.getFileExtension());
        }
        String name = file.getName();
        return name != null && name.endsWith(extension);
    }

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStatus refreshProject(IProject project, IProgressMonitor monitor) {
        String event = null;
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Refreshing inferencing scripts for " + project.getName());
            event = "Refreshing inferencing scripts: " + project.getName();
            GroovyLogManager.manager.logStart(event);
        }
        monitor.beginTask("Refreshing DSLD files for project " + project.getName(), 9);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Purging old state");
        }
        DSLDStore store = GroovyDSLCoreActivator.getDefault().getContextStoreManager().getDSLDStore(project);
        store.purgeAll();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Finding inferencing DSL scripts");
        }
        Set<IStorage> findDSLDFiles = new DSLDResourceVisitor(project).findFiles(monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        for (IStorage file : findDSLDFiles) {
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.DSL, "Processing " + file.getName() + " in project " + project.getName());
            }
            monitor.subTask("Processing " + file.getName() + " in project " + project.getName());
            if (this.isDSLD(file)) {
                DSLDScriptExecutor executor = new DSLDScriptExecutor(JavaCore.create((IProject)project));
                executor.executeScript(file);
            } else if (this.isSuggestionFile(file)) {
                new SuggestionsLoader((IFile)file).loadExistingSuggestions();
            }
            if (!monitor.isCanceled()) continue;
            return Status.CANCEL_STATUS;
        }
        monitor.worked(6);
        monitor.done();
        if (event != null) {
            GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return family == RefreshDSLDJob.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DSLDResourceVisitor
    implements IResourceVisitor {
        private static final String PLUGIN_DSLD_SUPPORT = "plugin_dsld_support";
        private static final String GLOBAL_DSLD_SUPPORT = "global_dsld_support";
        private final IProject project;
        private final Set<IStorage> dsldFiles;
        private final Set<String> alreadyAdded;

        public DSLDResourceVisitor(IProject project) {
            this.project = project;
            this.dsldFiles = new HashSet<IStorage>();
            this.alreadyAdded = new HashSet<String>();
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.isDerived()) {
                return false;
            }
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                if (!this.alreadyAdded.contains(file) && (RefreshDSLDJob.this.isDSLD((IStorage)file) || RefreshDSLDJob.this.isSuggestionFile((IStorage)file))) {
                    this.alreadyAdded.add(file.getName());
                    this.dsldFiles.add((IStorage)file);
                } else if (this.alreadyAdded.contains(file.getName())) {
                    GroovyDSLCoreActivator.logWarning("DSLD File " + file.getFullPath() + " already added, so skipping.");
                }
            }
            return true;
        }

        public Set<IStorage> findFiles(IProgressMonitor monitor) {
            block2: {
                try {
                    this.project.accept((IResourceVisitor)this);
                    this.findDSLDsInLibraries(monitor);
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 368) break block2;
                    GroovyDSLCoreActivator.logException(e);
                }
            }
            return this.dsldFiles;
        }

        protected void findDSLDsInLibraries(IProgressMonitor monitor) throws JavaModelException {
            IPackageFragmentRoot[] roots;
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.getFragmentRoots(javaProject, monitor);
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IPackageFragment frag;
                    if ((root.getKind() == 2 || this.isSourceFolderFromOtherProject(root)) && ((frag = root.getPackageFragment("dsld")).exists() || root.getElementName().equals(GLOBAL_DSLD_SUPPORT) || root.getElementName().equals(PLUGIN_DSLD_SUPPORT))) {
                        Object resource;
                        int n3;
                        int n4;
                        Object[] objectArray;
                        IResource rootResource = root.getResource();
                        if (rootResource instanceof IFolder && ((IFolder)rootResource).getFolder("dsld").exists()) {
                            IFolder dsldFolder = ((IFolder)rootResource).getFolder("dsld");
                            objectArray = dsldFolder.members();
                            n4 = objectArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                resource = objectArray[n3];
                                if (resource.getType() == 1 && !this.alreadyAdded.contains(resource.getName()) && RefreshDSLDJob.this.isDSLD((IStorage)((IFile)resource))) {
                                    this.alreadyAdded.add(resource.getName());
                                    this.dsldFiles.add((IStorage)resource);
                                } else if (this.alreadyAdded.contains(resource.getName())) {
                                    GroovyLogManager.manager.log(TraceCategory.DSL, "DSLD File " + resource.getFullPath() + " already added, so skipping.");
                                }
                                ++n3;
                            }
                        } else {
                            Object[] resources;
                            objectArray = resources = frag.getNonJavaResources();
                            n4 = resources.length;
                            n3 = 0;
                            while (n3 < n4) {
                                resource = objectArray[n3];
                                if (resource instanceof IStorage) {
                                    IStorage file = (IStorage)resource;
                                    if (!this.alreadyAdded.contains(file.getName()) && RefreshDSLDJob.this.isDSLD(file)) {
                                        this.alreadyAdded.add(file.getName());
                                        this.dsldFiles.add(file);
                                    } else if (this.alreadyAdded.contains(file.getName())) {
                                        GroovyLogManager.manager.log(TraceCategory.DSL, "DSLD File " + file.getFullPath() + " already added, so skipping.");
                                    }
                                }
                                ++n3;
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    switch (e.getStatus().getCode()) {
                        case 969: 
                        case 1006: {
                            break;
                        }
                        default: {
                            GroovyDSLCoreActivator.logException(e);
                        }
                    }
                }
                ++n2;
            }
        }

        private boolean isSourceFolderFromOtherProject(IPackageFragmentRoot root) {
            if (root.isReadOnly()) {
                return false;
            }
            IResource resource = root.getResource();
            if (resource == null) {
                return false;
            }
            return !resource.getProject().equals((Object)this.project);
        }

        private IPackageFragmentRoot[] getFragmentRoots(final IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
            IPackageFragmentRoot[][] roots;
            block2: {
                roots = new IPackageFragmentRoot[1][];
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            roots[0] = javaProject.getAllPackageFragmentRoots();
                        }
                    }, this.getSchedulingRule(), 1, monitor);
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 969) break block2;
                    GroovyDSLCoreActivator.logException(e);
                }
            }
            return roots[0] != null ? roots[0] : new IPackageFragmentRoot[]{};
        }

        private ISchedulingRule getSchedulingRule() {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            return ruleFactory.buildRule();
        }
    }
}

