/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.DSLDElementListener;
import org.codehaus.groovy.eclipse.dsl.DSLDResourceListener;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.classpath.AutoAddContainerSupport;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GroovyDSLCoreActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.codehaus.groovy.eclipse.dsl";
    private static BundleContext context;
    private static GroovyDSLCoreActivator plugin;
    private final DSLDStoreManager contextStoreManager;
    private DSLDResourceListener dsldResourceListener;
    private DSLDElementListener dsldElementListener;
    private AutoAddContainerSupport containerListener;
    public static final String MARKER_ID = "org.codehaus.groovy.eclipse.dsl.inferencing_problem";
    public static IPath CLASSPATH_CONTAINER_ID;

    static {
        CLASSPATH_CONTAINER_ID = new Path("GROOVY_DSL_SUPPORT");
    }

    public GroovyDSLCoreActivator() {
        plugin = this;
        this.contextStoreManager = new DSLDStoreManager();
    }

    public static GroovyDSLCoreActivator getDefault() {
        return plugin;
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        this.dsldElementListener = new DSLDElementListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.dsldElementListener, (int)1);
        this.dsldResourceListener = new DSLDResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.dsldResourceListener);
        this.containerListener = new AutoAddContainerSupport();
        this.containerListener.addContainerToAll();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.containerListener, 1);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        context = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.dsldResourceListener);
        this.dsldResourceListener = null;
        JavaCore.removeElementChangedListener((IElementChangedListener)this.dsldElementListener);
        this.dsldElementListener = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.containerListener);
        this.containerListener.dispose();
        this.containerListener = null;
    }

    public AutoAddContainerSupport getContainerListener() {
        return this.containerListener;
    }

    public DSLDStoreManager getContextStoreManager() {
        return this.contextStoreManager;
    }

    private static void log(int severity, String message, Throwable throwable) {
        Status status = new Status(severity, PLUGIN_ID, 0, message, throwable);
        try {
            GroovyDSLCoreActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (NullPointerException nullPointerException) {}
        if (GroovyLogManager.manager.hasLoggers()) {
            if (throwable != null) {
                GroovyLogManager.manager.log(TraceCategory.DSL, "Exception caught.  See error log.  Message: " + throwable.getLocalizedMessage());
            } else if (message != null) {
                GroovyLogManager.manager.log(TraceCategory.DSL, "Message logged.  See error log.  Message: " + message);
            }
        }
    }

    public static void logException(String message, Throwable throwable) {
        GroovyDSLCoreActivator.log(4, message, throwable);
    }

    public static void logException(Throwable throwable) {
        GroovyDSLCoreActivator.log(4, throwable.getLocalizedMessage(), throwable);
    }

    public static void logWarning(String message) {
        GroovyDSLCoreActivator.log(2, message, null);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return GroovyDSLCoreActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public boolean isDSLDDisabled() {
        return this.getPreferenceStore().getBoolean("org.codehaus.groovy.eclipse.dsl.disabled");
    }
}

