/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.RefreshDSLDJob;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLDStoreManager {
    private final Map<String, DSLDStore> projectDSLDMap;
    private final Set<String> inProgress = new HashSet<String>();
    private static final int TIME_LIMIT = 30000;

    public DSLDStoreManager() {
        this.projectDSLDMap = new HashMap<String, DSLDStore>();
    }

    public DSLDStore getDSLDStore(IJavaProject project) {
        return this.getDSLDStore(project.getElementName());
    }

    public DSLDStore getDSLDStore(IProject project) {
        return this.getDSLDStore(project.getName());
    }

    public DSLDStore getDSLDStore(String projectName) {
        DSLDStore contextStore = this.projectDSLDMap.get(projectName);
        if (contextStore == null) {
            contextStore = new DSLDStore();
            this.projectDSLDMap.put(projectName, contextStore);
        }
        return contextStore;
    }

    public void clearDSLDStore(IProject project) {
        this.projectDSLDMap.remove(project.getName());
    }

    public void clearDSLDStore(IJavaProject project) {
        this.projectDSLDMap.remove(project.getElementName());
    }

    public void reset() {
        this.projectDSLDMap.clear();
    }

    public boolean hasDSLDStoreFor(IProject project) {
        return this.projectDSLDMap.containsKey(project.getName());
    }

    public List<String> getAllStores() {
        return new ArrayList<String>(this.projectDSLDMap.keySet());
    }

    public void initializeAll(boolean synchronous) {
        if (GroovyDSLCoreActivator.getDefault().isDSLDDisabled()) {
            return;
        }
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.initialize(allProjects, synchronous);
    }

    public void initialize(IProject[] projects, boolean synchronous) {
        this.initialize(Arrays.asList(projects), synchronous);
    }

    public void initialize(IProject project, boolean synchronous) {
        this.initialize(Collections.singletonList(project), synchronous);
    }

    public void initialize(List<IProject> projects, boolean synchronous) {
        ArrayList<IProject> groovyProjects = new ArrayList<IProject>(projects.size());
        for (IProject project : projects) {
            if (!GroovyNature.hasGroovyNature((IProject)project)) continue;
            groovyProjects.add(project);
        }
        RefreshDSLDJob refreshJob = new RefreshDSLDJob(groovyProjects);
        refreshJob.setPriority(synchronous ? 10 : 30);
        refreshJob.schedule();
        if (synchronous) {
            this.waitForFinish();
        }
    }

    public void ensureInitialized(IProject project, boolean synchronous) {
        if (!this.hasDSLDStoreFor(project) && !this.isInProgress(project)) {
            this.initialize(project, synchronous);
        }
    }

    synchronized void waitForFinish() {
        long end = System.currentTimeMillis() + 30000L;
        while (!this.inProgress.isEmpty()) {
            try {
                long timeLeft = end - System.currentTimeMillis();
                if (timeLeft <= 0L) break;
                this.wait(timeLeft);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized boolean isInProgress(IProject project) {
        return this.inProgress.contains(project.getName());
    }

    private synchronized boolean addInProgress(IProject project) {
        return this.inProgress.add(project.getName());
    }

    synchronized List<IProject> addInProgress(List<IProject> projects) {
        ArrayList<IProject> addedProjects = new ArrayList<IProject>(projects.size());
        for (IProject project : projects) {
            if (!this.addInProgress(project)) continue;
            addedProjects.add(project);
        }
        return addedProjects;
    }

    synchronized void removeInProgress(IProject project) {
        this.inProgress.remove(project.getName());
        this.notifyAll();
    }
}

