/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsLoader;
import org.codehaus.groovy.eclipse.dsl.script.DSLDScriptExecutor;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;

public class DSLDResourceListener
implements IResourceChangeListener {
    private static final DSLDStoreManager contextStoreManager = GroovyDSLCoreActivator.getDefault().getContextStoreManager();

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: 
            case 4: {
                try {
                    if (event.getDelta() == null) break;
                    event.getDelta().accept((IResourceDeltaVisitor)new DSLDChangeResourceDeltaVisitor(event.getType()));
                    break;
                }
                catch (CoreException e) {
                    GroovyDSLCoreActivator.logException(e);
                }
            }
        }
    }

    public boolean isDSLDFile(IFile file) {
        String fileExtension = file.getFileExtension();
        return fileExtension != null && fileExtension.equals("dsld");
    }

    public boolean isXDSL(IFile file) {
        String fileExtension = file.getFileExtension();
        return fileExtension != null && fileExtension.equals("xdsl");
    }

    private class DSLDChangeResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final int eventType;

        private DSLDChangeResourceDeltaVisitor(int eventType) {
            this.eventType = eventType;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            IResource deltaResource = delta.getResource();
            if (deltaResource.isDerived()) {
                return false;
            }
            if (deltaResource.getType() == 4) {
                IProject project = (IProject)deltaResource;
                if (this.eventType == 4 && delta.getKind() == 2 || this.eventType == 2 || !GroovyNature.hasGroovyNature((IProject)project)) {
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.DSL, "Deleting DSL context for: " + project.getName());
                    }
                    contextStoreManager.clearDSLDStore(project);
                    return false;
                }
                if (!contextStoreManager.hasDSLDStoreFor(project) && GroovyNature.hasGroovyNature((IProject)project)) {
                    GroovyDSLCoreActivator.getDefault().getContextStoreManager().initialize(project, false);
                    return false;
                }
                if (!GroovyNature.hasGroovyNature((IProject)project)) {
                    return false;
                }
            } else if (deltaResource.getType() == 1 && (DSLDResourceListener.this.isDSLDFile(file = (IFile)deltaResource) || DSLDResourceListener.this.isXDSL(file))) {
                IProject project = file.getProject();
                DSLDStore store = contextStoreManager.getDSLDStore(project);
                Assert.isNotNull((Object)store, (String)"Context store should not be null");
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.DSL, "Processing " + file.getName());
                }
                store.purgeIdentifier((IStorage)file);
                if (file.isAccessible() && this.eventType == 1) {
                    if (DSLDResourceListener.this.isDSLDFile(file)) {
                        DSLDScriptExecutor executor = new DSLDScriptExecutor(JavaCore.create((IProject)project));
                        executor.executeScript((IStorage)file);
                    } else if (DSLDResourceListener.this.isXDSL(file)) {
                        new SuggestionsLoader(file).addSuggestionsContributionGroup();
                    }
                }
            }
            return true;
        }
    }
}

