/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.cucumber.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.integration.cucumber.dialog.NewFeatureEntityDialog;
import com.kms.katalon.composer.integration.cucumber.handler.FeatureTreeRootCatcher;
import com.kms.katalon.composer.integration.cucumber.handler.OpenFeatureEntityHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewFeatureEntityHandler
extends FeatureTreeRootCatcher {
    private static final String RESOURCES_TEMPLATE_TPL_PATH = "resources/template/feature_template.tpl";
    @Inject
    IEventBroker eventBroker;
    @Inject
    ESelectionService selectionService;

    @CanExecute
    public boolean canExcute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            FolderTreeEntity parentFeatureTreeFolder = this.getParentFeatureTreeFolder();
            FolderEntity rootFolder = parentFeatureTreeFolder.getObject();
            List currentFeatures = SystemFileController.getInstance().getChildren(rootFolder);
            NewFeatureEntityDialog dialog = new NewFeatureEntityDialog(parentShell, currentFeatures);
            if (dialog.open() == 0) {
                NewFeatureEntityDialog.NewFeatureResult result = dialog.getResult();
                String content = result.isGenerateTemplateAllowed() ? this.getFileContent(RESOURCES_TEMPLATE_TPL_PATH) : "";
                SystemFileEntity feature = SystemFileController.getInstance().newFile(result.getNewName(), content, rootFolder);
                Trackings.trackCreatingObject((String)"bddFeatureFile");
                OpenFeatureEntityHandler openHandler = new OpenFeatureEntityHandler();
                openHandler.openEditor(feature);
                this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentFeatureTreeFolder);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new SystemFileTreeEntity(feature, parentFeatureTreeFolder));
            }
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to new Feature file", (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private FolderTreeEntity getParentFeatureTreeFolder() throws DALException, ControllerException {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        FolderTreeEntity parentFeatureTreeFolder = this.getSelectedTreeEntity((Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer"));
        if (parentFeatureTreeFolder == null) {
            FolderTreeEntity featureRootFolderEntity;
            FolderEntity includeRootFolder = FolderController.getInstance().getIncludeRoot(project);
            FolderEntity featureRootFolder = FolderController.getInstance().getFeatureRoot(project);
            parentFeatureTreeFolder = featureRootFolderEntity = new FolderTreeEntity(featureRootFolder, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)featureRootFolder.getParentFolder(), (FolderEntity)includeRootFolder));
        }
        return parentFeatureTreeFolder;
    }

    private String getFileContent(String filePath) {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(NewFeatureEntityHandler.class), (IPath)new Path(filePath), null);
        try {
            return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }
}

