/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.cucumber.dialog;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.entity.file.FileEntity;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewFeatureEntityDialog
extends CustomTitleAreaDialog {
    private static final String NEW_FEATURE_FILE_NAME = "New Feature File";
    private static final String FEATURE_FILE_EXTESION = "feature";
    private Text txtName;
    private List<FileEntity> currentFeatures;
    private NewFeatureResult result;
    private Button chckGenerateSampleContent;

    public NewFeatureEntityDialog(Shell parentShell, List<FileEntity> currentFeatures) {
        super(parentShell);
        this.setShellStyle(16);
        this.currentFeatures = currentFeatures;
    }

    protected void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFeatureEntityDialog.this.checkNewName(NewFeatureEntityDialog.this.txtName.getText());
            }
        });
    }

    protected void setInput() {
        this.chckGenerateSampleContent.setSelection(true);
        this.txtName.setText(this.getSuggestion(NEW_FEATURE_FILE_NAME, FEATURE_FILE_EXTESION));
        int dotIndex = this.txtName.getText().indexOf(".");
        if (dotIndex < 0) {
            this.txtName.selectAll();
        } else {
            this.txtName.setSelection(0, dotIndex);
        }
        this.setMessage("Create new Feature file", 1);
    }

    private boolean isNameDupplicated(String newName) {
        return this.currentFeatures.parallelStream().filter(l -> l.getName().equals(newName)).findAny().isPresent();
    }

    private String getSuggestion(String suggestion, String extension) {
        String newName = String.format("%s.%s", suggestion, extension);
        int index = 0;
        while (this.isNameDupplicated(newName)) {
            newName = String.format("%s %d.%s", suggestion, ++index, extension);
        }
        return newName;
    }

    private void checkNewName(String newName) {
        if (this.isNameDupplicated(newName)) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        try {
            EntityNameController.getInstance().validateName(newName);
            this.setMessage("Create new Feature file", 1);
            this.getButton(0).setEnabled(true);
        }
        catch (Exception e) {
            this.setMessage(e.getMessage(), 3);
            this.getButton(0).setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NEW_FEATURE_FILE_NAME);
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }

    protected void okPressed() {
        this.result = new NewFeatureResult(this.txtName.getText(), this.chckGenerateSampleContent.getSelection());
        super.okPressed();
    }

    public NewFeatureResult getResult() {
        return this.result;
    }

    protected Composite createContentArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite nameComposite = new Composite(container, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        nameComposite.setLayout((Layout)layout);
        Label lblName = new Label(nameComposite, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(GlobalMessageConstants.NAME);
        this.txtName = new Text(nameComposite, 2048);
        GridData gdTxtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtName.minimumWidth = 200;
        this.txtName.setLayoutData((Object)gdTxtName);
        this.chckGenerateSampleContent = new Button(container, 32);
        this.chckGenerateSampleContent.setLayoutData((Object)new GridData(4, 4, false, false));
        this.chckGenerateSampleContent.setText("Generate sample Feature template");
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite helpComposite = new Composite(parent, 0);
        helpComposite.setLayout((Layout)new GridLayout(1, false));
        helpComposite.setLayoutData((Object)new GridData(131072, 4, false, true));
        new HelpComposite(helpComposite, DocumentationMessageConstants.CUCUMBER_FEATURE_FILE);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public class NewFeatureResult {
        private final String newName;
        private final boolean generateTemplateAllowed;

        public NewFeatureResult(String newName, boolean generateTemplateAllowed) {
            this.newName = newName;
            this.generateTemplateAllowed = generateTemplateAllowed;
        }

        public boolean isGenerateTemplateAllowed() {
            return this.generateTemplateAllowed;
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

