/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.verification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.ObjectRepository;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import java.io.File;
import java.lang.reflect.Type;

public class WSResponseManager {
    private static final String REQUEST_OBJECT_FILE_EXTENSION = ".rs";
    private ResponseObject response;
    private String requestObjectId;
    private static WSResponseManager instance;

    private WSResponseManager() {
    }

    public static WSResponseManager getInstance() {
        if (instance == null) {
            instance = new WSResponseManager();
        }
        return instance;
    }

    public ResponseObject getCurrentResponse() throws Exception {
        if (this.response == null) {
            String responseObjectJson = (String)RunConfiguration.getProperty((String)"responseObject");
            Gson gson = new GsonBuilder().registerTypeAdapter(HttpBodyContent.class, (Object)new HttpBodyContentInstanceCreator()).create();
            this.response = (ResponseObject)gson.fromJson(responseObjectJson, ResponseObject.class);
            HttpTextBodyContent textBodyContent = new HttpTextBodyContent(this.response.getResponseBodyContent());
            this.response.setBodyContent((HttpBodyContent)textBodyContent);
        }
        return this.response;
    }

    public void setCurrentResponse(ResponseObject responseObject) {
        this.response = responseObject;
    }

    public RequestObject getCurrentRequest() throws Exception {
        if (this.requestObjectId == null) {
            this.requestObjectId = (String)RunConfiguration.getProperty((String)"requestObjectId");
        }
        File objectFile = new File(RunConfiguration.getProjectDir(), String.valueOf(this.requestObjectId) + REQUEST_OBJECT_FILE_EXTENSION);
        RequestObject requestObject = ObjectRepository.findRequestObject((String)this.requestObjectId, (File)objectFile);
        return requestObject;
    }

    public void setRequestObjectId(String requestObjectId) {
        this.requestObjectId = requestObjectId;
    }

    private static class HttpBodyContentInstanceCreator
    implements InstanceCreator<HttpBodyContent> {
        private HttpBodyContentInstanceCreator() {
        }

        public HttpBodyContent createInstance(Type arg0) {
            return new HttpTextBodyContent("");
        }
    }
}

