/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.helper;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.webservice.constants.StringConstants;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.net.HttpURLConnection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WebServiceCommonHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebServiceCommonHelper.class);

    public static void checkRequestObject(RequestObject requestObject) throws IllegalArgumentException {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_REQUEST_OBJECT);
        if (requestObject == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_REQUEST_OBJECT_IS_NULL);
        }
    }

    public static void checkResponseObject(ResponseObject responseObject) throws IllegalArgumentException {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_RESPONSE_OBJECT);
        if (responseObject == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_RESPONSE_OBJECT_IS_NULL);
        }
    }

    public static void checkResponseObjectContent(ResponseObject responseObject) throws Exception {
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_RESPONSE_OBJECT_CONTENT);
        if (responseObject.getResponseBodyContent() == null) {
            throw new IllegalArgumentException(StringConstants.KW_LOG_FAILED_RESPONSE_OBJECT_CONTENT_IS_NULL);
        }
    }

    public static Object parseAndExecuteExpressionForXml(String locator, String groovyFunction, String xmlText) {
        String[] tokens = locator.split("\\.");
        String rootName = "";
        String locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = String.valueOf(locatorExp) + token;
            if (i < tokens.length - 1) {
                locatorExp = String.valueOf(locatorExp) + ".";
            } else if (i == tokens.length - 1) {
                locatorExp = String.valueOf(locatorExp) + "." + groovyFunction;
            }
            if (i == 0) {
                rootName = token;
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("def " + rootName + " = new XmlSlurper().parseText(xmlText);");
        groovyScript.append("return " + locatorExp);
        Binding binding = new Binding();
        binding.setVariable("xmlText", (Object)xmlText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static Object parseAndGetPropertyValueForXml(String locator, String xmlText) {
        String[] tokens = locator.split("\\.");
        String rootName = "";
        String locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = String.valueOf(locatorExp) + token;
            if (i < tokens.length - 1) {
                locatorExp = String.valueOf(locatorExp) + ".";
            }
            if (i == 0) {
                rootName = token;
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("def " + rootName + " = new XmlSlurper().parseText(xmlText);");
        groovyScript.append("return " + locatorExp);
        Binding binding = new Binding();
        binding.setVariable("xmlText", (Object)xmlText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static Object parseAndExecuteExpressionForJson(String locator, String groovyFunction, String jsonText) {
        boolean needAppendRoot = true;
        String[] tokens = locator.split("\\.");
        String locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = String.valueOf(locatorExp) + token;
            if (i == 0 && token.matches("\\[\\d+\\]")) {
                needAppendRoot = false;
            }
            if (i < tokens.length - 1) {
                locatorExp = String.valueOf(locatorExp) + ".";
            } else if (i == tokens.length - 1) {
                if (!locatorExp.equals("")) {
                    locatorExp = String.valueOf(locatorExp) + ".";
                }
                locatorExp = String.valueOf(locatorExp) + groovyFunction;
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("import groovy.json.JsonSlurper;");
        groovyScript.append("def root = new JsonSlurper().parseText(jsonText);");
        if (needAppendRoot) {
            groovyScript.append("return root." + locatorExp + ";");
        } else {
            groovyScript.append("return root" + locatorExp + ";");
        }
        Binding binding = new Binding();
        binding.setVariable("jsonText", (Object)jsonText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static Object parseAndGetPropertyValueForJson(String locator, String jsonText) {
        boolean needAppendRoot = true;
        String[] tokens = locator.split("\\.");
        String locatorExp = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            locatorExp = String.valueOf(locatorExp) + token;
            if (i == 0 && token.matches("\\[\\d+\\]")) {
                needAppendRoot = false;
            }
            if (i < tokens.length - 1) {
                locatorExp = String.valueOf(locatorExp) + ".";
            }
            ++i;
        }
        StringBuilder groovyScript = new StringBuilder();
        groovyScript.append("import groovy.json.JsonSlurper;");
        groovyScript.append("def root = new JsonSlurper().parseText(jsonText);");
        if (needAppendRoot) {
            groovyScript.append("return root." + locatorExp + ";");
        } else {
            groovyScript.append("return root" + locatorExp + ";");
        }
        Binding binding = new Binding();
        binding.setVariable("jsonText", (Object)jsonText);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(groovyScript.toString());
    }

    public static long calculateHeaderLength(HttpURLConnection conn) {
        long headerLength = conn.getHeaderFields().entrySet().stream().mapToLong(e -> {
            String key = (String)e.getKey();
            if (StringUtils.isEmpty((String)key)) {
                return 0L;
            }
            long length = key.getBytes().length;
            return length += ((List)e.getValue()).stream().mapToLong(v -> v.getBytes().length).sum();
        }).sum();
        return headerLength;
    }
}

