/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.http.HTTPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12AddressImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.webservice.common.BasicRequestor;
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants;
import com.kms.katalon.core.webservice.exception.WebServiceException;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class SoapClient
extends BasicRequestor {
    private static final String POST = "POST";
    private static final String SSL = "SSL";
    private static final String HTTPS = "https";
    private static final String SOAP = "SOAP";
    private static final String SOAP12 = "SOAP12";
    private static final String SOAP_ACTION = "SOAPAction";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_XML_CHARSET_UTF_8 = "text/xml; charset=utf-8";
    private static final String APPLICATION_XML = "application/xml";
    private String serviceName;
    private String protocol = "SOAP";
    private String endPoint;
    private String actionUri;
    private RequestObject requestObject;

    public SoapClient(String projectDir, ProxyInformation proxyInformation) {
        super(projectDir, proxyInformation);
    }

    private void parseWsdl() throws WSDLException, WebServiceException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Definition wsdlDefinition = reader.readWSDL(null, this.requestObject.getWsdlAddress());
        this.lookForService(wsdlDefinition);
    }

    private void lookForService(Definition wsdlDefinition) throws WebServiceException {
        ServiceImpl service = null;
        Map services = wsdlDefinition.getAllServices();
        Iterator iterator = services.keySet().iterator();
        if (iterator.hasNext()) {
            Object sKey = iterator.next();
            service = (ServiceImpl)services.get(sKey);
            this.setServiceName(((QName)sKey).getLocalPart());
        }
        this.parseService(service);
    }

    private void parseService(ServiceImpl service) throws WebServiceException {
        Map ports = service.getPorts();
        for (Object pKey : ports.keySet()) {
            PortImpl port = (PortImpl)ports.get(pKey);
            Object objBinding = port.getBinding().getExtensibilityElements().get(0);
            String proc = "";
            BindingOperationImpl operation = (BindingOperationImpl)port.getBinding().getBindingOperation(this.requestObject.getSoapServiceFunction(), null, null);
            if (operation == null) {
                throw new WebServiceException(CoreWebserviceMessageConstants.MSG_NO_SERVICE_OPERATION);
            }
            if (objBinding != null && objBinding instanceof SOAPBindingImpl) {
                proc = SOAP;
                this.endPoint = ((SOAPAddressImpl)port.getExtensibilityElements().get(0)).getLocationURI();
                this.actionUri = ((SOAPOperation)operation.getExtensibilityElements().get(0)).getSoapActionURI();
            } else if (objBinding != null && objBinding instanceof SOAP12BindingImpl) {
                proc = SOAP12;
                this.endPoint = ((SOAP12AddressImpl)port.getExtensibilityElements().get(0)).getLocationURI();
                this.actionUri = ((SOAP12Operation)operation.getExtensibilityElements().get(0)).getSoapActionURI();
            } else if (objBinding != null && objBinding instanceof HTTPBindingImpl) {
                proc = ((HTTPBindingImpl)objBinding).getVerb();
                this.endPoint = ((HTTPAddressImpl)port.getExtensibilityElements().get(0)).getLocationURI();
                this.actionUri = ((HTTPOperation)operation.getExtensibilityElements().get(0)).getLocationURI();
            }
            if (this.protocol.equals(proc)) break;
        }
    }

    private boolean isHttps(RequestObject request) {
        return StringUtils.defaultString((String)request.getWsdlAddress()).toLowerCase().startsWith(HTTPS);
    }

    @Override
    public ResponseObject send(RequestObject request) throws IOException, WSDLException, WebServiceException, GeneralSecurityException {
        URL oURL;
        HttpURLConnection con;
        this.requestObject = request;
        this.parseWsdl();
        boolean isHttps = this.isHttps(request);
        if (isHttps) {
            SSLContext sc = SSLContext.getInstance(SSL);
            sc.init(null, this.getTrustManagers(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        if ((con = (HttpURLConnection)(oURL = new URL(this.endPoint)).openConnection(this.getProxy())) instanceof HttpsURLConnection) {
            ((HttpsURLConnection)con).setHostnameVerifier(this.getHostnameVerifier());
        }
        con.setRequestMethod(POST);
        con.setDoOutput(true);
        con.setRequestProperty(CONTENT_TYPE, TEXT_XML_CHARSET_UTF_8);
        con.setRequestProperty(SOAP_ACTION, this.actionUri);
        this.setHttpConnectionHeaders(con, request);
        OutputStream reqStream = con.getOutputStream();
        reqStream.write(request.getSoapBody().getBytes(StandardCharsets.UTF_8));
        long startTime = System.currentTimeMillis();
        int statusCode = con.getResponseCode();
        long waitingTime = System.currentTimeMillis() - startTime;
        long headerLength = WebServiceCommonHelper.calculateHeaderLength(con);
        long contentDownloadTime = 0L;
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[1024];
        long bodyLength = 0L;
        Throwable throwable = null;
        Object var20_16 = null;
        try (InputStream inputStream = statusCode >= 400 ? con.getErrorStream() : con.getInputStream();){
            if (inputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                int len = 0;
                startTime = System.currentTimeMillis();
                while ((len = reader.read(buffer)) != -1) {
                    contentDownloadTime += System.currentTimeMillis() - startTime;
                    sb.append(buffer, 0, len);
                    bodyLength += (long)len;
                    startTime = System.currentTimeMillis();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ResponseObject responseObject = new ResponseObject(sb.toString());
        String bodyLengthHeader = responseObject.getHeaderFields().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("Content-Length")).map(entry -> (String)((List)entry.getValue()).get(0)).findFirst().orElse("");
        if (!StringUtils.isEmpty((String)bodyLengthHeader)) {
            bodyLength = Long.parseLong(bodyLengthHeader, 10);
        }
        responseObject.setContentType(APPLICATION_XML);
        responseObject.setStatusCode(statusCode);
        responseObject.setResponseBodySize(bodyLength);
        responseObject.setResponseHeaderSize(headerLength);
        responseObject.setWaitingTime(waitingTime);
        responseObject.setContentDownloadTime(contentDownloadTime);
        this.setBodyContent(con, sb, responseObject);
        return responseObject;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

