/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.webservice.common.BasicRequestor;
import com.kms.katalon.core.webservice.helper.RestRequestMethodHelper;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import com.kms.katalon.core.webservice.support.UrlEncoder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;

public class RestfulClient
extends BasicRequestor {
    private static final String SSL = "SSL";
    private static final String HTTPS = "https";
    private static final String DEFAULT_USER_AGENT = GlobalStringConstants.APP_NAME;
    private static final String HTTP_USER_AGENT = "User-Agent";
    private static final String[] BODY_UNSUPPORTED_METHODS = new String[]{"GET", "HEAD"};

    public RestfulClient(String projectDir, ProxyInformation proxyInfomation) {
        super(projectDir, proxyInfomation);
    }

    @Override
    public ResponseObject send(RequestObject request) throws Exception {
        ResponseObject responseObject = this.sendRequest(request);
        return responseObject;
    }

    private ResponseObject sendRequest(RequestObject request) throws Exception {
        if (StringUtils.defaultString((String)request.getRestUrl()).toLowerCase().startsWith(HTTPS)) {
            SSLContext sc = SSLContext.getInstance(SSL);
            sc.init(null, this.getTrustManagers(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        RestfulClient.processRequestParams(request);
        URL url = new URL(request.getRestUrl());
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection(this.getProxy());
        if (StringUtils.defaultString((String)request.getRestUrl()).toLowerCase().startsWith(HTTPS)) {
            ((HttpsURLConnection)httpConnection).setHostnameVerifier(this.getHostnameVerifier());
        }
        String requestMethod = request.getRestRequestMethod();
        RestfulClient.setRequestMethod(httpConnection, request.getRestRequestMethod());
        httpConnection.setRequestProperty(HTTP_USER_AGENT, DEFAULT_USER_AGENT);
        this.setHttpConnectionHeaders(httpConnection, request);
        if (this.isBodySupported(requestMethod) && request.getBodyContent() != null) {
            httpConnection.setDoOutput(true);
            OutputStream os = httpConnection.getOutputStream();
            request.getBodyContent().writeTo(os);
            os.flush();
            os.close();
        }
        return this.response(httpConnection);
    }

    private boolean isBodySupported(String requestMethod) {
        return RestRequestMethodHelper.isBodySupported(requestMethod);
    }

    private static void setRequestMethod(HttpURLConnection connection, String method) throws ProtocolException {
        try {
            connection.setRequestMethod(method);
        }
        catch (ProtocolException ex) {
            try {
                Field methodField = HttpURLConnection.class.getDeclaredField("method");
                methodField.setAccessible(true);
                if (connection instanceof HttpsURLConnection) {
                    try {
                        Field delegateField = connection.getClass().getDeclaredField("delegate");
                        delegateField.setAccessible(true);
                        Object delegateConnection = delegateField.get(connection);
                        if (delegateConnection instanceof HttpURLConnection) {
                            methodField.set(delegateConnection, method);
                        }
                        Field httpsURLConnectionField = delegateConnection.getClass().getDeclaredField("httpsURLConnection");
                        httpsURLConnectionField.setAccessible(true);
                        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpsURLConnectionField.get(delegateConnection);
                        methodField.set(httpsURLConnection, method);
                    }
                    catch (Exception exception) {}
                }
                methodField.set(connection, method);
            }
            catch (Exception exception) {
                throw ex;
            }
        }
    }

    public static void processRequestParams(RequestObject request) throws MalformedURLException {
        StringBuilder paramString = new StringBuilder();
        for (TestObjectProperty property : request.getRestParameters()) {
            if (StringUtils.isEmpty((String)property.getName())) continue;
            if (!StringUtils.isEmpty((String)paramString.toString())) {
                paramString.append("&");
            }
            paramString.append(UrlEncoder.encode(property.getName()));
            paramString.append("=");
            paramString.append(UrlEncoder.encode(property.getValue()));
        }
        if (!StringUtils.isEmpty((String)paramString.toString())) {
            URL url = new URL(request.getRestUrl());
            request.setRestUrl(String.valueOf(request.getRestUrl()) + (StringUtils.isEmpty((String)url.getQuery()) ? "?" : "&") + paramString.toString());
        }
    }

    private ResponseObject response(HttpURLConnection conn) throws Exception {
        if (conn == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        int statusCode = conn.getResponseCode();
        long waitingTime = System.currentTimeMillis() - startTime;
        long contentDownloadTime = 0L;
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[1024];
        long bodyLength = 0L;
        Throwable throwable = null;
        Object var14_12 = null;
        try (InputStream inputStream = statusCode >= 400 ? conn.getErrorStream() : conn.getInputStream();){
            if (inputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                int len = 0;
                startTime = System.currentTimeMillis();
                while ((len = reader.read(buffer)) != -1) {
                    contentDownloadTime += System.currentTimeMillis() - startTime;
                    sb.append(buffer, 0, len);
                    bodyLength += (long)len;
                    startTime = System.currentTimeMillis();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        long headerLength = WebServiceCommonHelper.calculateHeaderLength(conn);
        ResponseObject responseObject = new ResponseObject(sb.toString());
        responseObject.setContentType(conn.getContentType());
        responseObject.setHeaderFields(conn.getHeaderFields());
        responseObject.setStatusCode(statusCode);
        responseObject.setResponseBodySize(bodyLength);
        responseObject.setResponseHeaderSize(headerLength);
        responseObject.setWaitingTime(waitingTime);
        responseObject.setContentDownloadTime(contentDownloadTime);
        this.setBodyContent(conn, sb, responseObject);
        conn.disconnect();
        return responseObject;
    }
}

