/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.auth.oauth.OAuthRsaSigner;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.impl.HttpFormDataBodyContent;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.util.BrowserMobProxyManager;
import com.kms.katalon.core.util.internal.ProxyUtil;
import com.kms.katalon.core.webservice.common.PrivateKeyReader;
import com.kms.katalon.core.webservice.common.Requestor;
import com.kms.katalon.core.webservice.exception.WebServiceException;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;

public abstract class BasicRequestor
implements Requestor {
    private String projectDir;
    private ProxyInformation proxyInformation;

    public BasicRequestor(String projectDir, ProxyInformation proxyInformation) {
        this.projectDir = projectDir;
        this.proxyInformation = proxyInformation;
    }

    private SSLCertificateOption getSslCertificateOption() throws IOException {
        return WebServiceSettingStore.create(this.projectDir).getSSLCertificateOption();
    }

    protected TrustManager[] getTrustManagers() throws IOException {
        if (this.getSslCertificateOption() == SSLCertificateOption.BYPASS) {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        return new TrustManager[0];
    }

    public HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                try {
                    return BasicRequestor.this.getSslCertificateOption() == SSLCertificateOption.BYPASS;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        };
    }

    public Proxy getProxy() throws WebServiceException {
        Proxy systemProxy = this.getSystemProxy();
        if (this.proxyInformation.getDisableMobBroserProxy()) {
            return systemProxy;
        }
        Proxy proxy = BrowserMobProxyManager.getWebServiceProxy((Proxy)systemProxy);
        return proxy;
    }

    private Proxy getSystemProxy() throws WebServiceException {
        if (this.proxyInformation == null) {
            return Proxy.NO_PROXY;
        }
        try {
            return ProxyUtil.getProxy((ProxyInformation)this.proxyInformation);
        }
        catch (URISyntaxException e) {
            throw new WebServiceException(e);
        }
        catch (IOException e) {
            throw new WebServiceException(e);
        }
    }

    protected void setHttpConnectionHeaders(HttpURLConnection con, RequestObject request) throws GeneralSecurityException, IOException {
        List<TestObjectProperty> complexAuthAttributes = request.getHttpHeaderProperties().stream().filter(header -> StringUtils.startsWith((String)header.getName(), (String)"Authorization:")).collect(Collectors.toList());
        ArrayList<TestObjectProperty> headers = new ArrayList<TestObjectProperty>(request.getHttpHeaderProperties());
        if (!complexAuthAttributes.isEmpty()) {
            headers.removeAll(complexAuthAttributes);
            String authorizationValue = BasicRequestor.generateAuthorizationHeader(this.getRequestUrl(request), complexAuthAttributes);
            if (!authorizationValue.isEmpty()) {
                headers.add(new TestObjectProperty("Authorization", ConditionType.EQUALS, authorizationValue));
            }
        }
        headers.forEach(header -> {
            if (request.getBodyContent() instanceof HttpFormDataBodyContent && header.getName().equalsIgnoreCase("Content-Type")) {
                con.setRequestProperty(header.getName(), request.getBodyContent().getContentType());
            } else {
                con.setRequestProperty(header.getName(), header.getValue());
            }
        });
    }

    private String getRequestUrl(RequestObject request) {
        return StringUtils.equals((String)request.getServiceType(), (String)"RESTful") ? request.getRestUrl() : request.getWsdlAddress();
    }

    private static String generateAuthorizationHeader(String requestUrl, List<TestObjectProperty> complexAuthAttributes) throws GeneralSecurityException, IOException {
        Map<String, String> map = complexAuthAttributes.stream().collect(Collectors.toMap(TestObjectProperty::getName, TestObjectProperty::getValue));
        String authType = map.get("Authorization:type");
        if (StringUtils.isBlank((String)authType)) {
            return "";
        }
        if ("OAuth 1.0".equals(authType)) {
            return BasicRequestor.createOAuth1AuthorizationHeaderValue(requestUrl, map);
        }
        return "";
    }

    public static String createOAuth1AuthorizationHeaderValue(String requestUrl, Map<String, String> map) throws GeneralSecurityException, IOException {
        String realm;
        String tokenSecret;
        String consumerSecret;
        OAuthParameters params = new OAuthParameters();
        params.consumerKey = map.getOrDefault("Authorization:oauth_consumer_key", "");
        String signatureMethod = map.getOrDefault("Authorization:oauth_signature_method", "");
        OAuthSigner signer = BasicRequestor.getSigner(signatureMethod, consumerSecret = map.getOrDefault("Authorization:oauth_consumer_secret", ""), tokenSecret = map.getOrDefault("Authorization:oauth_token_secret", ""));
        if (signer == null) {
            return "";
        }
        params.signer = signer;
        params.computeNonce();
        params.computeTimestamp();
        params.version = "1.0";
        String token = map.getOrDefault("Authorization:oauth_token", "");
        if (StringUtils.isNotBlank((String)token)) {
            params.token = token;
        }
        if (StringUtils.isNotBlank((String)(realm = map.getOrDefault("Authorization:realm", "")))) {
            params.realm = realm;
        }
        params.computeSignature("GET", new GenericUrl(requestUrl));
        return params.getAuthorizationHeader();
    }

    private static OAuthSigner getSigner(String signatureMethod, String consumerSecret, String tokenSecret) throws IOException, GeneralSecurityException {
        if (StringUtils.equals((String)signatureMethod, (String)"HMAC-SHA1")) {
            OAuthHmacSigner signer = new OAuthHmacSigner();
            signer.clientSharedSecret = consumerSecret;
            if (StringUtils.isNotBlank((String)tokenSecret)) {
                signer.tokenSharedSecret = tokenSecret;
            }
            return signer;
        }
        if (StringUtils.equals((String)signatureMethod, (String)"RSA-SHA1")) {
            OAuthRsaSigner signer = new OAuthRsaSigner();
            signer.privateKey = PrivateKeyReader.getPrivateKey(consumerSecret);
            return signer;
        }
        return null;
    }

    protected void setBodyContent(HttpURLConnection conn, StringBuffer sb, ResponseObject responseObject) {
        String contentTypeHeader;
        String contentType = contentTypeHeader = conn.getHeaderField("Content-Type");
        String charset = "UTF-8";
        if (contentTypeHeader != null && contentTypeHeader.contains(";")) {
            contentType = contentTypeHeader.split(";")[0].trim();
            int charsetIdx = contentTypeHeader.lastIndexOf("charset=");
            if (charsetIdx >= 0) {
                int separatorIdx = StringUtils.indexOf((String)contentTypeHeader, (String)";", (int)charsetIdx);
                if (separatorIdx < 0) {
                    separatorIdx = contentTypeHeader.length();
                }
                charset = contentTypeHeader.substring(charsetIdx + "charset=".length(), separatorIdx).trim().replace("\"", "");
            }
        }
        HttpTextBodyContent textBodyContent = new HttpTextBodyContent(sb.toString(), charset, contentType);
        responseObject.setBodyContent((HttpBodyContent)textBodyContent);
        responseObject.setContentCharset(charset);
    }
}

