/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.groovy.reference;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class TestArtifactScriptRefactor {
    private FolderEntity.FolderType parentType;
    private String entityId;
    private boolean hasRightBracket;
    private boolean hasRightQuote;
    private boolean hasRightDoubleQuote;
    private boolean isFolder;

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote) {
        this(parentType, entityId, hasRightBracket, hasRightQuote, hasRightDoubleQuote, false);
    }

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote, boolean isFolder) {
        this.parentType = parentType;
        this.entityId = entityId;
        this.hasRightBracket = hasRightBracket;
        this.hasRightQuote = hasRightQuote;
        this.hasRightDoubleQuote = hasRightDoubleQuote;
        this.isFolder = isFolder;
    }

    public FolderEntity.FolderType getParentType() {
        return this.parentType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    private String getReferencePrefix() {
        switch (this.parentType) {
            case DATAFILE: {
                return "findTestData";
            }
            case TESTCASE: {
                return "findTestCase";
            }
            case WEBELEMENT: {
                return "findTestObject";
            }
            case CHECKPOINT: {
                return "findCheckpoint";
            }
        }
        return "";
    }

    private String getRelativeId(String s) {
        int firstSeparatorIdx = s.indexOf("/");
        if (firstSeparatorIdx < 0) {
            return s;
        }
        return s.substring(firstSeparatorIdx + (this.isFolder ? 0 : 1), s.length());
    }

    private String buildParentheses(String s) {
        return "(" + s + (this.hasRightBracket ? ")" : "");
    }

    private String buildQuote(String s) {
        return "'" + s + (this.hasRightQuote ? "'" : "");
    }

    private String buildDoubleQuotes(String s) {
        return "\"" + s + (this.hasRightDoubleQuote ? "\"" : "");
    }

    public List<String> getReferenceStrings() {
        ArrayList<String> referenceString = new ArrayList<String>();
        referenceString.addAll(this.getQuotedReferences());
        referenceString.addAll(this.getDoubleQuotedReferenceStrings());
        return referenceString;
    }

    private List<String> getQuotedReferences() {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(this.entityId);
        return Arrays.asList(String.valueOf(prefix) + this.buildParentheses(this.buildQuote(this.entityId)), String.valueOf(prefix) + this.buildParentheses(this.buildQuote(relativeId)));
    }

    private List<String> getDoubleQuotedReferenceStrings() {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(this.entityId);
        return Arrays.asList(String.valueOf(prefix) + this.buildParentheses(this.buildDoubleQuotes(this.entityId)), String.valueOf(prefix) + this.buildParentheses(this.buildDoubleQuotes(relativeId)));
    }

    public void replace(String newEntityId, IFile scriptFile) throws IOException, CoreException {
        String scriptContent = this.getScriptContent(scriptFile);
        String relativeId = this.getRelativeId(newEntityId);
        String referencePrefix = this.getReferencePrefix();
        boolean updated = false;
        String newQuotedScript = String.valueOf(referencePrefix) + this.buildParentheses(this.buildQuote(relativeId));
        for (String potentialQuote : this.getQuotedReferences()) {
            if (!scriptContent.contains(potentialQuote)) continue;
            scriptContent = scriptContent.replace(potentialQuote, newQuotedScript);
            updated = true;
        }
        String newDoubleQuotedScript = String.valueOf(referencePrefix) + this.buildParentheses(this.buildDoubleQuotes(relativeId));
        for (String potentialDoubleQuotes : this.getDoubleQuotedReferenceStrings()) {
            if (!scriptContent.contains(potentialDoubleQuotes)) continue;
            scriptContent = scriptContent.replace(potentialDoubleQuotes, newDoubleQuotedScript);
            updated = true;
        }
        if (!updated) {
            return;
        }
        Object object = null;
        Iterator<String> iterator = null;
        try (InputStream is = IOUtils.toInputStream((String)scriptContent, (String)"UTF-8");){
            scriptFile.setContents(is, true, true, null);
            scriptFile.refreshLocal(0, null);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private String getScriptContent(IFile scriptFile) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream scriptFileStreamContent = scriptFile.getContents();){
            return IOUtils.toString((InputStream)scriptFileStreamContent, (String)"UTF-8");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean hasReferenceInScript(IFile scriptFile) throws IOException, CoreException {
        String scriptContent = this.getScriptContent(scriptFile);
        for (String potentialRef : this.getReferenceStrings()) {
            if (!scriptContent.contains(potentialRef)) continue;
            return true;
        }
        return false;
    }

    public List<IFile> findReferrers(List<IFile> files) throws IOException, CoreException {
        ArrayList<IFile> referrers = new ArrayList<IFile>();
        for (IFile scriptFile : files) {
            if (!this.hasReferenceInScript(scriptFile)) continue;
            referrers.add(scriptFile);
        }
        return referrers;
    }

    public List<IFile> findReferrersInTestCaseScripts(ProjectEntity projectEntity) throws IOException, CoreException {
        return this.findReferrers(GroovyUtil.getAllTestCaseScripts(projectEntity));
    }

    public void updateReferenceForProject(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferenceForTestCaseFolder(newScript, projectEntity);
        this.updateReferenceForCustomKeywords(newScript, projectEntity);
    }

    public void updateReferenceForTestCaseFolder(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllTestCaseScripts(projectEntity));
    }

    public void updateReferenceForCustomKeywords(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllCustomKeywordsScripts(projectEntity));
    }

    public void updateReferences(String newScript, List<IFile> files) throws IOException, CoreException {
        for (IFile scriptFile : files) {
            this.replace(newScript, scriptFile);
        }
    }

    public void removeReferences(List<IFile> files) throws IOException, CoreException {
        this.updateReferences(GlobalStringConstants.NULL, files);
    }

    public static TestArtifactScriptRefactor createForTestDataEntity(String testDataId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.DATAFILE, testDataId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestCaseEntity(String testCaseId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.TESTCASE, testCaseId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestObjectEntity(String testObjectId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.WEBELEMENT, testObjectId, false, true, true);
    }

    public static TestArtifactScriptRefactor createForCheckpointEntity(String checkpointId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.CHECKPOINT, checkpointId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForFolderEntity(FolderEntity folder) {
        return new TestArtifactScriptRefactor(folder.getFolderType(), String.valueOf(folder.getIdForDisplay()) + "/", false, false, false, true);
    }
}

