/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ApplicationProxyUtil {
    private static final String USE_SYSTEM_PROXY_PROP = "java.net.useSystemProxies";

    public static void saveProxyInformation(ProxyInformation proxyInfo) {
        ApplicationInfo.setAppProperty("proxy.option", proxyInfo.getProxyOption(), false);
        ApplicationInfo.setAppProperty("proxy.serverType", proxyInfo.getProxyServerType(), false);
        ApplicationInfo.setAppProperty("proxy.serverAddress", proxyInfo.getProxyServerAddress(), false);
        ApplicationInfo.setAppProperty("proxy.serverPort", String.valueOf(proxyInfo.getProxyServerPort()), false);
        ApplicationInfo.setAppProperty("proxy.username", proxyInfo.getUsername(), false);
        ApplicationInfo.setAppProperty("proxy.password", proxyInfo.getPassword(), true);
    }

    public static ProxyInformation getProxyInformation() {
        ProxyInformation proxyInfo = new ProxyInformation();
        String proxyOption = ApplicationInfo.getAppProperty("proxy.option");
        proxyInfo.setProxyOption(StringUtils.isEmpty((CharSequence)proxyOption) ? ApplicationMessageConstants.NO_PROXY : proxyOption);
        proxyInfo.setProxyServerType(ApplicationInfo.getAppProperty("proxy.serverType"));
        proxyInfo.setProxyServerAddress(ApplicationInfo.getAppProperty("proxy.serverAddress"));
        proxyInfo.setProxyServerPort(ApplicationInfo.getAppProperty("proxy.serverPort"));
        proxyInfo.setUsername(ApplicationInfo.getAppProperty("proxy.username"));
        proxyInfo.setPassword(ApplicationInfo.getAppProperty("proxy.password"));
        return proxyInfo;
    }

    public static Proxy getProxy() throws IOException {
        Proxy proxy;
        ProxyInformation proxyInfo;
        block15: {
            block16: {
                proxyInfo = ApplicationProxyUtil.getProxyInformation();
                proxy = Proxy.NO_PROXY;
                if (!ApplicationMessageConstants.USE_SYSTEM_PROXY.equals(proxyInfo.getProxyOption())) break block16;
                proxy = ApplicationProxyUtil.getSystemProxyFor(ServerAPICommunicationUtil.getAPIUrl());
                break block15;
            }
            if (!ApplicationMessageConstants.MANUAL_CONFIG_PROXY.equals(proxyInfo.getProxyOption())) break block15;
            System.setProperty(USE_SYSTEM_PROXY_PROP, "false");
            try {
                switch (proxyInfo.getProxyServerType()) {
                    case "SOCKS": {
                        proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyInfo.getProxyServerAddress(), proxyInfo.getProxyServerPort()));
                        break;
                    }
                    case "HTTP": 
                    case "HTTPS": {
                        proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo.getProxyServerAddress(), proxyInfo.getProxyServerPort()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(ApplicationMessageConstants.PROXY_SERVER_TYPE_NOT_VALID_MESSAGE);
                    }
                }
            }
            catch (IllegalArgumentException | SecurityException ex) {
                throw new IOException(ex);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyInfo.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.getUsername(), proxyInfo.getPassword().toCharArray());
                }
            });
        }
        return proxy;
    }

    public static Proxy getRetryProxy() throws URISyntaxException {
        final ProxyInformation proxyInfo = ApplicationProxyUtil.getProxyInformation();
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyInfo.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.getUsername(), proxyInfo.getPassword().toCharArray());
                }
            });
        }
        ProxySelector proxySelector = ApplicationProxyUtil.getProxySearch().getProxySelector();
        Proxy proxy = Proxy.NO_PROXY;
        if (proxySelector != null) {
            proxy = ApplicationProxyUtil.getProxy(proxySelector);
        }
        if (!Proxy.NO_PROXY.equals(proxy)) {
            LogUtil.printOutputLine((String)MessageFormat.format(ApplicationMessageConstants.PROXY_FOUND, proxy.toString()));
        } else {
            LogUtil.printOutputLine((String)ApplicationMessageConstants.NO_PROXY_FOUND);
        }
        return proxy;
    }

    private static ProxySearch getProxySearch() {
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            proxySearch.addStrategy(ProxySearch.Strategy.IE);
            proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
            proxySearch.addStrategy(ProxySearch.Strategy.GNOME);
            proxySearch.addStrategy(ProxySearch.Strategy.KDE);
            proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
        }
        return proxySearch;
    }

    private static Proxy getProxy(ProxySelector proxySelector) throws URISyntaxException {
        Proxy proxy = Proxy.NO_PROXY;
        List<Proxy> proxies = proxySelector.select(new URI(ServerAPICommunicationUtil.getAPIUrl()));
        if (proxySelector != null && proxies != null) {
            block4: for (Proxy p : proxies) {
                switch (p.type()) {
                    case HTTP: {
                        proxy = p;
                        break block4;
                    }
                    case DIRECT: {
                        proxy = p;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
        }
        return proxy;
    }

    public static Proxy getSystemProxyFor(String url) {
        try {
            System.setProperty(USE_SYSTEM_PROXY_PROP, "true");
            List<Proxy> systemProxies = ProxySelector.getDefault().select(new URI(url));
            Optional<Proxy> sysProxy = systemProxies.stream().filter(proxy -> proxy.address() != null).findFirst();
            return sysProxy.isPresent() ? sysProxy.get() : Proxy.NO_PROXY;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return Proxy.NO_PROXY;
        }
    }
}

