/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.kms.katalon.application.constants.ApplicationStringConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.logging.LogManager;
import com.kms.katalon.logging.LogMode;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.logging.SystemLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class ApplicationInfo {
    public static final String DEV_PROFILE = "dev";
    public static final String STAG_PROFILE = "stag";
    public static final String PROD_PROFILE = "prod";
    private static final String ABOUT_MAPPINGS_FILE_NAME = "about.mappings";
    private static final String ABOUT_BUILD_NUMBER_KEY = "0";
    private static final String ABOUT_VERSION_NUMBER_KEY = "1";
    private static final String ABOUT_PROFILE_KEY = "2";
    private static Properties aboutMappingsProperties;
    private static Properties appProperties;

    private static Properties getAboutMappingsProperties() {
        if (aboutMappingsProperties != null && !aboutMappingsProperties.isEmpty()) {
            return aboutMappingsProperties;
        }
        aboutMappingsProperties = new Properties();
        try {
            aboutMappingsProperties.load(Platform.getBundle((String)"com.kms.katalon").getResource(ABOUT_MAPPINGS_FILE_NAME).openStream());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return aboutMappingsProperties;
    }

    public static String versionNo() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_VERSION_NUMBER_KEY, GlobalStringConstants.EMPTY);
    }

    public static String buildNo() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_BUILD_NUMBER_KEY, GlobalStringConstants.EMPTY);
    }

    public static String profile() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_PROFILE_KEY, DEV_PROFILE);
    }

    public static String installLocation() {
        try {
            return Paths.get(new URI(Platform.getInstallLocation().getURL().toString().replace(" ", "%20"))).toString();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return ApplicationStringConstants.EMPTY;
    }

    public static String userDirLocation() {
        return ApplicationStringConstants.APP_USER_DIR_LOCATION;
    }

    public static void setAppInfoIntoUserHomeDir() {
        String version = ApplicationInfo.versionNo();
        String buildNo = ApplicationInfo.buildNo();
        ApplicationInfo.getAppProperties();
        System.setProperty("katalon.versionNumber", version);
        ApplicationInfo.logInfo("katalon.versionNumber=" + version);
        ApplicationInfo.logInfo("katalon.buildNumber=" + buildNo);
        if (version.equals(ApplicationInfo.getAppProperty("katalon.versionNumber")) && buildNo.equals(ApplicationInfo.getAppProperty("katalon.buildNumber"))) {
            return;
        }
        ApplicationInfo.setAppProperty("katalon.versionNumber", version, false);
        ApplicationInfo.setAppProperty("katalon.buildNumber", buildNo, false);
        ApplicationInfo.saveAppProperties();
    }

    private static Properties getAppProperties() {
        if (appProperties != null) {
            return appProperties;
        }
        File appPropFile = new File(ApplicationStringConstants.APP_INFO_FILE_LOCATION);
        File katalonDir = new File(ApplicationInfo.userDirLocation());
        if (!appPropFile.exists()) {
            if (!katalonDir.exists()) {
                katalonDir.mkdir();
            }
            try {
                appPropFile.createNewFile();
            }
            catch (Exception ex) {
                LogUtil.logError((Throwable)ex);
            }
        }
        try {
            Throwable ex = null;
            Object var3_6 = null;
            try (FileInputStream in = new FileInputStream(appPropFile);){
                appProperties = new Properties();
                appProperties.load(in);
            }
            catch (Throwable throwable) {
                if (ex == null) {
                    ex = throwable;
                } else if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            appProperties = null;
            LogUtil.logError((Throwable)ex);
        }
        return appProperties;
    }

    public static void setAppProperty(String key, String value, boolean autoSave) {
        Properties appProps = ApplicationInfo.getAppProperties();
        appProps.setProperty(key, value);
        if (autoSave) {
            ApplicationInfo.saveAppProperties();
        }
    }

    public static String getAppProperty(String key) {
        Properties appProps = ApplicationInfo.getAppProperties();
        if (appProps != null && appProps.containsKey(key)) {
            return appProps.getProperty(key);
        }
        return null;
    }

    private static void saveAppProperties() {
        if (appProperties == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (FileOutputStream out = new FileOutputStream(ApplicationStringConstants.APP_INFO_FILE_LOCATION);){
                appProperties.store(out, ApplicationInfo.installLocation());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    private static void logInfo(String message) {
        LogUtil.println((SystemLogger)LogManager.getOutputLogger(), (String)message, (LogMode)LogMode.LOG);
    }

    public static void removeAppProperty(String key) {
        Properties appProps = ApplicationInfo.getAppProperties();
        if (appProps != null && appProps.containsKey(key)) {
            appProps.remove(key);
            ApplicationInfo.saveAppProperties();
        }
    }
}

