/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;

public class ActivationInfoCollector {
    public static final String DEFAULT_HOST_NAME = "can.not.get.host.name";

    protected ActivationInfoCollector() {
    }

    public static boolean isActivated() {
        String[] activateParts;
        block6: {
            String activatedVal;
            block5: {
                activatedVal = ApplicationInfo.getAppProperty("activated");
                if (activatedVal == null) {
                    return false;
                }
                try {
                    String updatedVersion = ApplicationInfo.getAppProperty("updatedVersion");
                    if (!ApplicationInfo.versionNo().equals(ActivationInfoCollector.getVersionNo(updatedVersion))) break block5;
                    ActivationInfoCollector.setActivatedVal();
                    return true;
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                    return false;
                }
            }
            activateParts = activatedVal.split("_");
            String oldVersion = new StringBuilder(activateParts[0]).reverse().toString();
            String curVersion = ApplicationInfo.versionNo().replaceAll("\\.", "");
            if (oldVersion.equals(curVersion)) break block6;
            return false;
        }
        int activatedHashVal = Integer.parseInt(activateParts[1]);
        return activatedHashVal == ActivationInfoCollector.getHostNameHashValue();
    }

    private static int getHostNameHashValue() throws Exception {
        String ipAddress;
        String hostName = InetAddress.getLocalHost().getHostName();
        if (hostName.equals(ipAddress = InetAddress.getLocalHost().getHostAddress())) {
            hostName = DEFAULT_HOST_NAME;
        }
        return Objects.hash(hostName);
    }

    private static String collectActivationInfo(String userName, String pass) {
        JsonObject traits = ActivationInfoCollector.traitsWithAppInfo();
        traits.addProperty("password", StringEscapeUtils.escapeJava((String)pass).replace("'", "\\'"));
        JsonObject activationObject = new JsonObject();
        activationObject.addProperty("userId", userName);
        activationObject.add("traits", (JsonElement)traits);
        return activationObject.toString();
    }

    public static JsonObject traitsWithAppInfo() {
        JsonObject traits = new JsonObject();
        String katVersion = String.valueOf(ApplicationInfo.versionNo()) + " build " + ApplicationInfo.buildNo();
        String osType = Platform.getOSArch().contains("64") ? "64" : "32";
        String host = "";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            host = "unknown";
        }
        traits.addProperty("host_name", host);
        traits.addProperty("os", Platform.getOS());
        traits.addProperty("os_type", osType);
        traits.addProperty("kat_version", katVersion);
        traits.addProperty("kat_type", System.getProperty("sun.arch.data.model"));
        traits.addProperty("sessionId", KatalonApplication.SESSION_ID);
        traits.addProperty("user_key", KatalonApplication.USER_KEY);
        return traits;
    }

    public static boolean activate(String userName, String pass, StringBuilder errorMessage) {
        boolean activatedResult = false;
        try {
            String userInfo = ActivationInfoCollector.collectActivationInfo(userName, pass);
            String result = ServerAPICommunicationUtil.post("/segment/identify", userInfo);
            if (result.equals(ApplicationMessageConstants.SEND_SUCCESS_RESPONSE)) {
                ActivationInfoCollector.markActivated(userName);
                activatedResult = true;
            } else if (errorMessage != null) {
                errorMessage.append(ApplicationMessageConstants.ACTIVATE_INFO_INVALID);
            }
        }
        catch (IOException ex) {
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.ACTIVATION_COLLECT_FAIL_MESSAGE);
            if (errorMessage != null) {
                errorMessage.delete(0, errorMessage.length());
                errorMessage.append(ApplicationMessageConstants.NETWORK_ERROR);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return activatedResult;
    }

    public static boolean activate(String activationCode, StringBuilder errorMessage) {
        block5: {
            block4: {
                String checkCode = activationCode.substring(0, 2);
                activationCode = new StringBuilder(activationCode.substring(2)).reverse().toString();
                int idx = Integer.parseInt(String.valueOf(checkCode.charAt(0)));
                if (activationCode.charAt(idx) != checkCode.charAt(1)) break block4;
                ActivationInfoCollector.markActivated(activationCode);
                return true;
            }
            try {
                if (errorMessage != null) {
                    errorMessage.append(ApplicationMessageConstants.ACTIVATION_CODE_INVALID);
                }
            }
            catch (Exception ex) {
                LogUtil.logError((Throwable)ex);
                if (errorMessage == null) break block5;
                errorMessage.append(ApplicationMessageConstants.ACTIVATION_CODE_INVALID);
            }
        }
        return false;
    }

    private static void markActivated(String userName) throws Exception {
        ActivationInfoCollector.setActivatedVal();
        ApplicationInfo.removeAppProperty("activatedRequestCode");
        ApplicationInfo.setAppProperty("email", userName, true);
    }

    private static void setActivatedVal() throws Exception {
        String activatedVal = Integer.toString(ActivationInfoCollector.getHostNameHashValue());
        String curVersion = new StringBuilder(ApplicationInfo.versionNo().replaceAll("\\.", "")).reverse().toString();
        ApplicationInfo.setAppProperty("activated", String.valueOf(curVersion) + "_" + activatedVal, true);
    }

    public static void markActivatedViaUpgradation(String versionNumber) {
        ApplicationInfo.setAppProperty("updatedVersion", ActivationInfoCollector.getVersionNo(versionNumber), true);
    }

    private static String getVersionNo(String versionNumber) {
        if (versionNumber == null) {
            return versionNumber;
        }
        Object[] numbers = versionNumber.split("\\.");
        while (numbers.length < 3) {
            numbers = (String[])ArrayUtils.add((Object[])numbers, (Object)"0");
        }
        return StringUtils.join((Object[])ArrayUtils.subarray((Object[])numbers, (int)0, (int)3), (String)".");
    }
}

