/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Text;

public class TestDataIDColumnLabelProvider
extends StyledCellLabelProvider {
    private Text textSearch;

    public TestDataIDColumnLabelProvider(Text textSearch) {
        this.textSearch = textSearch;
    }

    public void update(ViewerCell cell) {
        TestCaseTestDataLink testDataLink = (TestCaseTestDataLink)cell.getElement();
        cell.setText(testDataLink.getTestDataId());
        switch (testDataLink.getCombinationType()) {
            case MANY: {
                cell.setImage(ImageConstants.IMG_16_DATA_CROSS);
                break;
            }
            case ONE: {
                cell.setImage(ImageConstants.IMG_16_DATA_ONE_ONE);
            }
        }
        String cellText = cell.getText().toLowerCase();
        String searchString = this.textSearch.getText().toLowerCase();
        if (searchString.isEmpty()) {
            cell.setStyleRanges(null);
        } else {
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            Matcher matcher = Pattern.compile(searchString).matcher(cellText);
            while (matcher.find()) {
                int rangeLength = matcher.end() - matcher.start();
                StyleRange myStyledRange = new StyleRange(matcher.start(), rangeLength, null, cell.getControl().getDisplay().getSystemColor(7));
                styleRanges.add(myStyledRange);
            }
            cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
        }
        super.update(cell);
    }
}

