/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;

public class TestCaseTableLabelProvider
extends StyledCellLabelProvider {
    public static final int COLUMN_NOTIFICATION_INDEX = 0;
    public static final int COLUMN_ORDER_INDEX = 1;
    public static final int COLUMN_ID_INDEX = 2;
    public static final int COLUMN_DESCRIPTION_INDEX = 3;
    public static final int COLUMN_RUN_INDEX = 4;
    private static TestCaseController testCaseController = TestCaseController.getInstance();
    private int columnIndex;

    public TestCaseTableLabelProvider(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    protected void paint(Event event, Object element) {
        if (element == null || !(element instanceof TestSuiteTestCaseLink)) {
            return;
        }
        GC gc = event.gc;
        if (this.columnIndex == 4) {
            if (((TestSuiteTestCaseLink)element).getIsRun()) {
                gc.drawImage(ImageConstants.IMG_16_CHECKBOX_CHECKED, event.getBounds().x + 5, event.getBounds().y);
            } else {
                gc.drawImage(ImageConstants.IMG_16_CHECKBOX_UNCHECKED, event.getBounds().x + 5, event.getBounds().y);
            }
        } else if (this.columnIndex == 0) {
            if (this.getTestCase(element) == null) {
                gc.drawImage(ImageConstants.IMG_16_NOTIFICATION_HEADER, event.getBounds().x + 2, event.getBounds().y);
            }
        } else {
            super.paint(event, element);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getColumnText(Object element) {
        TestCaseEntity testCase = this.getTestCase(element);
        try {
            TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
            Object allTestCaseLinks = this.getTestCaseTableViewer().getInput();
            switch (this.columnIndex) {
                case 1: {
                    return Integer.toString(allTestCaseLinks.indexOf(testCaseLink) + 1);
                }
                case 2: {
                    return testCaseLink.getTestCaseId();
                }
                case 3: {
                    if (testCase != null) return testCase.getDescription();
                    return "";
                }
                case 4: {
                    return "";
                }
            }
            return "";
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return "";
    }

    public String getToolTipText(Object element) {
        if (this.columnIndex == 0 && this.getTestCase(element) == null) {
            TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
            return MessageFormat.format(StringConstants.LP_WARN_MSG_TEST_CASE_MISSING, testCaseLink.getTestCaseId());
        }
        return StringUtils.defaultIfEmpty((String)this.getColumnText(element), null);
    }

    public void update(ViewerCell cell) {
        String searchString;
        String cellText = this.getColumnText(cell.getElement());
        cell.setText(cellText);
        cell.setImage(null);
        if (this.columnIndex == 2) {
            TextLayout textLayout = new TextLayout((Device)cell.getControl().getDisplay());
            textLayout.setText(cellText);
            Table table = (Table)this.getViewer().getControl();
            if (textLayout.getBounds().width + 5 > table.getColumn(this.columnIndex).getWidth()) {
                int textNameIdx = Math.max(0, cellText.lastIndexOf("/"));
                cell.setText(".." + cellText.substring(textNameIdx, cellText.length()));
            }
        }
        if (this.getTestCase(cell.getElement()) == null) {
            if (this.columnIndex == 2) {
                cell.setForeground(ColorUtil.getErrorTableItemForegroundColor());
            }
        } else {
            cell.setForeground(ColorUtil.getDefaultTextColor());
        }
        ArrayList<StyleRange> range = new ArrayList<StyleRange>();
        if (this.columnIndex != 1 && (searchString = this.getTestCaseTableViewer().getSearchedString().trim().toLowerCase()) != null && !searchString.isEmpty()) {
            String highlightedString = this.getHighlightedString(searchString);
            if (cell.getText().toLowerCase().contains(highlightedString) && !highlightedString.isEmpty()) {
                Matcher m = Pattern.compile(Pattern.quote(highlightedString)).matcher(cell.getText().toLowerCase());
                while (m.find()) {
                    StyleRange myStyledRange = new StyleRange(m.start(), highlightedString.length(), null, ColorUtil.getHighlightBackgroundColor());
                    range.add(myStyledRange);
                }
            }
        }
        cell.setStyleRanges(range.toArray(new StyleRange[range.size()]));
        super.update(cell);
    }

    private TestCaseTableViewer getTestCaseTableViewer() {
        return (TestCaseTableViewer)this.getViewer();
    }

    private TestCaseEntity getTestCase(Object element) {
        if (!(element instanceof TestSuiteTestCaseLink)) {
            return null;
        }
        try {
            TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
            return testCaseController.getTestCaseByDisplayId(testCaseLink.getTestCaseId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getHighlightedString(String searchedString) {
        Map tagMap = EntityViewerFilter.parseSearchedString((String[])TestCaseTreeEntity.SEARCH_TAGS, (String)searchedString);
        String highlightedString = null;
        switch (this.columnIndex) {
            case 2: {
                highlightedString = (String)tagMap.get("id");
                break;
            }
            case 3: {
                highlightedString = (String)tagMap.get("description");
            }
        }
        return highlightedString == null || highlightedString.isEmpty() ? searchedString : highlightedString;
    }
}

