/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.KeyEventUtil;
import com.kms.katalon.composer.components.impl.util.MenuUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.custom.AdvancedSearchDialog;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.constants.ToolItemConstants;
import com.kms.katalon.composer.testsuite.listeners.TestCaseTableDragListener;
import com.kms.katalon.composer.testsuite.listeners.TestCaseTableDropListener;
import com.kms.katalon.composer.testsuite.listeners.TestCaseTableKeyListener;
import com.kms.katalon.composer.testsuite.listeners.TestCaseToolItemListener;
import com.kms.katalon.composer.testsuite.parts.TestSuitePart;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableLabelProvider;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewerFilter;
import com.kms.katalon.composer.testsuite.support.TestCaseIdColumnEditingSupport;
import com.kms.katalon.composer.testsuite.support.TestCaseIsRunColumnEditingSupport;
import com.kms.katalon.composer.testsuite.transfer.TestSuiteTestCaseLinkTransfer;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.webservice.support.UrlEncoder;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TestSuitePartTestCaseView {
    private static final String IS_RUN_COLUMN_HEADER = StringConstants.PA_COL_RUN;
    private static final String PK_COLUMN_HEADER = StringConstants.PA_COL_ID;
    private static final String NUMBER_COLUMN_HEADER = StringConstants.PA_COL_NO;
    private static final String DESCRIPTION_COLUMN_HEADER = StringConstants.PA_COL_DESC;
    private static final String BTN_SHOW_DATA_BINDING = ComposerTestsuiteMessageConstants.BTN_SHOW_DATA_BINDING;
    private static final String BTN_HIDE_DATA_BINDING = ComposerTestsuiteMessageConstants.BTN_HIDE_DATA_BINDING;
    private Button btnViewHistory;
    private Composite compositeTestCase;
    private TestSuitePart testSuitePart;
    private TestCaseTableViewer testCaseTableViewer;
    private Composite compositeTableSearch;
    private CLabel lblFilter;
    private CLabel lblSearch;
    private Text txtSearch;
    private boolean isSearching;
    private int testSuiteTestCaseSelectedIdx;
    private ScrolledComposite compositeTablePart;
    private TableColumn tblclmnIsRun;
    private TableColumn tblclId;
    private ToolBar testCaseToolbar;
    private TestSuitePartDataBindingView dataAndVariableView;
    private TestCaseToolItemListener testCaseToolItemListener;
    private Menu tableContextMenu;
    private ToolItem tltmShowHideDataBinding;
    private SashForm sashForm;
    private Composite compositeTableButtons;
    private AnalyticsReportService analyticsReportService = new AnalyticsReportService();
    private AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());

    TestSuitePartTestCaseView(TestSuitePart testSuitePart) {
        this.testSuitePart = testSuitePart;
        this.dataAndVariableView = new TestSuitePartDataBindingView(this);
    }

    ScrolledComposite createCompositeTestCase(Composite compositeMain) {
        this.compositeTablePart = new ScrolledComposite(compositeMain, 512);
        this.compositeTablePart.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.compositeTablePart.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.sashForm = new SashForm((Composite)this.compositeTablePart, 0);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sashForm.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.createCompositeTestCaseButtons();
        this.createCompositeTestCaseSearch();
        this.createCompositeTestCaseContent();
        this.compositeTablePart.setContent((Control)this.sashForm);
        this.compositeTablePart.setExpandHorizontal(true);
        this.compositeTablePart.setExpandVertical(true);
        this.compositeTablePart.setBackgroundMode(1);
        return this.compositeTablePart;
    }

    private void createCompositeTestCaseContent() {
        Composite compositeTableContent = new Composite(this.compositeTestCase, 0);
        compositeTableContent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.testCaseTableViewer = new TestCaseTableViewer(compositeTableContent, 67586, this);
        Table testCaseTable = this.testCaseTableViewer.getTable();
        testCaseTable.setHeaderVisible(true);
        testCaseTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnNotification = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnNotification = tableViewerColumnNotification.getColumn();
        tblclmnNotification.setImage(ImageConstants.IMG_16_NOTIFICATION_HEADER);
        tblclmnNotification.setToolTipText(GlobalStringConstants.NOTIFICATION);
        TableViewerColumn tableViewerColumnOrder = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnOrder = tableViewerColumnOrder.getColumn();
        tblclmnOrder.setText(NUMBER_COLUMN_HEADER);
        TableViewerColumn tableViewerColumnPK = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        this.tblclId = tableViewerColumnPK.getColumn();
        this.tblclId.setText(PK_COLUMN_HEADER);
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnDescription = tableViewerColumnDescription.getColumn();
        tblclmnDescription.setText(DESCRIPTION_COLUMN_HEADER);
        TableViewerColumn tableViewerColumnIsRun = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        this.tblclmnIsRun = tableViewerColumnIsRun.getColumn();
        this.tblclmnIsRun.setText(IS_RUN_COLUMN_HEADER);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnNotification, (ColumnLayoutData)new ColumnWeightData(0, 30));
        tableLayout.setColumnData((Widget)tblclmnOrder, (ColumnLayoutData)new ColumnWeightData(0, 40));
        tableLayout.setColumnData((Widget)this.tblclId, (ColumnLayoutData)new ColumnWeightData(40, 100));
        tableLayout.setColumnData((Widget)tblclmnDescription, (ColumnLayoutData)new ColumnWeightData(15, 100));
        tableLayout.setColumnData((Widget)this.tblclmnIsRun, (ColumnLayoutData)new ColumnWeightData(0, 80));
        compositeTableContent.setLayout((Layout)tableLayout);
        this.testCaseTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.testCaseTableViewer.setFilters(new ViewerFilter[]{new TestCaseTableViewerFilter()});
        this.testCaseTableViewer.getTable().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.testCaseTableViewer, (int)2);
        tableViewerColumnNotification.setLabelProvider((CellLabelProvider)new TestCaseTableLabelProvider(0));
        tableViewerColumnOrder.setLabelProvider((CellLabelProvider)new TestCaseTableLabelProvider(1));
        tableViewerColumnPK.setLabelProvider((CellLabelProvider)new TestCaseTableLabelProvider(2));
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new TestCaseTableLabelProvider(3));
        tableViewerColumnIsRun.setLabelProvider((CellLabelProvider)new TestCaseTableLabelProvider(4));
        tableViewerColumnIsRun.setEditingSupport((EditingSupport)new TestCaseIsRunColumnEditingSupport((ColumnViewer)this.testCaseTableViewer, this));
        tableViewerColumnPK.setEditingSupport((EditingSupport)new TestCaseIdColumnEditingSupport((ColumnViewer)this.testCaseTableViewer, this));
        testCaseTable.addKeyListener((KeyListener)new TestCaseTableKeyListener(this.testCaseTableViewer));
        this.createTestCaseTableContextMenu(testCaseTable);
        this.createCompositeTestDataAndVariable(this.sashForm);
        this.sashForm.setWeights(new int[]{5, 5});
        this.sashForm.setMaximizedControl((Control)this.compositeTestCase);
        this.hookDropTestCaseEvent();
        this.hookDragTestCaseEvent();
        this.setTestCaseTableViewerSelection();
    }

    private void setTestCaseTableViewerSelection() {
        this.testCaseTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuitePartTestCaseView.this.createOpenTestCaseMenu();
            }
        });
    }

    private void createTestCaseTableContextMenu(Table table) {
        this.tableContextMenu = new Menu((Control)table);
        table.setMenu(this.tableContextMenu);
        MenuItem addTestCase = new MenuItem(this.tableContextMenu, 8);
        addTestCase.setText(this.createMenuItemLabel(StringConstants.PA_TOOLITEM_ADD, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "N"})));
        addTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuitePartTestCaseView.this.testCaseTableViewer.addNewItem();
            }
        });
        MenuItem removeTestCase = new MenuItem(this.tableContextMenu, 8);
        removeTestCase.setText(this.createMenuItemLabel(StringConstants.PA_TOOLITEM_REMOVE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"DEL"})));
        removeTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuitePartTestCaseView.this.testCaseTableViewer.removeSelectedItems();
            }
        });
        MenuItem moveTestCaseUp = new MenuItem(this.tableContextMenu, 8);
        moveTestCaseUp.setText(this.createMenuItemLabel(StringConstants.PA_TOOLITEM_UP, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "ARROW_UP"})));
        moveTestCaseUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuitePartTestCaseView.this.testCaseTableViewer.moveSelectedItemsUp();
            }
        });
        MenuItem moveTestCaseDown = new MenuItem(this.tableContextMenu, 8);
        moveTestCaseDown.setText(this.createMenuItemLabel(StringConstants.PA_TOOLITEM_DOWN, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "ARROW_DOWN"})));
        moveTestCaseDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuitePartTestCaseView.this.testCaseTableViewer.moveSelectedItemsDown();
            }
        });
    }

    private String createMenuItemLabel(String text, String keyCombination) {
        return String.valueOf(text) + "\t" + keyCombination;
    }

    private void createCompositeTestDataAndVariable(SashForm sashForm) {
        this.dataAndVariableView.createCompositeTestDataAndVariable(sashForm);
    }

    private void hookDropTestCaseEvent() {
        DropTarget dt = new DropTarget((Control)this.testCaseTableViewer.getTable(), 3);
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        treeEntityTransfers.add(new TestSuiteTestCaseLinkTransfer());
        dt.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dt.addDropListener((DropTargetListener)new TestCaseTableDropListener(this.testCaseTableViewer));
    }

    private void hookDragTestCaseEvent() {
        int operations = 3;
        DragSource dragSource = new DragSource((Control)this.testCaseTableViewer.getTable(), operations);
        dragSource.setTransfer(new Transfer[]{new TestSuiteTestCaseLinkTransfer()});
        dragSource.addDragListener((DragSourceListener)new TestCaseTableDragListener(this.testCaseTableViewer, this));
    }

    public TestSuiteEntity getTestSuite() {
        return this.testSuitePart.getTestSuite();
    }

    private void processTestSuiteTestCaseLinkSelected() {
        if (this.testCaseTableViewer.getSelection() == null) {
            return;
        }
        if (!(this.testCaseTableViewer.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        this.dataAndVariableView.updateSelectedTestCase((IStructuredSelection)this.testCaseTableViewer.getSelection());
    }

    void registerControlModifyListeners() {
        this.dataAndVariableView.registerControlModifyListeners();
        this.lblSearch.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (TestSuitePartTestCaseView.this.isSearching) {
                    TestSuitePartTestCaseView.this.txtSearch.setText("");
                }
                TestSuitePartTestCaseView.this.filterTestCaseLinkBySearchedText();
            }
        });
        this.txtSearch.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TestSuitePartTestCaseView.this.filterTestCaseLinkBySearchedText();
                }
            }
        });
        this.lblFilter.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                TestSuitePartTestCaseView.this.openAdvancedSearchDialog();
            }
        });
        this.testCaseToolItemListener = new TestCaseToolItemListener(this.testCaseTableViewer);
        ToolItem[] toolItemArray = this.testCaseToolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.addSelectionListener((SelectionListener)this.testCaseToolItemListener);
            ++n2;
        }
        this.testCaseTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuitePartTestCaseView.this.processTestSuiteTestCaseLinkSelected();
            }
        });
        this.tblclId.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TestSuitePartTestCaseView.this.testCaseTableViewer.refresh(true);
            }
        });
        this.tblclmnIsRun.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TestSuitePartTestCaseView.this.testCaseTableViewer.setIsRunValueAllTestCases();
            }
        });
        this.tltmShowHideDataBinding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuitePartTestCaseView.this.setDataBindingVisible(BTN_SHOW_DATA_BINDING.equals(TestSuitePartTestCaseView.this.tltmShowHideDataBinding.getText()));
            }
        });
    }

    private void createCompositeTestCaseSearch() {
        this.compositeTableSearch = new Composite(this.compositeTestCase, 2048);
        this.compositeTableSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeTableSearch.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glCompositeTableSearch = new GridLayout(4, false);
        glCompositeTableSearch.marginWidth = 0;
        glCompositeTableSearch.marginHeight = 0;
        this.compositeTableSearch.setLayout((Layout)glCompositeTableSearch);
        this.txtSearch = new Text(this.compositeTableSearch, 0);
        this.txtSearch.setMessage(StringConstants.PA_SEARCH_TEXT_DEFAULT_VALUE);
        GridData gdTxtInput = new GridData(768);
        gdTxtInput.grabExcessVerticalSpace = true;
        gdTxtInput.verticalAlignment = 0x1000000;
        this.txtSearch.setLayoutData((Object)gdTxtInput);
        Canvas canvasSearch = new Canvas(this.compositeTableSearch, 0);
        canvasSearch.setLayout((Layout)new FillLayout(256));
        this.lblSearch = new CLabel((Composite)canvasSearch, 0);
        this.updateStatusSearchLabel();
        this.lblSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        Label seperator = new Label(this.compositeTableSearch, 514);
        GridData gdSeperator = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdSeperator.heightHint = 22;
        seperator.setLayoutData((Object)gdSeperator);
        this.lblFilter = new CLabel(this.compositeTableSearch, 0);
        this.lblFilter.setImage(ImageConstants.IMG_16_ADVANCED_SEARCH);
        this.lblFilter.setToolTipText(StringConstants.PA_IMAGE_TIP_ADVANCED_SEARCH);
        this.lblFilter.setCursor(new Cursor((Device)Display.getCurrent(), 21));
    }

    private void updateStatusSearchLabel() {
        if (this.isSearching) {
            this.lblSearch.setImage(ImageConstants.IMG_16_CLOSE_SEARCH);
            this.lblSearch.setToolTipText(StringConstants.PA_IMAGE_TIP_CLOSE_SEARCH);
        } else {
            this.lblSearch.setImage(ImageConstants.IMG_16_SEARCH);
            this.lblSearch.setToolTipText(StringConstants.PA_IMAGE_TIP_SEARCH);
        }
    }

    private void filterTestCaseLinkBySearchedText() {
        this.isSearching = !this.txtSearch.getText().isEmpty();
        this.testCaseTableViewer.setSearchedString(this.txtSearch.getText());
        this.testCaseTableViewer.refresh(true);
        this.updateStatusSearchLabel();
    }

    private void openAdvancedSearchDialog() {
        try {
            Shell shell = new Shell(this.compositeTableSearch.getShell());
            shell.setSize(0, 0);
            Point pt = this.compositeTableSearch.toDisplay(1, 1);
            Point location = new Point(pt.x + this.compositeTableSearch.getBounds().width, pt.y);
            AdvancedSearchDialog dialog = new AdvancedSearchDialog(shell, this.txtSearch.getText(), location);
            if (dialog.open() == 0) {
                this.txtSearch.setText(dialog.getOutput());
                this.filterTestCaseLinkBySearchedText();
            }
            shell.getSize();
            shell.dispose();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void createCompositeTestCaseButtons() {
        this.compositeTestCase = new Composite((Composite)this.sashForm, 0);
        this.compositeTestCase.setLayout((Layout)new GridLayout(1, false));
        this.compositeTestCase.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.compositeTableButtons = new Composite(this.compositeTestCase, 0);
        this.compositeTableButtons.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeTableButtons = new GridLayout(3, false);
        this.compositeTableButtons.setBackground(ColorUtil.getCompositeBackgroundColor());
        glCompositeTableButtons.marginHeight = 0;
        glCompositeTableButtons.marginWidth = 0;
        this.compositeTableButtons.setLayout((Layout)glCompositeTableButtons);
        this.testCaseToolbar = new ToolBar(this.compositeTableButtons, 0x820000);
        this.testCaseToolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolItem tltmAddTestCases = new ToolItem(this.testCaseToolbar, 0);
        tltmAddTestCases.setText(StringConstants.PA_TOOLITEM_ADD);
        tltmAddTestCases.setToolTipText(StringConstants.PA_TOOLITEM_ADD);
        tltmAddTestCases.setImage(ImageConstants.IMG_16_ADD);
        tltmAddTestCases.setData((Object)ToolItemConstants.ADD);
        ToolItem tltmRemoveTestCases = new ToolItem(this.testCaseToolbar, 0);
        tltmRemoveTestCases.setText(StringConstants.PA_TOOLITEM_REMOVE);
        tltmRemoveTestCases.setToolTipText(StringConstants.PA_TOOLITEM_REMOVE);
        tltmRemoveTestCases.setImage(ImageConstants.IMG_16_REMOVE);
        tltmRemoveTestCases.setData((Object)ToolItemConstants.REMOVE);
        ToolItem tltmUp = new ToolItem(this.testCaseToolbar, 0);
        tltmUp.setText(StringConstants.PA_TOOLITEM_UP);
        tltmUp.setToolTipText(StringConstants.PA_TOOLITEM_UP);
        tltmUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        tltmUp.setData((Object)ToolItemConstants.UP);
        ToolItem tltmDown = new ToolItem(this.testCaseToolbar, 0);
        tltmDown.setText(StringConstants.PA_TOOLITEM_DOWN);
        tltmDown.setToolTipText(StringConstants.PA_TOOLITEM_DOWN);
        tltmDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        tltmDown.setData((Object)ToolItemConstants.DOWN);
        Composite kaComposite = new Composite(this.compositeTableButtons, 0);
        kaComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        kaComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnViewHistory = new Button(kaComposite, 0);
        this.btnViewHistory.setImage(ImageManager.getImage((String)"katalon_analytics_16.png"));
        this.btnViewHistory.setText(ComposerTestcaseMessageConstants.BTN_TESTCASEHISTORY);
        this.btnViewHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (TestSuitePartTestCaseView.this.analyticsReportService.isIntegrationEnabled() && TestSuitePartTestCaseView.this.analyticsSettingStore.getProject() != null) {
                        Program.launch((String)TestSuitePartTestCaseView.this.createPath(TestSuitePartTestCaseView.this.analyticsSettingStore.getTeam(), TestSuitePartTestCaseView.this.analyticsSettingStore.getProject(), TestSuitePartTestCaseView.this.testSuitePart.getTestSuite().getIdForDisplay(), TestSuitePartTestCaseView.this.analyticsSettingStore.getToken(true)));
                    } else {
                        Program.launch((String)ComposerTestcaseMessageConstants.KA_WELCOME_PAGE);
                    }
                    Trackings.trackOpenKAIntegration((String)"testSuite");
                }
                catch (IOException | GeneralSecurityException e1) {
                    LoggerSingleton.logError((Throwable)e1);
                }
            }
        });
        ToolBar showHideDetails = new ToolBar(this.compositeTableButtons, 0x820000);
        showHideDetails.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.tltmShowHideDataBinding = new ToolItem(showHideDetails, 0);
        this.tltmShowHideDataBinding.setText(BTN_SHOW_DATA_BINDING);
        this.tltmShowHideDataBinding.setImage(ImageManager.getImage((String)"move_left_16.png"));
    }

    void initExpandedState() {
        this.isSearching = false;
        this.dataAndVariableView.initExpandedState();
    }

    void layout() {
        this.dataAndVariableView.layout();
    }

    void refreshTestSuiteAfterTestDataChanged(String oldTestDataId, String newTestDataId) {
        this.dataAndVariableView.refreshTestSuiteAfterTestDataChanged(oldTestDataId, newTestDataId);
    }

    boolean beforeSaving() {
        this.testSuiteTestCaseSelectedIdx = this.testCaseTableViewer.getTable().getSelectionIndex();
        this.getTestSuite().getTestSuiteTestCaseLinks().clear();
        Iterator iterator = this.testCaseTableViewer.getInput().iterator();
        while (iterator.hasNext()) {
            Object testCaseLink = iterator.next();
            this.getTestSuite().getTestSuiteTestCaseLinks().add((TestSuiteTestCaseLink)testCaseLink);
        }
        return true;
    }

    void afterSaving() {
        if (this.testCaseTableViewer == null) {
            return;
        }
        Table testCaseTable = this.testCaseTableViewer.getTable();
        if (testCaseTable == null || testCaseTable.isDisposed()) {
            return;
        }
        if (this.testSuiteTestCaseSelectedIdx >= 0 && this.testSuiteTestCaseSelectedIdx < this.testCaseTableViewer.getTable().getItemCount()) {
            TestSuiteTestCaseLink selectedTestCaseLink = (TestSuiteTestCaseLink)this.testCaseTableViewer.getInput().get(this.testSuiteTestCaseSelectedIdx);
            StructuredSelection selection = new StructuredSelection(Arrays.asList(selectedTestCaseLink));
            this.testCaseTableViewer.setSelection((ISelection)selection);
        }
    }

    private String createPath(AnalyticsTeam team, AnalyticsProject project, String path, String tokenInfo) {
        String result = "";
        result = String.valueOf(ComposerTestcaseMessageConstants.KA_HOMEPAGE) + "teamId=" + team.getId() + "&projectId=" + project.getId() + "&type=TEST_SUITE" + "&path=" + UrlEncoder.encode((String)path) + "&token=" + tokenInfo;
        return result;
    }

    public TestSuiteTestCaseLink getSelectedTestCaseLink() {
        return this.testCaseTableViewer.getSelectedTestCaseLink();
    }

    public void setDirty(boolean dirty) {
        this.testSuitePart.setDirty(dirty);
    }

    void loadInput() throws Exception {
        this.testCaseTableViewer.setInput(new ArrayList<TestSuiteTestCaseLink>(this.getTestSuite().getTestSuiteTestCaseLinks()));
        this.processTestSuiteTestCaseLinkSelected();
    }

    public void updateIsRunColumnHeader() {
        boolean isRunAll = this.testCaseTableViewer.getIsRunAll();
        Image isRunColumnImageHeader = isRunAll ? ImageConstants.IMG_16_CHECKBOX_CHECKED : ImageConstants.IMG_16_CHECKBOX_UNCHECKED;
        this.tblclmnIsRun.setImage(isRunColumnImageHeader);
    }

    void updateTestCaseTable(String oldTestCaseId, TestCaseEntity testCase) throws Exception {
        this.testCaseTableViewer.updateTestCaseProperties(oldTestCaseId, testCase);
        this.dataAndVariableView.refreshVariableTable();
    }

    void openAddTestCaseDialog() {
        this.testCaseTableViewer.addNewItem();
    }

    public void addNewTestCase(String idTestSuite, TestCaseEntity testCase) throws Exception {
        if (idTestSuite.equals(this.getTestSuite().getId())) {
            this.testCaseTableViewer.addTestCase(testCase);
        }
    }

    private void createOpenTestCaseMenu() {
        ControlUtils.removeOldOpenMenuItem((Menu)this.tableContextMenu);
        IStructuredSelection selection = (IStructuredSelection)this.testCaseTableViewer.getSelection();
        List<TestCaseEntity> testCaseEntities = this.getListTestCaseFromSelection(selection);
        SelectionAdapter openSubMenuSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (!(source instanceof MenuItem)) {
                    return;
                }
                TestCaseEntity testCaseEntity = TestSuitePartTestCaseView.this.getTestCaseFromMenuItem((MenuItem)source);
                if (testCaseEntity != null) {
                    TestSuitePartTestCaseView.this.testSuitePart.openAddedTestCase(testCaseEntity);
                }
            }
        };
        if (testCaseEntities.size() == 1) {
            ControlUtils.createOpenMenuWhenSelectOnlyOne((Menu)this.tableContextMenu, (FileEntity)((FileEntity)testCaseEntities.get(0)), (TableViewer)this.testCaseTableViewer, (SelectionAdapter)openSubMenuSelection);
            return;
        }
        MenuUtils.createOpenTestArtifactsMenu(this.getMapFileEntityToSelectionAdapter(testCaseEntities, openSubMenuSelection), (Menu)this.tableContextMenu);
    }

    private TestCaseEntity getTestCaseFromMenuItem(MenuItem selectedMenuItem) {
        if (selectedMenuItem.getData() instanceof TestCaseEntity) {
            return (TestCaseEntity)selectedMenuItem.getData();
        }
        return null;
    }

    public void openAddedTestData(DataFileEntity dataFileEntity) {
        this.testSuitePart.openAddedTestData(dataFileEntity);
    }

    private List<TestCaseEntity> getListTestCaseFromSelection(IStructuredSelection selection) {
        ArrayList<TestCaseEntity> testCaseEntities = new ArrayList<TestCaseEntity>();
        TestCaseController controller = TestCaseController.getInstance();
        for (Object object : selection.toList()) {
            if (!(object instanceof TestSuiteTestCaseLink)) continue;
            try {
                testCaseEntities.add(controller.getTestCaseByDisplayId(((TestSuiteTestCaseLink)object).getTestCaseId()));
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return testCaseEntities;
    }

    private HashMap<FileEntity, SelectionAdapter> getMapFileEntityToSelectionAdapter(List<? extends FileEntity> fileEntities, SelectionAdapter openTestCase) {
        HashMap<FileEntity, SelectionAdapter> map = new HashMap<FileEntity, SelectionAdapter>();
        for (FileEntity fileEntity : fileEntities) {
            if (!(fileEntity instanceof TestCaseEntity)) continue;
            map.put(fileEntity, openTestCase);
        }
        return map;
    }

    private void setDataBindingVisible(boolean isVisible) {
        this.sashForm.setMaximizedControl((Control)(isVisible ? null : this.compositeTestCase));
        this.tltmShowHideDataBinding.setText(isVisible ? BTN_HIDE_DATA_BINDING : BTN_SHOW_DATA_BINDING);
        this.tltmShowHideDataBinding.setImage(ImageManager.getImage((String)(isVisible ? "move_right_16.png" : "move_left_16.png")));
        this.compositeTableButtons.layout();
    }
}

