/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.testsuite.integration.TestSuiteIntegrationFactory;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.integration.AbstractTestSuiteIntegrationView;
import com.kms.katalon.composer.testsuite.parts.integration.TestSuiteIntegrationViewBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TestSuiteIntegrationPart {
    private ToolBar toolBar;
    private Composite container;
    private MPart mpart;
    private ParentTestSuiteCompositePart parentTestSuiteCompositePart;
    private Map<String, AbstractTestSuiteIntegrationView> integratingCompositeMap;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof ParentTestSuiteCompositePart) {
            this.parentTestSuiteCompositePart = (ParentTestSuiteCompositePart)compositePart.getObject();
        }
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout glMainComposite = new GridLayout(2, false);
        glMainComposite.horizontalSpacing = 20;
        mainComposite.setLayout((Layout)glMainComposite);
        Composite toolBarComposite = new Composite(mainComposite, 0);
        GridLayout glToolBarComposite = new GridLayout(1, false);
        toolBarComposite.setLayout((Layout)glToolBarComposite);
        toolBarComposite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.toolBar = new ToolBar(toolBarComposite, 0x820000);
        this.toolBar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.container = new Composite(mainComposite, 0);
        this.container.setLayout((Layout)new FillLayout(256));
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public MPart getMPart() {
        return this.mpart;
    }

    public void setDirty(boolean dirty) {
        this.mpart.setDirty(true);
        this.parentTestSuiteCompositePart.setDirty(true);
    }

    public void loadInput() {
        this.clearToolbar();
        this.integratingCompositeMap = new HashMap<String, AbstractTestSuiteIntegrationView>();
        for (Map.Entry<String, TestSuiteIntegrationViewBuilder> builderEntry : TestSuiteIntegrationFactory.getInstance().getIntegrationViewMap().entrySet()) {
            ToolItem item = new ToolItem(this.toolBar, 32);
            item.setText(builderEntry.getKey());
            this.integratingCompositeMap.put(builderEntry.getKey(), builderEntry.getValue().getIntegrationView(this.parentTestSuiteCompositePart.getTestSuiteClone(), this.mpart));
        }
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem toolItem = (ToolItem)e.getSource();
                    if (toolItem.getSelection()) {
                        TestSuiteIntegrationPart.this.changeContainer(toolItem.getText());
                    } else {
                        TestSuiteIntegrationPart.this.clearContainer();
                    }
                }
            });
            ++n2;
        }
        if (this.toolBar.getItems().length > 0) {
            this.toolBar.getItems()[0].setSelection(true);
            this.changeContainer(this.toolBar.getItems()[0].getText());
        }
    }

    private void clearToolbar() {
        while (this.toolBar.getItems().length > 0) {
            this.toolBar.getItems()[0].dispose();
        }
    }

    private void clearContainer() {
        while (this.container.getChildren().length > 0) {
            this.container.getChildren()[0].dispose();
        }
    }

    private void changeContainer(String productName) {
        this.clearContainer();
        this.integratingCompositeMap.get(productName).createContainer(this.container);
        this.container.layout(true, true);
    }
}

