/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForCompositePart;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteIntegrationPart;
import com.kms.katalon.composer.testsuite.parts.TestSuitePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteScriptPart;
import com.kms.katalon.composer.testsuite.util.TestSuiteEntityUtil;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestSuiteCompositePart
implements EventHandler,
ParentTestSuiteCompositePart,
IComposerPartEvent {
    private MCompositePart compositePart;
    private MPartStack subPartStack;
    private CTabFolder tabFolder;
    private TestSuitePart childTestSuiteMainPart;
    private TestSuiteIntegrationPart childTestSuiteIntegrationPart;
    private boolean isInitialized;
    private static final int COMPOSITE_SIZE = 1;
    private static final int SUB_PARTSTACK_SIZE = 3;
    private static final int CHILD_TESTSUITE_MAIN_PART_INDEX = 0;
    private static final int CHILD_TESTSUITE_SCRIPT_PART_INDEX = 1;
    private static final int CHILD_TESTSUITE_INTEGRATION_PART_INDEX = 2;
    public static final String MAIN_TAB_TITLE = StringConstants.PA_TAB_MAIN;
    public static final String INTEGRATION_TAB_TITLE = StringConstants.PA_TAB_INTEGRATION;
    private static boolean isConfirmationDialogShowed = false;
    private TestSuiteEntity originalTestSuite;
    private TestSuiteEntity testSuite;
    private Composite parent;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    private MDirtyable dirty;
    @Inject
    private EPartService partService;
    private TestSuiteScriptPart scriptPart;

    public MDirtyable getDirty() {
        return this.dirty;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @PostConstruct
    public void init(Composite parent, MCompositePart compositePart) {
        this.parent = parent;
        this.compositePart = compositePart;
        this.dirty.setDirty(false);
        this.isInitialized = false;
        new HelpToolBarForCompositePart((MPart)compositePart, this.partService){

            protected String getDocumentationUrlForPartObject(Object partObject) {
                if (partObject instanceof TestSuitePart) {
                    return DocumentationMessageConstants.TEST_SUITE_MAIN;
                }
                if (partObject instanceof TestSuiteIntegrationPart) {
                    return DocumentationMessageConstants.TEST_SUITE_INTEGRATION;
                }
                return null;
            }
        };
        this.changeOriginalTestSuite((TestSuiteEntity)compositePart.getObject());
        this.initListeners();
    }

    public void initComponent() {
        if (this.compositePart.getChildren().size() != 1 || !(this.compositePart.getChildren().get(0) instanceof MPartStack)) {
            return;
        }
        this.subPartStack = (MPartStack)this.compositePart.getChildren().get(0);
        if (this.subPartStack.getChildren().size() == 3) {
            for (MStackElement stackElement : this.subPartStack.getChildren()) {
                if (!(stackElement instanceof MPart)) continue;
                Object part = ((MPart)stackElement).getObject();
                if (part instanceof TestSuitePart) {
                    this.childTestSuiteMainPart = (TestSuitePart)part;
                    continue;
                }
                if (part instanceof TestSuiteIntegrationPart) {
                    this.childTestSuiteIntegrationPart = (TestSuiteIntegrationPart)part;
                    continue;
                }
                if (!(part instanceof CompatibilityEditor)) continue;
                this.scriptPart = new TestSuiteScriptPart(this, (CompatibilityEditor)part);
            }
        }
        this.initTabFolder();
        this.scriptPart.initEditorAction();
    }

    private void initTabFolder() {
        if (this.subPartStack.getWidget() instanceof CTabFolder) {
            this.tabFolder = (CTabFolder)this.subPartStack.getWidget();
            this.tabFolder.setTabPosition(1024);
            this.tabFolder.setBorderVisible(false);
            this.tabFolder.setMaximizeVisible(false);
            this.tabFolder.setMinimizeVisible(false);
            if (this.tabFolder.getItemCount() == 3) {
                CTabItem testSuiteMainPart = this.tabFolder.getItem(0);
                testSuiteMainPart.setText(MAIN_TAB_TITLE);
                testSuiteMainPart.setImage(ImageConstants.IMG_16_MAIN);
                testSuiteMainPart.setShowClose(false);
                CTabItem testSuiteScriptPart = this.tabFolder.getItem(1);
                testSuiteScriptPart.setText(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
                testSuiteScriptPart.setImage(ImageConstants.IMG_16_SCRIPT);
                testSuiteScriptPart.setShowClose(false);
                CTabItem testSuiteIntegrationPart = this.tabFolder.getItem(2);
                testSuiteIntegrationPart.setText(INTEGRATION_TAB_TITLE);
                testSuiteIntegrationPart.setImage(ImageConstants.IMG_16_INTEGRATION);
                testSuiteIntegrationPart.setShowClose(false);
            }
            this.tabFolder.layout();
            this.loadTestSuite();
            this.isInitialized = true;
        }
    }

    private void loadTestSuite() {
        this.childTestSuiteMainPart.loadTestSuite(this.testSuite);
        this.childTestSuiteIntegrationPart.loadInput();
    }

    private void initListeners() {
        this.eventBroker.subscribe("TESTSUITE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
    }

    public MPart getChildMainPart() {
        return this.childTestSuiteMainPart != null ? this.childTestSuiteMainPart.getMPart() : null;
    }

    public MPart getChildIntegrationPart() {
        return this.childTestSuiteIntegrationPart != null ? this.childTestSuiteIntegrationPart.getMPart() : null;
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> childrenParts = new ArrayList<MPart>();
        childrenParts.add(this.getChildMainPart());
        childrenParts.add(this.getChildIntegrationPart());
        childrenParts.add(this.scriptPart.getMPart());
        return childrenParts;
    }

    public void setSelectedPart(MPart partToSelect) {
        if (this.subPartStack.getChildren().contains(partToSelect)) {
            this.subPartStack.setSelectedElement((MUIElement)partToSelect);
        }
    }

    private void changeOriginalTestSuite(TestSuiteEntity testSuite) {
        this.originalTestSuite = testSuite;
        this.cloneTestSuite();
    }

    private void cloneTestSuite() {
        this.testSuite = this.originalTestSuite.clone();
        this.testSuite.setTestSuiteGuid(this.originalTestSuite.getTestSuiteGuid());
    }

    public void dispose() {
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.compositePart);
        this.eventBroker.unsubscribe((EventHandler)this);
        this.childTestSuiteMainPart.dispose();
    }

    public void checkDirty() {
        boolean isDirty = false;
        for (MPart childPart : this.getChildParts()) {
            if (!childPart.isDirty()) continue;
            isDirty = true;
            break;
        }
        this.setDirty(isDirty);
        for (MPart childPart : this.getChildParts()) {
            childPart.setDirty(false);
        }
    }

    public void setDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
    }

    @Persist
    public void onSave() {
        try {
            this.save();
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR_TITLE, (String)StringConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_PART);
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean prepareForSaving() {
        return this.childTestSuiteMainPart.prepareForSaving();
    }

    private void afterSaving() {
        this.childTestSuiteMainPart.afterSaving();
    }

    public void save() throws Exception {
        if (!this.prepareForSaving()) {
            return;
        }
        TestSuiteEntity temp = new TestSuiteEntity();
        TestSuiteEntityUtil.copyTestSuiteProperties(this.originalTestSuite, temp);
        String oldIdForDisplay = this.originalTestSuite.getIdForDisplay();
        TestSuiteEntityUtil.copyTestSuiteProperties(this.testSuite, this.originalTestSuite);
        try {
            this.scriptPart.save();
            TestSuiteController.getInstance().updateTestSuite(this.originalTestSuite);
            TestSuiteTreeEntity testSuiteTreeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)this.originalTestSuite, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testSuiteTreeEntity);
            if (!StringUtils.equalsIgnoreCase((String)temp.getName(), (String)this.originalTestSuite.getName())) {
                this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, this.originalTestSuite.getIdForDisplay()});
            }
            this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{this.testSuite.getId(), this.originalTestSuite});
            if (this.parent.isDisposed()) {
                return;
            }
            this.updateTestSuitePart(this.originalTestSuite);
            this.afterSaving();
        }
        catch (Exception e) {
            TestSuiteEntityUtil.copyTestSuiteProperties(temp, this.originalTestSuite);
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
    }

    private void updateTestSuitePart(TestSuiteEntity testSuite) {
        int index = this.tabFolder.getSelectionIndex();
        String newElementId = EntityPartUtil.getTestSuiteCompositePartId((String)testSuite.getId());
        if (!newElementId.equals(this.compositePart.getElementId())) {
            this.compositePart.setLabel(testSuite.getName());
            this.compositePart.setElementId(newElementId);
            if (this.compositePart.getChildren().size() == 1 && this.compositePart.getChildren().get(0) instanceof MPartStack) {
                MPartStack partStack = (MPartStack)this.compositePart.getChildren().get(0);
                partStack.setElementId(String.valueOf(newElementId) + ".partStack");
                this.renewTestSuiteScriptPart(testSuite, newElementId, partStack);
                this.childTestSuiteMainPart.getMPart().setElementId(String.valueOf(newElementId) + ".partStack.testSuitePart");
                this.childTestSuiteIntegrationPart.getMPart().setElementId(String.valueOf(newElementId) + ".partStack.integration");
            }
        }
        this.tabFolder.setSelection(index);
        this.changeOriginalTestSuite(testSuite);
        this.setDirty(false);
        this.loadTestSuite();
    }

    private void renewTestSuiteScriptPart(TestSuiteEntity testSuite, String newElementId, MPartStack partStack) {
        try {
            File scriptFile = TestSuiteController.getInstance().getTestSuiteScriptFile(testSuite);
            MPart testSuiteScriptPart = GroovyEditorUtil.createEditorPart((ProjectEntity)testSuite.getProject(), (String)PathUtil.absoluteToRelativePath((String)scriptFile.getAbsolutePath(), (String)testSuite.getProject().getFolderLocation()), (EPartService)this.partService);
            testSuiteScriptPart.setElementId(String.valueOf(newElementId) + ".partStack.editor");
            testSuiteScriptPart.getTags().add("NoMove");
            testSuiteScriptPart.setLabel(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
            partStack.getChildren().add(1, testSuiteScriptPart);
            this.partService.activate(testSuiteScriptPart);
            CTabItem testSuiteScriptItem = this.tabFolder.getItem(1);
            testSuiteScriptItem.setText(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
            testSuiteScriptItem.setImage(ImageConstants.IMG_16_SCRIPT);
            testSuiteScriptItem.setShowClose(false);
            this.scriptPart = new TestSuiteScriptPart(this, (CompatibilityEditor)testSuiteScriptPart.getObject());
            this.scriptPart.initEditorAction();
        }
        catch (DALException | CoreException throwable) {}
    }

    public void handleEvent(Event event) {
        block13: {
            String elementId;
            Object object;
            if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
                try {
                    FolderEntity folder;
                    Object object2 = event.getProperty("org.eclipse.e4.data");
                    if (object2 == null || !(object2 instanceof ITreeEntity)) break block13;
                    if (object2 instanceof TestSuiteTreeEntity) {
                        TestSuiteTreeEntity testSuiteTreeEntity = (TestSuiteTreeEntity)object2;
                        TestSuiteEntity testSuite = testSuiteTreeEntity.getObject();
                        if (testSuite != null && testSuite.getId().equals(this.originalTestSuite.getId())) {
                            if (TestSuiteController.getInstance().getTestSuite(testSuite.getId()) != null) {
                                if (this.dirty.isDirty()) {
                                    this.verifyTestSuiteChanged();
                                } else {
                                    this.updateTestSuitePart(testSuite);
                                }
                            } else {
                                this.dispose();
                            }
                        }
                    } else if (object2 instanceof FolderTreeEntity && (folder = (FolderEntity)((ITreeEntity)object2).getObject()) != null && FolderController.getInstance().isFolderAncestorOfEntity(folder, (IEntity)this.originalTestSuite) && TestSuiteController.getInstance().getTestSuite(this.originalTestSuite.getId()) == null) {
                        this.dispose();
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            } else if (event.getTopic().equals("TESTSUITE/UPDATED") && (object = event.getProperty("org.eclipse.e4.data")) != null && object instanceof Object[] && (elementId = EntityPartUtil.getTestSuiteCompositePartId((String)((String)((Object[])object)[0]))).equalsIgnoreCase(this.compositePart.getElementId())) {
                TestSuiteEntity testSuite = (TestSuiteEntity)((Object[])object)[1];
                this.updateTestSuitePart(testSuite);
            }
        }
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.compositePart.getChildren().clear();
        this.eventBroker.unsubscribe((EventHandler)this);
        this.interuptUIThreads();
    }

    @Focus
    public void setFocus() {
        this.verifyTestSuiteChanged();
    }

    private void interuptUIThreads() {
        this.childTestSuiteMainPart.interuptUIThreads();
    }

    @Override
    public TestSuiteEntity getTestSuiteClone() {
        return this.testSuite;
    }

    @Override
    public TestSuiteEntity getOriginalTestSuite() {
        return this.originalTestSuite;
    }

    private void verifyTestSuiteChanged() {
        try {
            if (this.originalTestSuite != null) {
                TestSuiteEntity testSuiteInFile = TestSuiteController.getInstance().getTestSuite(this.originalTestSuite.getId());
                if (testSuiteInFile != null) {
                    if (!testSuiteInFile.equals((Object)this.originalTestSuite) && !isConfirmationDialogShowed && MessageDialog.openConfirm(null, (String)StringConstants.PA_CONFIRM_TITLE_FILE_CHANGED, (String)MessageFormat.format(StringConstants.PA_CONFIRM_MSG_RELOAD_FILE, this.originalTestSuite.getLocation()))) {
                        this.updateTestSuitePart(testSuiteInFile);
                    }
                } else {
                    this.dispose();
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void openAddTestCaseDialog() {
        this.setSelectedPart(this.getChildMainPart());
        this.childTestSuiteMainPart.openAddTestCaseDialog();
    }

    public String getEntityId() {
        return this.getOriginalTestSuite().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.startsWith((String)part.getElementId(), (String)EntityPartUtil.getTestSuiteCompositePartId((String)this.originalTestSuite.getId()))) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.originalTestSuite);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof TestSuiteEntity)) {
            return;
        }
        TestSuiteEntity updatedEntity = (TestSuiteEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        this.originalTestSuite.setTag(updatedEntity.getTag());
        this.originalTestSuite.setDescription(updatedEntity.getDescription());
    }

    public boolean isDirty() {
        return this.compositePart.isDirty();
    }
}

