/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.katalon.platform.api.Extension;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.DynamicQueryingTestSuiteDescription;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.control.StyledTextMessage;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.custom.AdvancedSearchDialog;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testsuite.parts.FilteringTestSuitePart;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.providers.FilteredTestCaseLabelProvider;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webservice.support.UrlEncoder;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FilteringTestCaseView {
    private ParentTestSuiteCompositePart parentPart;
    private Composite container;
    private CTableViewer testCaseTableViewer;
    private Button btnPreview;
    private StyledText txtSearch;
    private Button btnViewHistory;
    private Label lblSummary;
    private AnalyticsReportService analyticsReportService = new AnalyticsReportService();
    private AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
    private Button btnQueryBuilder;
    private FilteringTestSuitePart part;
    private Combo cbbExtensions;
    private DynamicQueryingTestSuiteDescription selectedExtensionDescription;
    private List<Extension> extensions;
    private Link lnkFindOnStore;

    public FilteringTestCaseView(ParentTestSuiteCompositePart parentPart, FilteringTestSuitePart part) {
        this.parentPart = parentPart;
        this.part = part;
    }

    public Composite createComponent(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite kaComposite = new Composite(this.container, 0);
        kaComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        kaComposite.setLayout((Layout)new FillLayout());
        this.btnViewHistory = new Button(kaComposite, 0);
        this.btnViewHistory.setImage(ImageManager.getImage((String)"katalon_analytics_16.png"));
        this.btnViewHistory.setText(ComposerTestcaseMessageConstants.BTN_TESTCASEHISTORY);
        Composite cpsTestCaseSearch = new Composite(this.container, 0);
        cpsTestCaseSearch.setLayoutData((Object)new GridData(4, 128, true, false));
        cpsTestCaseSearch.setLayout((Layout)new FillLayout());
        this.createCompositeTestCaseSearch(cpsTestCaseSearch);
        Composite cpsTestCasePreview = new Composite(this.container, 0);
        cpsTestCasePreview.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glTestCasePreview = new GridLayout();
        glTestCasePreview.marginWidth = 0;
        glTestCasePreview.marginHeight = 0;
        cpsTestCasePreview.setLayout((Layout)glTestCasePreview);
        Composite cpsTestCaseSummary = new Composite(cpsTestCasePreview, 0);
        cpsTestCaseSummary.setLayoutData((Object)new GridData(16384, 128, false, false));
        cpsTestCaseSummary.setLayout((Layout)new GridLayout());
        this.lblSummary = new Label(cpsTestCaseSummary, 0);
        Composite cpsTestCaseTalbe = new Composite(cpsTestCasePreview, 0);
        cpsTestCaseTalbe.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTestCaseFilteredPreviewTable(cpsTestCaseTalbe);
        return this.container;
    }

    private void createTestCaseFilteredPreviewTable(Composite cpsTestCasePreview) {
        this.testCaseTableViewer = new CTableViewer(cpsTestCasePreview, 67586);
        Table testCaseTable = this.testCaseTableViewer.getTable();
        testCaseTable.setHeaderVisible(true);
        testCaseTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnOrder = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnOrder = tableViewerColumnOrder.getColumn();
        tblclmnOrder.setText("#");
        TableViewerColumn tableViewerColumnPK = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclId = tableViewerColumnPK.getColumn();
        tblclId.setText("Id");
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn((TableViewer)this.testCaseTableViewer, 0);
        TableColumn tblclmnDescription = tableViewerColumnDescription.getColumn();
        tblclmnDescription.setText("Description");
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnOrder, (ColumnLayoutData)new ColumnWeightData(0, 40));
        tableLayout.setColumnData((Widget)tblclId, (ColumnLayoutData)new ColumnWeightData(40, 100));
        tableLayout.setColumnData((Widget)tblclmnDescription, (ColumnLayoutData)new ColumnWeightData(40, 100));
        cpsTestCasePreview.setLayout((Layout)tableLayout);
        this.testCaseTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.testCaseTableViewer.getTable().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.testCaseTableViewer, (int)2);
        tableViewerColumnOrder.setLabelProvider((CellLabelProvider)new FilteredTestCaseLabelProvider(0, (TableViewer)this.testCaseTableViewer));
        tableViewerColumnPK.setLabelProvider((CellLabelProvider)new FilteredTestCaseLabelProvider(1, (TableViewer)this.testCaseTableViewer));
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new FilteredTestCaseLabelProvider(2, (TableViewer)this.testCaseTableViewer));
    }

    private void createCompositeTestCaseSearch(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        ToolBar toolbar = toolBarManager.createControl(parent);
        ToolItem tltmAdvancedSearchGuide = new ToolItem(toolbar, 0);
        tltmAdvancedSearchGuide.setText("Help");
        tltmAdvancedSearchGuide.setImage(ImageManager.getImage((String)"help_16.png"));
        tltmAdvancedSearchGuide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://docs.katalon.com/katalon-studio/docs/advanced-search.html");
            }
        });
        Composite cpsSearchAndPreview = new Composite(parent, 0);
        cpsSearchAndPreview.setLayoutData((Object)new GridData(1808));
        GridLayout gdSearchAndPreview = new GridLayout(2, false);
        gdSearchAndPreview.marginWidth = 0;
        gdSearchAndPreview.marginHeight = 0;
        cpsSearchAndPreview.setLayout((Layout)gdSearchAndPreview);
        Composite compositeTableSearch = new Composite(cpsSearchAndPreview, 0);
        compositeTableSearch.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout glCompositeTableSearch = new GridLayout(2, false);
        glCompositeTableSearch.marginWidth = 0;
        glCompositeTableSearch.marginHeight = 0;
        compositeTableSearch.setLayout((Layout)glCompositeTableSearch);
        Label lblFilteringPlugin = new Label(compositeTableSearch, 0);
        lblFilteringPlugin.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblFilteringPlugin.setText("Query Provider");
        Composite compositeQueryProvider = new Composite(compositeTableSearch, 0);
        compositeQueryProvider.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout glCompositeQueryProvider = new GridLayout(1, false);
        glCompositeQueryProvider.marginWidth = 0;
        glCompositeQueryProvider.marginHeight = 0;
        compositeQueryProvider.setLayout((Layout)glCompositeQueryProvider);
        this.cbbExtensions = new Combo(compositeQueryProvider, 8);
        GridData gdCbbPlugins = new GridData(16384, 128, false, false);
        gdCbbPlugins.widthHint = 500;
        gdCbbPlugins.horizontalIndent = 5;
        this.cbbExtensions.setLayoutData((Object)gdCbbPlugins);
        Label lblQuery = new Label(compositeTableSearch, 0);
        lblQuery.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblQuery.setText("Query");
        Composite customSearchComposite = new Composite(compositeTableSearch, 0);
        customSearchComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout glCustomSearchComposite = new GridLayout(2, false);
        glCustomSearchComposite.marginHeight = 0;
        glCompositeTableSearch.marginWidth = 0;
        customSearchComposite.setLayout((Layout)glCustomSearchComposite);
        this.txtSearch = new StyledText(customSearchComposite, 2562);
        GridData gdTxtInput = new GridData(4, 128, true, false);
        gdTxtInput.heightHint = 80;
        gdTxtInput.horizontalIndent = 5;
        this.txtSearch.setLayoutData((Object)gdTxtInput);
        StyledTextMessage styledTextMessage = new StyledTextMessage(this.txtSearch);
        styledTextMessage.setMessage("Type a query in the text box and then select Preview");
        Composite buttonsComposite = new Composite(customSearchComposite, 0);
        GridLayout glButtonsComposite = new GridLayout();
        glButtonsComposite.marginHeight = 0;
        glButtonsComposite.marginWidth = 0;
        buttonsComposite.setLayout((Layout)glButtonsComposite);
        buttonsComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.btnPreview = new Button(buttonsComposite, 0x800008);
        this.btnPreview.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnPreview.setText("Preview");
        this.btnPreview.setEnabled(false);
        this.btnQueryBuilder = new Button(buttonsComposite, 0x800008);
        this.btnQueryBuilder.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnQueryBuilder.setText("Query Builder");
        this.lnkFindOnStore = new Link(compositeTableSearch, 0);
        this.lnkFindOnStore.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.lnkFindOnStore.setText("Search function is provided by plugins. Find a plugin on <a>Katalon Store</a>.");
    }

    public void layout() {
    }

    public void beforeSaving() {
        FilteringTestSuiteEntity testSuiteClone = (FilteringTestSuiteEntity)this.parentPart.getTestSuiteClone();
        testSuiteClone.setFilteringText(this.txtSearch.getText());
        if (this.selectedExtensionDescription != null) {
            Extension selectedExtension = this.extensions.get(this.cbbExtensions.getSelectionIndex());
            testSuiteClone.setFilteringPlugin(selectedExtension.getPluginId());
            testSuiteClone.setFilteringExtension(selectedExtension.getExtensionId());
        }
    }

    public void afterSaving() {
    }

    public void initExpandedState() {
    }

    public void loadInput() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        this.extensions = this.part.getExtensionProvider().getAvailableExtensions(currentProject);
        if (this.extensions.isEmpty()) {
            this.cbbExtensions.setItems(new String[]{"No query provider available"});
            this.cbbExtensions.select(0);
        } else {
            List extensionDescriptions = this.extensions.stream().map(e -> this.part.getExtensionProvider().getDynamicQueryingDescription(e)).collect(Collectors.toList());
            String[] extensionNames = extensionDescriptions.stream().map(desc -> desc.getQueryingType()).collect(Collectors.toList()).toArray(new String[0]);
            this.cbbExtensions.setItems(extensionNames);
            FilteringTestSuiteEntity testSuite = (FilteringTestSuiteEntity)this.part.getTestSuite();
            Extension selectedExtension = this.extensions.stream().filter(ext -> ext.getPluginId().equals(testSuite.getFilteringPlugin()) && ext.getExtensionId().equals(testSuite.getFilteringExtension())).findFirst().orElse(null);
            if (selectedExtension == null) {
                selectedExtension = this.part.getExtensionProvider().getSuggestedExtension(currentProject, testSuite);
            }
            int selectedIndex = Math.max(0, this.extensions.indexOf(selectedExtension));
            this.cbbExtensions.select(selectedIndex);
        }
        this.onCbbExtensionChangeItem();
        FilteringTestSuiteEntity testSuite = (FilteringTestSuiteEntity)this.parentPart.getTestSuiteClone();
        this.txtSearch.setText(StringUtils.defaultString((String)testSuite.getFilteringText()));
        this.testCaseTableViewer.getTable().setVisible(false);
        this.lblSummary.getParent().getParent().layout(true, true);
        this.showPreviewTestCases();
    }

    public void registerControlModifyListeners() {
        this.txtSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteringTestCaseView.this.parentPart.setDirty(true);
            }
        });
        this.btnPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringTestCaseView.this.showPreviewTestCases();
            }
        });
        this.btnViewHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private String createPath(AnalyticsTeam team, AnalyticsProject project, String path, String tokenInfo) {
                String result = "";
                result = String.valueOf(ComposerTestcaseMessageConstants.KA_HOMEPAGE) + "teamId=" + team.getId() + "&projectId=" + project.getId() + "&type=TEST_SUITE" + "&path=" + UrlEncoder.encode((String)path) + "&token=" + tokenInfo;
                return result;
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (FilteringTestCaseView.this.analyticsReportService.isIntegrationEnabled() && FilteringTestCaseView.this.analyticsSettingStore.getProject() != null) {
                        Program.launch((String)this.createPath(FilteringTestCaseView.this.analyticsSettingStore.getTeam(), FilteringTestCaseView.this.analyticsSettingStore.getProject(), FilteringTestCaseView.this.parentPart.getOriginalTestSuite().getIdForDisplay(), FilteringTestCaseView.this.analyticsSettingStore.getToken(true)));
                    } else {
                        Program.launch((String)ComposerTestcaseMessageConstants.KA_WELCOME_PAGE);
                    }
                    Trackings.trackOpenKAIntegration((String)"dynamicQueryingTestSuite");
                }
                catch (IOException | GeneralSecurityException e1) {
                    LoggerSingleton.logError((Throwable)e1);
                }
            }
        });
        this.btnQueryBuilder.addListener(4, new Listener(){

            private void openAdvancedSearchDialog() {
                try {
                    Shell shell = new Shell(FilteringTestCaseView.this.container.getShell());
                    shell.setSize(0, 0);
                    Point pt = FilteringTestCaseView.this.btnQueryBuilder.toDisplay(1, 1);
                    Point location = new Point(Math.max(0, pt.x - 500), pt.y);
                    AdvancedSearchDialog dialog = new AdvancedSearchDialog(shell, FilteringTestCaseView.this.txtSearch.getText(), location);
                    if (dialog.open() == 0) {
                        FilteringTestCaseView.this.txtSearch.setText(dialog.getOutput());
                        FilteringTestCaseView.this.showPreviewTestCases();
                    }
                    shell.getSize();
                    shell.dispose();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public void handleEvent(Event event) {
                this.openAdvancedSearchDialog();
            }
        });
        this.cbbExtensions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringTestCaseView.this.onCbbExtensionChangeItem();
            }
        });
        this.lnkFindOnStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://store.katalon.com/search?search=dynamic+execution");
            }
        });
    }

    private void onCbbExtensionChangeItem() {
        if (this.extensions.isEmpty()) {
            return;
        }
        int selectedIndex = this.cbbExtensions.getSelectionIndex();
        this.selectedExtensionDescription = this.extensions.size() > 0 ? (DynamicQueryingTestSuiteDescription)this.extensions.get(selectedIndex).getImplementationClass() : null;
        this.btnPreview.setEnabled(this.selectedExtensionDescription != null);
        this.parentPart.setDirty(true);
    }

    private void showPreviewTestCases() {
        try {
            if (this.selectedExtensionDescription == null) {
                return;
            }
            List filteredTestCases = this.part.getExtensionProvider().getFilteredTestCases(ProjectController.getInstance().getCurrentProject(), (FilteringTestSuiteEntity)this.parentPart.getTestSuiteClone(), this.selectedExtensionDescription, this.txtSearch.getText());
            this.testCaseTableViewer.setInput((Object)filteredTestCases);
            this.setInputForPreviewComposite(filteredTestCases);
        }
        catch (ResourceException | ExecutionException ex) {
            LoggerSingleton.logError((Throwable)ex);
            this.testCaseTableViewer.getTable().setVisible(false);
            this.lblSummary.setText("No test case found");
            this.lblSummary.getParent().getParent().layout(true, true);
        }
    }

    private void setInputForPreviewComposite(List<TestCaseEntity> filteredTestCases) {
        if (filteredTestCases.isEmpty()) {
            this.testCaseTableViewer.getTable().setVisible(false);
            this.lblSummary.setText("No test case found");
        } else {
            this.testCaseTableViewer.getTable().setVisible(true);
            this.lblSummary.setText(String.format("Test cases found: %d", filteredTestCases.size()));
        }
        this.lblSummary.getParent().getParent().layout(true, true);
    }

    public Control getComponent() {
        return this.container;
    }
}

