/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.listeners;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

public class TestDataTableDropListener
extends TableDropTargetEffect {
    private TableViewer tableViewer;
    private TestSuitePartDataBindingView part;

    public TestDataTableDropListener(TableViewer tableViewer, TestSuitePartDataBindingView view) {
        super(tableViewer.getTable());
        this.tableViewer = tableViewer;
        this.part = view;
    }

    public void drop(DropTargetEvent event) {
        event.detail = 1;
        if (this.part != null && this.part.getSelectedTestCaseLink() != null && this.part.getSelectedTestCaseLink().getTestDataLinks() != null) {
            int destIndex;
            List inputs = this.part.getSelectedTestCaseLink().getTestDataLinks();
            Point pt = Display.getCurrent().map(null, (Control)this.tableViewer.getTable(), event.x, event.y);
            TableItem tableItem = this.tableViewer.getTable().getItem(pt);
            TestCaseTestDataLink destItem = tableItem != null && tableItem.getData() instanceof TestCaseTestDataLink ? (TestCaseTestDataLink)tableItem.getData() : null;
            int n = destIndex = destItem != null ? inputs.indexOf(destItem) : inputs.size();
            if (event.data instanceof String) {
                ArrayList<TestCaseTestDataLink> movedItems = new ArrayList<TestCaseTestDataLink>();
                List<String> testDataIds = Arrays.asList(String.valueOf(event.data).split("\n"));
                for (TestCaseTestDataLink link : inputs) {
                    if (!testDataIds.contains(link.getTestDataId())) continue;
                    movedItems.add(link);
                }
                if (movedItems.size() > 0) {
                    inputs.removeAll(movedItems);
                    int i = 0;
                    while (i < movedItems.size()) {
                        inputs.add(destIndex + i, (TestCaseTestDataLink)movedItems.get(i));
                        ++i;
                    }
                }
                this.tableViewer.refresh();
                this.part.refreshVariableTable();
                this.tableViewer.setSelection((ISelection)new StructuredSelection(movedItems.get(0)));
                this.part.setDirty(true);
            } else if (event.data instanceof ITreeEntity[]) {
                try {
                    ArrayList<TestCaseTestDataLink> addedTestDataLinkTreeNodes = new ArrayList<TestCaseTestDataLink>();
                    ITreeEntity[] iTreeEntityArray = (ITreeEntity[])event.data;
                    int n2 = iTreeEntityArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        ITreeEntity iTreeEntity = iTreeEntityArray[n3];
                        if (iTreeEntity instanceof TestDataTreeEntity) {
                            DataFileEntity testData = ((TestDataTreeEntity)iTreeEntity).getObject();
                            TestCaseTestDataLink testDataLink = new TestCaseTestDataLink();
                            testDataLink.setTestDataId(testData.getIdForDisplay());
                            testDataLink.getId();
                            addedTestDataLinkTreeNodes.add(testDataLink);
                        } else if (iTreeEntity instanceof FolderTreeEntity && ((FolderTreeEntity)iTreeEntity).getObject().getFolderType() == FolderEntity.FolderType.DATAFILE) {
                            this.collectTestCaseTestDataLinksRecursively(iTreeEntity, addedTestDataLinkTreeNodes);
                        }
                        ++n3;
                    }
                    int i = 0;
                    while (i < addedTestDataLinkTreeNodes.size()) {
                        inputs.add(destIndex + i, (TestCaseTestDataLink)addedTestDataLinkTreeNodes.get(i));
                        ++i;
                    }
                    if (addedTestDataLinkTreeNodes.size() > 0) {
                        this.tableViewer.refresh();
                        this.tableViewer.setSelection((ISelection)new StructuredSelection(addedTestDataLinkTreeNodes));
                        this.part.refreshVariableTable();
                        this.part.setDirty(true);
                    }
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        }
    }

    private void collectTestCaseTestDataLinksRecursively(ITreeEntity iTreeEntity, List<TestCaseTestDataLink> list) throws Exception {
        if (iTreeEntity instanceof TestDataTreeEntity) {
            DataFileEntity testData = ((TestDataTreeEntity)iTreeEntity).getObject();
            TestCaseTestDataLink testDataLink = new TestCaseTestDataLink();
            testDataLink.setTestDataId(testData.getIdForDisplay());
            testDataLink.getId();
            list.add(testDataLink);
        } else if (iTreeEntity instanceof FolderTreeEntity && ((FolderTreeEntity)iTreeEntity).getObject().getFolderType() == FolderEntity.FolderType.DATAFILE) {
            Object[] objectArray = ((FolderTreeEntity)iTreeEntity).getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                this.collectTestCaseTestDataLinksRecursively((ITreeEntity)obj, list);
                ++n2;
            }
        }
    }
}

