/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.dialogs;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.dialogs.provider.ScriptVariableTypeEditingSupport;
import com.kms.katalon.composer.testsuite.dialogs.provider.ScriptVariableValueEditingSupport;
import com.kms.katalon.composer.testsuite.dialogs.provider.VariableScriptBuilderLabelProvider;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class VariableBindingScriptBuilderDialog
extends AbstractDialog {
    private static final Point MIN_SIZE = new Point(500, 300);
    private TestSuiteTestCaseLink testCaseLink;
    private VariableLink variableLink;
    private CTableViewer tableViewer;
    private Composite composite;
    private ScriptVariableValueEditingSupport editingSupport;

    public VariableBindingScriptBuilderDialog(Shell parentShell, TestSuiteTestCaseLink testCaseLink, VariableLink variableLink) {
        super(parentShell);
        this.testCaseLink = testCaseLink;
        this.variableLink = variableLink;
    }

    public String getDialogTitle() {
        return StringConstants.DIA_TITLE_VARIABLE_BINDING_VALUE_BUILDER;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        this.tableViewer.setInput((Object)new VariableLink[]{this.variableLink});
    }

    protected Control createDialogContainer(Composite parent) {
        this.composite = new Composite(parent, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.composite.setLayout((Layout)tableLayout);
        this.tableViewer = new CTableViewer(this.composite, 67584);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tblclmnName = this.createColumn(StringConstants.NAME, this.newCellLabelProvider(0), null);
        tableLayout.setColumnData((Widget)tblclmnName, (ColumnLayoutData)new ColumnWeightData(30));
        TableColumn tblclmnType = this.createColumn(StringConstants.TYPE, this.newCellLabelProvider(1), (EditingSupport)new ScriptVariableTypeEditingSupport((ColumnViewer)this.tableViewer));
        tableLayout.setColumnData((Widget)tblclmnType, (ColumnLayoutData)new ColumnWeightData(28, 110));
        TableColumn tblclmnValue = this.createColumn(StringConstants.VALUE, this.newCellLabelProvider(2), (EditingSupport)new ScriptVariableValueEditingSupport((ColumnViewer)this.tableViewer));
        tableLayout.setColumnData((Widget)tblclmnValue, (ColumnLayoutData)new ColumnWeightData(40));
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.addToolTipSupportForTable(table);
        return this.composite;
    }

    private void addToolTipSupportForTable(Table table) {
        table.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
    }

    private CellLabelProvider newCellLabelProvider(int columnIndex) {
        return new VariableScriptBuilderLabelProvider(columnIndex, this.testCaseLink);
    }

    private TableColumn createColumn(String tableName, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(StringUtils.defaultString((String)tableName));
        if (labelProvider != null) {
            tableViewerColumn.setLabelProvider(labelProvider);
        }
        if (editingSupport != null) {
            tableViewerColumn.setEditingSupport(editingSupport);
            if (StringConstants.VALUE.equals(tableName)) {
                this.editingSupport = (ScriptVariableValueEditingSupport)editingSupport;
            }
        }
        return tableColumn;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(MIN_SIZE);
    }

    protected Point getInitialSize() {
        return MIN_SIZE;
    }

    public VariableLink getNewValue() {
        return this.variableLink;
    }

    protected void okPressed() {
        if (this.editingSupport != null) {
            AstValueUtil.applyEditingValue((CellEditor)this.editingSupport.getEditor());
        }
        super.okPressed();
    }

    public ScriptVariableValueEditingSupport getEditor() {
        return this.editingSupport;
    }
}

