/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TestCaseSelectionDialog
extends TreeEntitySelectionDialog {
    private TestCaseTableViewer tableViewer;
    private List<Object> tcTreeEntities;
    private List<Object> checkedItems;

    public TestCaseSelectionDialog(Shell parent, IEntityLabelProvider labelProvider, ITreeContentProvider contentProvider, AbstractEntityViewerFilter entityViewerFilter, TestCaseTableViewer tableViewer) {
        super(parent, labelProvider, contentProvider, entityViewerFilter);
        this.tableViewer = tableViewer;
        this.setTitle(StringConstants.DIA_TITLE_TEST_CASE_BROWSER);
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.updateTestCaseTreeEntities();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 20, StringConstants.DIA_BTN_ADD_N_CONTINUE, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (20 == buttonId) {
            this.addSelectedTestCasesPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.computeResult();
        this.setReturnCode(0);
        try {
            this.updateTestCaseTableViewer();
        }
        catch (Exception exception) {}
        this.close();
    }

    private void addSelectedTestCasesPressed() {
        this.computeResult();
        if (this.getResult() == null || this.getResult().length == 0) {
            MessageDialog.openWarning((Shell)this.getParentShell(), (String)StringConstants.WARN_TITLE, (String)StringConstants.DIA_WARN_NO_TEST_CASE_SELECTION);
            return;
        }
        this.setReturnCode(20);
        try {
            this.updateTestCaseTableViewer();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.checkedItems.removeAll(grayedItems);
        this.setResult(this.checkedItems);
    }

    public void updateTestCaseTableViewer() throws Exception {
        ArrayList<Object> selectedObjects = new ArrayList<Object>(Arrays.asList(this.getResult()));
        this.tableViewer.getInput();
        for (Object e : selectedObjects) {
            if (!(e instanceof ITreeEntity)) continue;
            ITreeEntity treeEntity = (ITreeEntity)e;
            if (treeEntity instanceof FolderTreeEntity) {
                this.addTestCaseFolderToTable((FolderEntity)treeEntity.getObject());
                continue;
            }
            if (!(treeEntity instanceof TestCaseTreeEntity)) continue;
            this.tableViewer.addTestCase((TestCaseEntity)treeEntity.getObject());
        }
        this.updateTestCaseTreeEntities();
    }

    private void addTestCaseFolderToTable(FolderEntity folderEntity) throws Exception {
        if (folderEntity.getFolderType() == FolderEntity.FolderType.TESTCASE) {
            FolderController folderController = FolderController.getInstance();
            for (Object childObject : folderController.getChildren(folderEntity)) {
                if (childObject instanceof TestCaseEntity) {
                    this.tableViewer.addTestCase((TestCaseEntity)childObject);
                    continue;
                }
                if (!(childObject instanceof FolderEntity)) continue;
                this.addTestCaseFolderToTable((FolderEntity)childObject);
            }
        }
    }

    private void updateTestCaseTreeEntities() {
        try {
            this.tcTreeEntities = new ArrayList<Object>(Arrays.asList(this.getAddedTestCase(this.tableViewer.getTestCasesPKs())));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public TreeViewer createTreeViewer(Composite parent) {
        final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        treeViewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    treeViewer.getTree().setSelection(item);
                    TestCaseSelectionDialog.this.onStageChangedTreeItem(item.getData(), item.getChecked());
                }
            }
        });
        Object[] addedTestCases = this.getAddedTestCase(this.tableViewer.getTestCasesPKs());
        treeViewer.setCheckedElements(addedTestCases);
        this.checkedItems = new ArrayList<Object>(Arrays.asList(addedTestCases));
        return treeViewer;
    }

    private void onStageChangedTreeItem(Object element, boolean isChecked) {
        if (element instanceof TestCaseTreeEntity) {
            if (isChecked) {
                this.checkedItems.add(element);
            } else {
                this.checkedItems.remove(element);
            }
            return;
        }
        if (element instanceof FolderTreeEntity) {
            try {
                ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren((FolderTreeEntity)((FolderTreeEntity)element));
                int n = iTreeEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeEntity childElement = iTreeEntityArray[n2];
                    this.onStageChangedTreeItem(childElement, isChecked);
                    ++n2;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    protected void filterSearchedText() {
        super.filterSearchedText();
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        treeViewer.setCheckedElements(this.checkedItems.toArray());
    }

    private Object[] getAddedTestCase(List<String> ids) {
        ArrayList testCaseList = new ArrayList();
        try {
            TestCaseController c = TestCaseController.getInstance();
            for (String id : ids) {
                TestCaseEntity tc = c.getTestCase(id);
                TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)tc, (ProjectEntity)tc.getProject());
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return testCaseList.toArray();
    }
}

