/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.dialogs;

import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.entity.link.IterationEntity;
import com.kms.katalon.entity.link.IterationType;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DataIterationDialog
extends Dialog {
    private IterationEntity iterationEntity;
    private Spinner spinnerFrom;
    private Spinner spinnerTo;
    private Button btnRunAllRows;
    private Button btnRunFromRow;
    private Button btnRunSpecificRows;
    private Text textSpecificRow;
    private ControlDecoration controlDecoration;

    public DataIterationDialog(Shell parentShell, IterationEntity iterationEntity) {
        super(parentShell);
        this.iterationEntity = iterationEntity;
    }

    public void create() {
        super.create();
        this.getShell().setText(StringConstants.DIA_SHELL_DATA_ITERATION);
        this.registerListeners();
        this.initSelection();
    }

    private void initSelection() {
        switch (this.iterationEntity.getIterationType()) {
            case ALL: {
                this.btnRunAllRows.setSelection(true);
                this.spinnerFrom.setEnabled(false);
                this.spinnerTo.setEnabled(false);
                this.textSpecificRow.setEnabled(false);
                break;
            }
            case RANGE: {
                this.btnRunFromRow.setSelection(true);
                this.spinnerFrom.setEnabled(true);
                this.spinnerTo.setEnabled(true);
                this.textSpecificRow.setEnabled(false);
                this.spinnerFrom.setSelection(this.iterationEntity.getFrom());
                this.spinnerTo.setSelection(this.iterationEntity.getTo());
                break;
            }
            case SPECIFIC: {
                this.btnRunSpecificRows.setSelection(true);
                this.spinnerFrom.setEnabled(false);
                this.spinnerTo.setEnabled(false);
                this.textSpecificRow.setEnabled(true);
                this.textSpecificRow.setText(this.iterationEntity.getValue());
            }
        }
    }

    private void registerListeners() {
        this.btnRunAllRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataIterationDialog.this.spinnerFrom.setEnabled(false);
                DataIterationDialog.this.spinnerTo.setEnabled(false);
                DataIterationDialog.this.textSpecificRow.setEnabled(false);
            }
        });
        this.btnRunFromRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataIterationDialog.this.spinnerFrom.setEnabled(true);
                DataIterationDialog.this.spinnerTo.setEnabled(true);
                DataIterationDialog.this.textSpecificRow.setEnabled(false);
            }
        });
        this.spinnerFrom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataIterationDialog.this.validateRangeIteration();
            }
        });
        this.spinnerTo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataIterationDialog.this.validateRangeIteration();
            }
        });
        this.spinnerFrom.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                DataIterationDialog.this.verifySpinnerEvent(event);
            }
        });
        this.spinnerTo.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                DataIterationDialog.this.verifySpinnerEvent(event);
            }
        });
        this.btnRunSpecificRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataIterationDialog.this.textSpecificRow.setEnabled(true);
                DataIterationDialog.this.spinnerFrom.setEnabled(false);
                DataIterationDialog.this.spinnerTo.setEnabled(false);
            }
        });
        this.textSpecificRow.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                DataIterationDialog.this.verifySpecificTextEvent(e);
            }
        });
        this.textSpecificRow.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataIterationDialog.this.validateSpecificInteration();
            }
        });
    }

    private void verifySpinnerEvent(Event event) {
        Spinner spinner = (Spinner)event.widget;
        StringBuilder builder = new StringBuilder(spinner.getText());
        builder.replace(event.start, event.end, event.text);
        String newSpinnerText = builder.toString();
        if (!newSpinnerText.isEmpty() && !this.isInteger(newSpinnerText)) {
            Display.getCurrent().beep();
            event.doit = false;
        }
    }

    private void verifySpecificTextEvent(VerifyEvent event) {
        Text txt = (Text)event.widget;
        StringBuilder builder = new StringBuilder(txt.getText());
        builder.replace(event.start, event.end, event.text);
        String newSpinnerText = builder.toString().replace(" ", "");
        if (!newSpinnerText.isEmpty() && !Pattern.matches("(\\d+|\\-|,)*", newSpinnerText)) {
            Display.getCurrent().beep();
            event.doit = false;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 4;
        this.btnRunAllRows = new Button(container, 16);
        this.btnRunAllRows.setText(StringConstants.DIA_BTN_RUN_ALL_ROWS);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.btnRunFromRow = new Button(container, 16);
        this.btnRunFromRow.setText(StringConstants.DIA_BTN_RUN_FROM_ROW);
        this.spinnerFrom = new Spinner(container, 2048);
        this.spinnerFrom.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.spinnerFrom.setMinimum(1);
        this.spinnerFrom.setMaximum(Integer.MAX_VALUE);
        this.spinnerFrom.setIncrement(1);
        this.spinnerFrom.setTextLimit(Integer.MAX_VALUE);
        this.controlDecoration = new ControlDecoration((Control)this.spinnerFrom, 16512);
        Image imgNotification = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.controlDecoration.setImage(imgNotification);
        this.controlDecoration.setDescriptionText(StringConstants.DIA_MSG_START_ROW_BIGGER_THAN_END_ROW);
        this.controlDecoration.hide();
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText(StringConstants.DIA_LBL_TO_ROW);
        this.spinnerTo = new Spinner(container, 2048);
        this.spinnerTo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.spinnerTo.setMinimum(1);
        this.spinnerTo.setMaximum(Integer.MAX_VALUE);
        this.spinnerTo.setIncrement(1);
        this.spinnerTo.setTextLimit(Integer.MAX_VALUE);
        this.btnRunSpecificRows = new Button(container, 16);
        this.btnRunSpecificRows.setText(StringConstants.DIA_BTN_RUN_SPECIFIC_ROWS);
        this.textSpecificRow = new Text(container, 2048);
        this.textSpecificRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        return container;
    }

    protected void okPressed() {
        this.prepareReturnValue();
        super.okPressed();
    }

    private void prepareReturnValue() {
        if (this.btnRunAllRows.getSelection()) {
            this.iterationEntity.setIterationType(IterationType.ALL);
        }
        if (this.btnRunFromRow.getSelection()) {
            this.iterationEntity.setIterationType(IterationType.RANGE);
            this.iterationEntity.setRangeValue(this.spinnerFrom.getSelection(), this.spinnerTo.getSelection());
        }
        if (this.btnRunSpecificRows.getSelection()) {
            this.iterationEntity.setIterationType(IterationType.SPECIFIC);
            this.iterationEntity.setSpecificValue(this.textSpecificRow.getText());
        }
    }

    protected Point getInitialSize() {
        return new Point(500, 200);
    }

    protected void setShellStyle(int arg) {
        super.setShellStyle(65648);
    }

    private void validateRangeIteration() {
        if (!this.isInteger(this.spinnerFrom.getText()) || !this.isInteger(this.spinnerTo.getText())) {
            this.getButton(0).setEnabled(false);
            return;
        }
        if (Integer.valueOf(this.spinnerFrom.getText()) > Integer.valueOf(this.spinnerTo.getText())) {
            this.getButton(0).setEnabled(false);
            this.controlDecoration.show();
        } else {
            this.getButton(0).setEnabled(true);
            this.controlDecoration.hide();
        }
    }

    private void validateSpecificInteration() {
        String textSpecific = this.textSpecificRow.getText().trim();
        String positiveNumber = "\\s*[1-9][0-9]*\\s*";
        String positiveNumberCorePattern = "(" + positiveNumber + "\\-" + positiveNumber + "|" + positiveNumber + ")";
        if (Pattern.matches(String.valueOf(positiveNumberCorePattern) + "(," + positiveNumberCorePattern + ")*,?", textSpecific)) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public IterationEntity getIterationEntity() {
        return this.iterationEntity;
    }

    public boolean isInteger(String s) {
        try {
            int value = Integer.parseInt(s);
            return value >= 1;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }
}

