/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.logging;

import com.kms.katalon.logging.LogMode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.Platform;

public class SystemLogger
extends PrintStream {
    private LogMode logMode;
    private boolean locked;
    private PrintStream writer;

    SystemLogger(OutputStream os, LogMode defaultMode) {
        super(os, true);
        this.logMode = defaultMode;
        this.locked = false;
    }

    SystemLogger(OutputStream os, LogMode defaultMode, String encode) throws UnsupportedEncodingException {
        super(os, true, encode);
        this.logMode = defaultMode;
        this.locked = false;
    }

    void changeMode(LogMode mode) {
        this.logMode = mode;
    }

    LogMode getMode() {
        return this.logMode;
    }

    void lock() {
        this.locked = true;
    }

    void unlock() {
        this.locked = false;
    }

    void waitFor() {
        while (this.locked) {
        }
    }

    synchronized void waitForAndLock() {
        this.waitFor();
        this.lock();
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) {
        try {
            try {
                switch (this.logMode) {
                    case CONSOLE: {
                        super.write(buf, off, len);
                        break;
                    }
                    case LOG: {
                        File logFile = this.getLogFile();
                        FileUtils.writeByteArrayToFile((File)logFile, (byte[])ArrayUtils.subarray((byte[])buf, (int)off, (int)len), (boolean)true);
                    }
                }
            }
            catch (IOException iOException) {
                if (this.writer != null) {
                    this.writer.write(buf, off, len);
                }
            }
        }
        finally {
            if (this.writer != null) {
                this.writer.write(buf, off, len);
            }
        }
    }

    private File getLogFile() {
        return Platform.getLogFileLocation().toFile();
    }

    public void setWriter(PrintStream printStream) {
        this.writer = printStream;
    }
}

