/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.logging;

import com.kms.katalon.logging.LogManager;
import com.kms.katalon.logging.LogMode;
import com.kms.katalon.logging.SystemLogger;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class LogUtil {
    private LogUtil() {
    }

    public static void printOutputLine(String message) {
        LogUtil.println(LogManager.getOutputLogger(), message, LogMode.CONSOLE);
    }

    public static void printErrorLine(String message) {
        LogUtil.println(LogManager.getErrorLogger(), message, LogMode.CONSOLE);
    }

    public static void logErrorMessage(String message) {
        LogUtil.logError(null, message);
    }

    public static void logError(Throwable t) {
        LogUtil.logError(t, "");
    }

    private static void writeError(final LogMode logMode, final Throwable t, final String message) {
        final SystemLogger errorLogger = LogManager.getErrorLogger();
        LogUtil.logSync(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                errorLogger.changeMode(logMode);
                errorLogger.println();
                errorLogger.println(new Date().toString());
                if (StringUtils.isNotEmpty((String)message)) {
                    errorLogger.println(message);
                }
                if (t != null) {
                    errorLogger.println(ExceptionUtils.getStackTrace((Throwable)t));
                }
                errorLogger.println();
                return null;
            }
        }, errorLogger);
    }

    public static void printAndLogError(Throwable t) {
        LogUtil.writeError(LogMode.CONSOLE, t, "");
        LogUtil.writeError(LogMode.LOG, t, "");
    }

    public static void printAndLogError(Throwable t, String message) {
        LogUtil.writeError(LogMode.CONSOLE, t, message);
        LogUtil.writeError(LogMode.LOG, t, message);
    }

    public static void logError(Throwable t, String message) {
        LogUtil.writeError(LogMode.LOG, t, message);
    }

    public static void println(final SystemLogger logger, final String line, final LogMode mode) {
        if (logger == null) {
            return;
        }
        LogUtil.logSync(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                logger.changeMode(mode);
                logger.println(line);
                return null;
            }
        }, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logSync(Callable<Object> caller, SystemLogger logger) {
        SystemLogger systemLogger = logger;
        synchronized (systemLogger) {
            block8: {
                logger.waitForAndLock();
                LogMode oldMode = logger.getMode();
                try {
                    try {
                        caller.call();
                    }
                    catch (Exception exception) {
                        logger.changeMode(oldMode);
                        logger.unlock();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    logger.changeMode(oldMode);
                    logger.unlock();
                    throw throwable;
                }
                logger.changeMode(oldMode);
                logger.unlock();
            }
        }
    }
}

