/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.reset;

import gr.org.objectweb.asm.ClassAdapter;
import gr.org.objectweb.asm.ClassReader;
import gr.org.objectweb.asm.ClassWriter;
import gr.org.objectweb.asm.FieldVisitor;
import gr.org.objectweb.asm.MethodAdapter;
import gr.org.objectweb.asm.MethodVisitor;
import gr.org.objectweb.asm.Opcodes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class ClassPreProcessorAgentAdapter
implements ClassFileTransformer {
    private static final boolean debug = false;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        if (classBeingRedefined != null) {
            boolean lookedLikeGroovy = false;
            try {
                Method swapInitMethod = classBeingRedefined.getDeclaredMethod("__$swapInit", new Class[0]);
                if (swapInitMethod != null) {
                    swapInitMethod.setAccessible(true);
                    swapInitMethod.invoke(null, new Object[0]);
                }
                lookedLikeGroovy = true;
            }
            catch (Throwable swapInitMethod) {
                // empty catch block
            }
            try {
                Field callSiteArrayField = classBeingRedefined.getDeclaredField("$callSiteArray");
                callSiteArrayField.setAccessible(true);
                callSiteArrayField.set(null, null);
                lookedLikeGroovy = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (lookedLikeGroovy) {
                return ClassPreProcessorAgentAdapter.stripOutTimestamps(bytes);
            }
        }
        return null;
    }

    private static byte[] stripOutTimestamps(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        Stripper stripper = new Stripper();
        cr.accept(stripper, 0);
        return stripper.getBytes();
    }

    public static void main(String[] argv) {
        try {
            byte[] data = ClassPreProcessorAgentAdapter.loadFromStream(new FileInputStream(argv[0]));
            data = ClassPreProcessorAgentAdapter.stripOutTimestamps(data);
            FileOutputStream fos = new FileOutputStream(String.valueOf(argv[0]) + ".2");
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            bos.write(data);
            bos.close();
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static byte[] loadFromStream(InputStream stream) {
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            int size = 2048;
            byte[] theData = new byte[size];
            int dataReadSoFar = 0;
            byte[] buffer = new byte[size / 2];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                if (read + dataReadSoFar > theData.length) {
                    byte[] newTheData = new byte[theData.length * 2];
                    System.arraycopy(theData, 0, newTheData, 0, dataReadSoFar);
                    theData = newTheData;
                }
                System.arraycopy(buffer, 0, theData, dataReadSoFar, read);
                dataReadSoFar += read;
            }
            bis.close();
            byte[] returnData = new byte[dataReadSoFar];
            System.arraycopy(theData, 0, returnData, 0, dataReadSoFar);
            return returnData;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpectedly unable to load bytedata from input stream", e);
        }
    }

    static class PutstaticToPop
    extends MethodAdapter
    implements Opcodes {
        public PutstaticToPop(MethodVisitor mv) {
            super(mv);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (name.startsWith("__timeStamp")) {
                this.mv.visitInsn(88);
            } else {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }

    static class Stripper
    extends ClassAdapter
    implements Opcodes {
        ClassWriter cw;

        public Stripper() {
            super(new ClassWriter(0));
            this.cw = (ClassWriter)this.cv;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (!name.startsWith("__timeStamp")) {
                return super.visitField(access, name, desc, signature, value);
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            if (name.equals("<clinit>")) {
                return new PutstaticToPop(mv);
            }
            return mv;
        }

        public byte[] getBytes() {
            return this.cw.toByteArray();
        }
    }
}

