/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.template;

import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ClassUtils;

public class TemplateProjectGenerator {
    private static final String TEMPL_PROJ_JAR_ENTRY = "resources/templates/Katalon Get Started Project.zip";
    private static final String WEB_UI_FOLDER = "Web UI";
    private static final String MOBILE_FOLDER = "Mobile";
    private static final String WEB_API_FOLDER = "Web API";
    private static final String DATA_FOLDER = "Data";
    private static final String CUSTOM_KEYWORD_PKG = "com.example";
    private static final String SAMPLE_ANDROID_APP = "androidapp";
    private String PROJECT_NAME_OPEN_TAG = "<name>";
    private String PROJECT_NAME_CLOSE_TAG = "</name>";
    private static final String[] WEB_UI_CUSTOM_KWS = new String[]{"WebUiCustomKeywords.groovy", "DatabaseUtils.groovy"};
    private static final String[] WEB_API_CUSTOM_KWS = new String[]{"WebApiCustomKeywords.groovy"};
    private static final String TEMPL_PROJECT_NAME = "Katalon Get Started Project";
    private String[] artifacts = new String[]{GlobalStringConstants.ROOT_FOLDER_NAME_TEST_CASE, GlobalStringConstants.TEST_CASE_SCRIPT_ROOT_FOLDER_NAME, GlobalStringConstants.ROOT_FOLDER_NAME_OBJECT_REPOSITORY, GlobalStringConstants.ROOT_FOLDER_NAME_TEST_SUITE, GlobalStringConstants.ROOT_FOLDER_NAME_DATA_FILE, "Data"};
    private String location;
    private String projectName;
    private File projectFolder;

    public TemplateProjectGenerator(String location, String projectName) {
        this.location = location;
        this.projectName = projectName;
        this.projectFolder = new File(location, projectName);
    }

    public void copyTemplates(List<String> templates) throws IOException {
        if (templates == null || templates.size() == 0) {
            return;
        }
        this.extractProjectZipFile();
        this.renameProject();
        this.deleteUnselectedComponents(templates);
    }

    private void renameProject() throws IOException {
        File tmplProjectFolder = new File(this.location, TEMPL_PROJECT_NAME);
        tmplProjectFolder.renameTo(this.projectFolder);
        File prjFile = new File(this.projectFolder, String.valueOf(this.projectName) + ProjectEntity.getProjectFileExtension());
        new File(this.projectFolder, TEMPL_PROJECT_NAME + ProjectEntity.getProjectFileExtension()).renameTo(prjFile);
        StringBuilder sb = new StringBuilder(FileUtils.readFileToString((File)prjFile));
        sb.replace(sb.indexOf(this.PROJECT_NAME_OPEN_TAG) + this.PROJECT_NAME_OPEN_TAG.length(), sb.indexOf(this.PROJECT_NAME_CLOSE_TAG), this.projectName);
        FileUtils.writeStringToFile((File)prjFile, (String)sb.toString(), (boolean)false);
    }

    private void deleteUnselectedComponents(List<String> templates) throws IOException {
        ArrayList<String> removedCompoments = new ArrayList<String>(){
            {
                this.add(TemplateProjectGenerator.WEB_UI_FOLDER);
                this.add(TemplateProjectGenerator.MOBILE_FOLDER);
                this.add(TemplateProjectGenerator.WEB_API_FOLDER);
            }
        };
        for (String template : templates) {
            String component = StringConstants.VIEW_LBL_WEB_TESTING.equals(template) ? WEB_UI_FOLDER : (StringConstants.VIEW_LBL_MOBILE_TESTING.equals(template) ? MOBILE_FOLDER : WEB_API_FOLDER);
            removedCompoments.remove(component);
        }
        for (String component : removedCompoments) {
            this.removeTestArtifacts(component);
            if (WEB_UI_FOLDER.equals(component)) {
                this.deleteCustomKeywords(WEB_UI_CUSTOM_KWS);
                FileUtils.cleanDirectory((File)new File(this.projectFolder, GlobalStringConstants.ROOT_FOLDER_NAME_DRIVERS));
            }
            if (WEB_API_FOLDER.equals(component)) {
                this.deleteCustomKeywords(WEB_API_CUSTOM_KWS);
            }
            if (!MOBILE_FOLDER.equals(component)) continue;
            FileUtils.deleteDirectory((File)new File(this.projectFolder, SAMPLE_ANDROID_APP));
        }
    }

    private void deleteCustomKeywords(String[] fileNames) throws IOException {
        String customKwPackageFolder = String.valueOf(GlobalStringConstants.ROOT_FOLDER_NAME_KEYWORD) + File.separator + CUSTOM_KEYWORD_PKG.replace(ClassUtils.PACKAGE_SEPARATOR, File.separator);
        File destPackage = new File(this.projectFolder, customKwPackageFolder);
        if (!destPackage.exists()) {
            return;
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File webUiKeywordFile = new File(destPackage, fileName);
            if (webUiKeywordFile.exists()) {
                FileUtils.deleteQuietly((File)webUiKeywordFile);
            }
            ++n2;
        }
        if (destPackage.exists() && destPackage.listFiles().length == 0) {
            FileUtils.deleteQuietly((File)destPackage.getParentFile());
        }
    }

    private void removeTestArtifacts(String component) throws IOException {
        String[] stringArray = this.artifacts;
        int n = this.artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            String artifact = stringArray[n2];
            File folder = new File(this.projectFolder, String.valueOf(artifact) + File.separator + component);
            if (folder.exists()) {
                FileUtils.deleteQuietly((File)folder);
            }
            ++n2;
        }
    }

    private void extractProjectZipFile() throws IOException {
        String path = TemplateProjectGenerator.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(TEMPL_PROJ_JAR_ENTRY)) continue;
                this.processZipFileInputStream(jar.getInputStream(jarEntry));
                break;
            }
            jar.close();
        } else {
            File zipFile = new File(String.valueOf(path) + File.separator + TEMPL_PROJ_JAR_ENTRY);
            this.processZipFileInputStream(new FileInputStream(zipFile));
        }
    }

    private void processZipFileInputStream(InputStream is) throws IOException {
        try (ZipInputStream stream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                File file = new File(this.location, entry.getName());
                if (entry.isDirectory()) {
                    if (file.exists()) continue;
                    file.mkdirs();
                    continue;
                }
                this.writeZipEntryToFile(stream, file);
            }
        }
    }

    private void writeZipEntryToFile(ZipInputStream zis, File outputFile) throws IOException {
        byte[] buffer = new byte[2048];
        try (FileOutputStream output = null;){
            output = new FileOutputStream(outputFile);
            int len = 0;
            while ((len = zis.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
    }
}

