/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.preference;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.handlers.OpenProjectHandler;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectPropertiesPreferencePage
extends PreferencePage {
    private static ProjectController projectController = ProjectController.getInstance();
    private static final int DF_DESCRIPTION_LINE_NUMBER = 4;
    private Text txtName;
    private Text txtLocation;
    private StyledText txtDescription;
    private ProjectEntity project = projectController.getCurrentProject();
    private Label lblErrorMessage;
    private Composite container;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 15;
        glContainer.verticalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        Label lblName = new Label(this.container, 0);
        lblName.setText(StringConstants.NAME);
        this.txtName = new Text(this.container, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLocation = new Label(this.container, 0);
        lblLocation.setText(StringConstants.VIEW_LBL_LOCATION);
        this.txtLocation = new Text(this.container, 2056);
        this.txtLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(this.container, 0);
        lblDescription.setText(StringConstants.VIEW_LBL_DESCRIPTION);
        this.txtDescription = new StyledText(this.container, 2818);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridData layout = new GridData(1808);
        layout.grabExcessVerticalSpace = false;
        GC graphicContext = new GC((Drawable)this.txtDescription);
        FontMetrics fm = graphicContext.getFontMetrics();
        layout.heightHint = 4 * fm.getHeight();
        this.txtDescription.setLayoutData((Object)layout);
        new Label(this.container, 0);
        this.lblErrorMessage = new Label(this.container, 64);
        this.lblErrorMessage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblErrorMessage.setForeground(ColorUtil.getTextErrorColor());
        graphicContext.dispose();
        this.setInput();
        this.registerControlModifyListener();
        return this.container;
    }

    private void setInput() {
        this.txtName.setText(this.project.getName());
        this.txtLocation.setText(this.project.getFolderLocation());
        this.txtDescription.setText(this.project.getDescription());
        this.lblErrorMessage.setText("");
    }

    private void registerControlModifyListener() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectPropertiesPreferencePage.this.getApplyButton().setEnabled(ProjectPropertiesPreferencePage.this.validateProjectName());
            }
        });
        this.txtDescription.addListener(24, ControlUtils.getAutoHideStyledTextScrollbarListener);
        this.txtDescription.addListener(11, ControlUtils.getAutoHideStyledTextScrollbarListener);
    }

    private boolean validateProjectName() {
        String newProjectName = this.txtName.getText();
        if (newProjectName.equals(this.project.getName())) {
            return true;
        }
        if (StringUtils.isBlank((String)newProjectName)) {
            this.lblErrorMessage.setText(StringConstants.VIEW_ERROR_MSG_PROJ_NAME_CANNOT_BE_BLANK);
            return false;
        }
        try {
            EntityNameController.getInstance().validateName(newProjectName);
        }
        catch (Exception e) {
            this.lblErrorMessage.setText(e.getMessage());
            return false;
        }
        this.lblErrorMessage.setText("");
        return true;
    }

    public boolean okToLeave() {
        return this.isNotOpenedYet() || this.isValidInput();
    }

    public boolean performOk() {
        if (this.isNotOpenedYet()) {
            return true;
        }
        boolean valid = this.isValidInput();
        if (valid) {
            this.updateProject();
        }
        return valid;
    }

    private void updateProject() {
        try {
            projectController.updateProject(this.txtName.getText(), this.txtDescription.getText(), this.project.getId());
            OpenProjectHandler.updateProjectTitle(this.project, ModelServiceSingleton.getInstance().getModelService(), ApplicationSingleton.getInstance().getApplication());
            EventBrokerSingleton.getInstance().getEventBroker().post("PROJECT/UPDATED", (Object)true);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
    }

    private boolean isValidInput() {
        return this.lblErrorMessage.getText().isEmpty();
    }

    private boolean isNotOpenedYet() {
        return this.container == null || this.container.isDisposed();
    }

    protected void performDefaults() {
        this.setInput();
    }
}

