/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.menu;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.menu.ProjectParameterizedCommandBuilder;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RecentProjectsMenuContribution
implements EventHandler {
    @Inject
    private IEventBroker eventBroker;
    private static List<ProjectEntity> recentProjects = new ArrayList<ProjectEntity>();

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe("WORKSPACE/CREATED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CREATED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/UPDATED", (EventHandler)this);
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            menuItems.add((MMenuElement)this.newMenuSeparator());
            ProjectParameterizedCommandBuilder commandBuilder = new ProjectParameterizedCommandBuilder();
            for (ProjectEntity project : recentProjects) {
                MCommand command = MCommandsFactory.INSTANCE.createCommand();
                command.setCommandName("Temp");
                String labelName = String.valueOf(project.getName()) + "\t" + this.getLocationStringLabel(project.getFolderLocation());
                MHandledMenuItem recentProjectMenuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
                recentProjectMenuItem.setLabel(labelName);
                recentProjectMenuItem.setContributorURI(ConstantsHelper.getApplicationURI());
                recentProjectMenuItem.setCommand(command);
                recentProjectMenuItem.setTooltip("");
                recentProjectMenuItem.setWbCommand(commandBuilder.createRecentProjectParameterizedCommand(project));
                menuItems.add((MMenuElement)recentProjectMenuItem);
            }
            if (!recentProjects.isEmpty()) {
                menuItems.add((MMenuElement)this.newMenuSeparator());
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MMenuSeparator newMenuSeparator() {
        return MMenuFactory.INSTANCE.createMenuSeparator();
    }

    private String getLocationStringLabel(String location) {
        if (location.length() > 60) {
            return String.valueOf(location.substring(0, 60)) + "...";
        }
        return location;
    }

    public void handleEvent(Event event) {
        try {
            recentProjects.clear();
            recentProjects.addAll(ProjectController.getInstance().getRecentProjects());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

