/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.katalon.platform.api.Extension;
import com.katalon.platform.api.extension.PluginPreferencePage;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.exception.MissingProjectSettingPageException;
import com.kms.katalon.composer.project.handlers.DefinedOrderedPageComparator;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.preferences.PreferenceNodeDescription;
import com.kms.katalon.preferences.internal.PreferenceNodeDescriptionImpl;
import com.kms.katalon.preferences.internal.PreferencesRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SettingHandler {
    private static final String PARENT_PLUGIN_PREFERENCE_PAGE_ID = "com.kms.katalon.composer.project.preference.pluginPreferencePage";
    @Inject
    private IEclipseContext eclipseContext;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !LauncherManager.getInstance().isAnyLauncherRunning();
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, PreferencesRegistry preferencesRegistry) {
        this.openSettingsDialogToPage(shell, preferencesRegistry, null);
    }

    @Inject
    @Optional
    public void openSettingsPage(@UIEventTopic(value="PROJECT/SETTINGS_PAGE") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        PreferencesRegistry preferencesRegistry = (PreferencesRegistry)ContextInjectionFactory.make(PreferencesRegistry.class, (IEclipseContext)this.eclipseContext);
        String pageId = (String)eventData;
        this.openSettingsDialogToPage(Display.getCurrent().getActiveShell(), preferencesRegistry, pageId);
    }

    private Map<String, List<PreferenceNodeDescription>> getPluginPreferences() {
        Collection extensions = ApplicationManager.getInstance().getExtensionManager().getExtensions("com.katalon.platform.api.extension.pluginPreferencePage");
        List pluginNodes = extensions.stream().map(e -> this.getPreferenceNodeDescription((Extension)e)).filter(node -> node != null).collect(Collectors.toList());
        HashMap<String, List<PreferenceNodeDescription>> pluginPreferences = new HashMap<String, List<PreferenceNodeDescription>>();
        pluginPreferences.put(PARENT_PLUGIN_PREFERENCE_PAGE_ID, pluginNodes);
        return pluginPreferences;
    }

    private PreferenceNodeDescription getPreferenceNodeDescription(Extension e) {
        if (e.getImplementationClass() instanceof PluginPreferencePage) {
            PluginPreferencePage pluginPreferencePage = (PluginPreferencePage)e.getImplementationClass();
            String bundleId = e.getPluginId();
            String nodeId = pluginPreferencePage.getPageId();
            String nodeName = pluginPreferencePage.getName();
            String parentNodeId = PARENT_PLUGIN_PREFERENCE_PAGE_ID;
            return new PreferenceNodeDescriptionImpl(bundleId, nodeId, nodeName, parentNodeId, pluginPreferencePage.getPreferencePageClass().getName());
        }
        return null;
    }

    private void openSettingsDialogToPage(Shell shell, PreferencesRegistry preferencesRegistry, String pageId) {
        PreferenceManager pm = preferencesRegistry.getPreferenceManager("com.kms.katalon.preferences.ProjectSettingPages", this.getPluginPreferences());
        this.hideIOSPageOnNoneMacOS(pm);
        PreferenceDialog dialog = new PreferenceDialog(shell, pm){
            private Composite helpComposite;

            protected TreeViewer createTreeViewer(Composite parent) {
                TreeViewer treeViewer = super.createTreeViewer(parent);
                treeViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
                return treeViewer;
            }

            protected void addListeners(TreeViewer viewer) {
                super.addListeners(viewer);
                this.registerPageChangeListener();
            }

            private void registerPageChangeListener() {
                EventBrokerSingleton.getInstance().getEventBroker().subscribe("SETTINGS/PAGE_CHANGE", (EventHandler)new EventServiceAdapter(){

                    public void handleEvent(Event event) {
                        String pageId = (String)this.getObject(event);
                        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.findNodeMatching(pageId)));
                    }
                });
            }

            protected Point getInitialSize() {
                return new Point(800, 600);
            }

            protected boolean showPage(IPreferenceNode node) {
                boolean success = super.showPage(node);
                if (success) {
                    IPreferencePage shownPage = this.getCurrentPage();
                    this.showHelpButtonForPage(shownPage);
                }
                return success;
            }

            private void showHelpButtonForPage(IPreferencePage page) {
                Control[] helpCompositeChildren = this.helpComposite.getChildren();
                if (helpCompositeChildren.length > 0) {
                    Composite oldHelpButton = (Composite)helpCompositeChildren[0];
                    oldHelpButton.dispose();
                }
                if (page instanceof PreferencePageWithHelp) {
                    PreferencePageWithHelp prefPageWithHelp = (PreferencePageWithHelp)page;
                    if (prefPageWithHelp.hasDocumentation()) {
                        String documentationUrl = prefPageWithHelp.getDocumentationUrl();
                        this.createAndShowHelpButton(this.helpComposite, documentationUrl);
                    } else {
                        this.helpComposite.setVisible(false);
                    }
                } else {
                    this.helpComposite.setVisible(false);
                }
            }

            private void createAndShowHelpButton(Composite helpComposite, String documentationUrl) {
                new HelpCompositeForDialog(helpComposite, documentationUrl){

                    protected GridData createGridData() {
                        return new GridData(131072, 0x1000000, true, false);
                    }

                    protected GridLayout createLayout() {
                        GridLayout layout = new GridLayout();
                        layout.marginHeight = 0;
                        layout.marginBottom = 0;
                        layout.marginWidth = 0;
                        return layout;
                    }
                };
                helpComposite.setVisible(true);
                helpComposite.getParent().layout(true, true);
            }

            protected void createButtonsForButtonBar(Composite parent) {
                ++((GridLayout)parent.getLayout()).numColumns;
                this.helpComposite = new Composite(parent, 0);
                GridLayout glHelp = new GridLayout();
                glHelp.marginWidth = 0;
                glHelp.marginHeight = 0;
                this.helpComposite.setLayout((Layout)glHelp);
                this.helpComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
                super.createButtonsForButtonBar(parent);
            }
        };
        String initialSelectedPage = pageId != null ? pageId : "com.kms.katalon.composer.project.information";
        dialog.setSelectedNode(initialSelectedPage);
        dialog.create();
        dialog.getTreeViewer().setComparator((ViewerComparator)new DefinedOrderedPageComparator());
        dialog.getShell().setText(StringConstants.HAND_PROJ_SETTING);
        dialog.open();
    }

    @Inject
    @Optional
    public void openSettings(@UIEventTopic(value="PROJECT/SETTINGS") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        PreferencesRegistry preferencesRegistry = (PreferencesRegistry)ContextInjectionFactory.make(PreferencesRegistry.class, (IEclipseContext)this.eclipseContext);
        this.execute(Display.getCurrent().getActiveShell(), preferencesRegistry);
    }

    private void hideIOSPageOnNoneMacOS(PreferenceManager pm) {
        if ("macosx".equals(Platform.getOS())) {
            return;
        }
        try {
            IPreferenceNode executionSettings = null;
            IPreferenceNode[] iPreferenceNodeArray = pm.getRootSubNodes();
            int n = iPreferenceNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPreferenceNode node = iPreferenceNodeArray[n2];
                if ("com.kms.katalon.composer.execution.settings".equals(node.getId())) {
                    executionSettings = node;
                    break;
                }
                ++n2;
            }
            if (executionSettings == null) {
                throw new MissingProjectSettingPageException("com.kms.katalon.composer.execution.settings");
            }
            IPreferenceNode defaultExecutionSettings = executionSettings.findSubNode("com.kms.katalon.composer.execution.settings.default");
            if (defaultExecutionSettings == null) {
                throw new MissingProjectSettingPageException("com.kms.katalon.composer.execution.settings.default");
            }
            IPreferenceNode mobileNode = defaultExecutionSettings.findSubNode("com.kms.katalon.composer.execution.settings.default.2");
            if (mobileNode == null) {
                throw new MissingProjectSettingPageException("com.kms.katalon.composer.execution.settings.default.2");
            }
            IPreferenceNode iOSNode = mobileNode.remove("com.kms.katalon.composer.execution.settings.default.2.2");
            if (iOSNode == null) {
                throw new MissingProjectSettingPageException("com.kms.katalon.composer.execution.settings.default.2.2");
            }
        }
        catch (MissingProjectSettingPageException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private final class PreferenceLabelProvider
    extends TypeCheckedStyleCellLabelProvider<PreferenceNode> {
        private PreferenceLabelProvider() {
            super(0);
        }

        protected Class<PreferenceNode> getElementType() {
            return PreferenceNode.class;
        }

        protected Image getImage(PreferenceNode element) {
            return null;
        }

        protected String getText(PreferenceNode element) {
            return element.getLabelText();
        }
    }
}

