/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.ProjectPreferenceConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class RecentProjectHandler {
    @Inject
    EventBroker eventBroker;
    @Inject
    private EPartService partService;

    @Execute
    public void execute(@Optional @Named(value="com.kms.katalon.composer.project.command.openrecentproject.parameters.project") String projectPk) throws IOException {
        if (projectPk != null) {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                this.eventBroker.post("PROJECT/SAVE_SESSION", (Object)projectPk);
            }
            this.eventBroker.post("PROJECT/OPEN", (Object)projectPk);
        }
    }

    @Inject
    @Optional
    private void openLastRecentProject(@UIEventTopic(value="ACTIVATION/CHECKED") Object object) {
        if (ProjectController.getInstance().getCurrentProject() != null) {
            return;
        }
        try {
            List recentProjects = ProjectController.getInstance().getRecentProjects();
            if (recentProjects == null || recentProjects.isEmpty()) {
                return;
            }
            if (RecentProjectHandler.getGeneralStore().getBoolean("general.autoRestorePreviousSession")) {
                ScopedPreferenceStore store;
                String latestOpenedProject;
                MPart explorerPart = this.partService.findPart("com.kms.katalon.composer.part.explorer");
                if (explorerPart != null) {
                    this.partService.activate(explorerPart, true);
                }
                if (StringUtils.isNotEmpty((String)(latestOpenedProject = (store = PreferenceStoreManager.getPreferenceStore(this.getClass())).getString(ProjectPreferenceConstants.LATEST_OPENED_PROJECT)))) {
                    this.eventBroker.send("PROJECT/OPEN_LATEST", (Object)latestOpenedProject);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static ScopedPreferenceStore getGeneralStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
    }
}

