/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;

public class RebuildProjectHandler {
    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !LauncherManager.getInstance().isAnyLauncherRunning();
    }

    @Execute
    public void execute() {
        try {
            Job job = new Job(StringConstants.HAND_REBUILD_PROJ){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(StringConstants.HAND_REBUILDING_PROJ, 10);
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                        ProjectController projectController = ProjectController.getInstance();
                        ProjectEntity currentProject = projectController.getCurrentProject();
                        GroovyUtil.initGroovyProjectClassPath((ProjectEntity)currentProject, (List)projectController.getCustomKeywordPlugins(currentProject), (boolean)false, (IProgressMonitor)progress.newChild(10));
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception exception) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
        catch (Exception exception) {
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_REBUILD_PROJ);
        }
    }
}

