/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.project.constants.ProjectPreferenceConstants;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ProjectSessionHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private UISynchronize sync;

    public static ScopedPreferenceStore getGeneralStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectSessionHandler.getGeneralStore().getBoolean("general.autoRestorePreviousSession");
    }

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("PROJECT/SAVE_SESSION", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    if (!ProjectSessionHandler.this.canExecute()) {
                        return;
                    }
                    String[] expandedEntities = ProjectSessionHandler.this.rememberExpandedTreeEntities();
                    String[] openedEntities = ProjectSessionHandler.this.rememberOpenedEntities();
                    String[] draftEntities = ProjectSessionHandler.this.rememberDraftEntities();
                    ProjectSessionHandler.this.saveSessionEntities(openedEntities, expandedEntities, draftEntities);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        this.eventBroker.subscribe("PROJECT/RESTORE_SESSION", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    if (!ProjectSessionHandler.this.canExecute()) {
                        return;
                    }
                    ProjectSessionHandler.this.restoreExpandedTreeEntities();
                    ProjectSessionHandler.this.restoreOpenedEntities();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    @Inject
    @Execute
    public void execute() {
    }

    private void restoreExpandedTreeEntities() throws Exception {
        Object[] expandedEntities;
        CTreeViewer viewer = this.getTreeViewer(this.getTestExplorerPart());
        if (viewer == null) {
            return;
        }
        viewer.getControl().setRedraw(false);
        LastSessionEntities sessionEntities = this.getSessionEntities();
        Object[] objectArray = expandedEntities = TreeEntityUtil.getExpandedTreeEntitiesFromIds(Arrays.asList(sessionEntities.getExpandedEntities())).toArray();
        int n = expandedEntities.length;
        int n2 = 0;
        while (n2 < n) {
            Object expanded = objectArray[n2];
            if (expanded != null) {
                viewer.setExpandedState(expanded, true);
            }
            ++n2;
        }
        viewer.getControl().setRedraw(true);
    }

    private void restoreOpenedEntities() throws Exception {
        Job job = new Job("Restoring Previous Session"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LastSessionEntities sessionEntities = ProjectSessionHandler.this.getSessionEntities();
                    List treeEntities = TreeEntityUtil.getOpenedTreeEntitiesFromIds(Arrays.asList(sessionEntities.getOpenedEntities()));
                    String[] draftEntities = sessionEntities.getDraftEntities();
                    if (draftEntities == null) {
                        draftEntities = new String[]{};
                    }
                    monitor.beginTask("Restoring Previous Session...", treeEntities.size() + draftEntities.length);
                    for (ITreeEntity entity : treeEntities) {
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (entity != null && entity.getObject() != null) {
                            ProjectSessionHandler.this.sync.syncExec(() -> {
                                try {
                                    ProjectSessionHandler.this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", entity.getObject());
                                }
                                catch (Exception ex) {
                                    LoggerSingleton.logError((Throwable)ex);
                                }
                            });
                        }
                        monitor.worked(1);
                    }
                    String[] stringArray = draftEntities;
                    int n = draftEntities.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String partId = stringArray[n2];
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        ProjectSessionHandler.this.eventBroker.post("EXPLORER/OPEN_ITEM_BY_PART_ID", (Object)partId);
                        monitor.worked(1);
                        ++n2;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    ProjectSessionHandler.this.eventBroker.post("PROJECT/RESTORE_SESSION_COMPLETED", null);
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private String[] rememberExpandedTreeEntities() throws Exception {
        CTreeViewer viewer = this.getTreeViewer(this.getTestExplorerPart());
        if (viewer == null) {
            return new String[0];
        }
        List expandedTreeEntityIds = TreeEntityUtil.getTreeEntityIds((Object[])viewer.getExpandedElements());
        return expandedTreeEntityIds.toArray(new String[0]);
    }

    private String[] rememberOpenedEntities() throws Exception {
        List openedEntityIds = EntityPartUtil.getOpenedEntityIds((Collection)this.partService.getParts());
        return openedEntityIds.toArray(new String[0]);
    }

    private String[] rememberDraftEntities() {
        return EntityPartUtil.getDraftEntities((Collection)this.partService.getParts());
    }

    private MPart getTestExplorerPart() {
        return (MPart)this.modelService.find("com.kms.katalon.composer.part.explorer", (MUIElement)this.application);
    }

    private CTreeViewer getTreeViewer(MPart testExplorerPart) {
        Object treeViewer = testExplorerPart.getTransientData().get(CTreeViewer.class.getSimpleName());
        if (treeViewer instanceof CTreeViewer) {
            return (CTreeViewer)treeViewer;
        }
        return null;
    }

    private LastSessionEntities getSessionEntities() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(this.getClass());
        String lastSessionEntities = store.getString(ProjectPreferenceConstants.LATEST_SESSION_ENTITIES);
        if (StringUtils.isEmpty((String)lastSessionEntities)) {
            return LastSessionEntities.empty();
        }
        return (LastSessionEntities)JsonUtil.fromJson((String)lastSessionEntities, LastSessionEntities.class);
    }

    private void saveSessionEntities(String[] openedEntities, String[] expandedEntities, String[] draftEntities) throws IOException {
        LastSessionEntities sessionEntities = new LastSessionEntities();
        sessionEntities.openedEntities = openedEntities;
        sessionEntities.expandedEntities = expandedEntities;
        sessionEntities.draftEntities = draftEntities;
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(this.getClass());
        store.setValue(ProjectPreferenceConstants.LATEST_SESSION_ENTITIES, JsonUtil.toJson((Object)sessionEntities));
        ((IPersistentPreferenceStore)store).save();
    }

    private static class LastSessionEntities {
        private String[] openedEntities;
        private String[] expandedEntities;
        private String[] draftEntities;

        private LastSessionEntities() {
        }

        public static LastSessionEntities empty() {
            LastSessionEntities sessionEntities = new LastSessionEntities();
            sessionEntities.openedEntities = new String[0];
            sessionEntities.expandedEntities = new String[0];
            sessionEntities.draftEntities = new String[0];
            return sessionEntities;
        }

        public String[] getOpenedEntities() {
            if (this.openedEntities == null) {
                this.openedEntities = new String[0];
            }
            return this.openedEntities;
        }

        public String[] getExpandedEntities() {
            if (this.expandedEntities == null) {
                this.expandedEntities = new String[0];
            }
            return this.expandedEntities;
        }

        public String[] getDraftEntities() {
            return this.draftEntities;
        }
    }
}

