/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.dialog.WalkthroughDialog;
import com.kms.katalon.composer.project.dialog.WalkthroughItem;
import com.kms.katalon.composer.project.handlers.CloseProjectHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpenProjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    @Inject
    private UISynchronize sync;

    @Execute
    public void execute(Shell shell) {
        try {
            File projectDirectory;
            DirectoryDialog directoryDialog = new DirectoryDialog(shell);
            directoryDialog.open();
            if (directoryDialog.getFilterPath() != null && (projectDirectory = new File(directoryDialog.getFilterPath())) != null && projectDirectory.exists() && projectDirectory.isDirectory()) {
                File projectFile = OpenProjectHandler.getProjectFile(projectDirectory);
                if (projectFile != null) {
                    if (!CloseProjectHandler.closeCurrentProject(this.partService, this.modelService, this.application, this.eventBroker)) {
                        return;
                    }
                    this.openProjectEventHandler(shell, projectFile.getAbsolutePath());
                } else {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_NO_PROJ_FOUND);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_PROJ);
        }
    }

    public static File getProjectFile(File projectDirectory) {
        File[] fileArray = projectDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if ((String.valueOf('.') + FilenameUtils.getExtension((String)file.getAbsolutePath())).equals(ProjectEntity.getProjectFileExtension())) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static List<File> getProjectFiles(File projectDirectory) {
        ArrayList<File> childProjectFiles = new ArrayList<File>();
        File[] fileArray = projectDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File projectFile;
            File file = fileArray[n2];
            if (file.isDirectory() && (projectFile = OpenProjectHandler.getProjectFile(file)) != null) {
                childProjectFiles.add(projectFile);
            }
            ++n2;
        }
        return childProjectFiles;
    }

    @Inject
    @Optional
    private void openProjectEventHandler(@Named(value="activeShell") Shell shell, @UIEventTopic(value="PROJECT/OPEN") String projectPk) throws InvocationTargetException, InterruptedException {
        OpenProjectHandler.doOpenProject(shell, projectPk, this.sync, this.eventBroker, this.partService, this.modelService, this.application);
    }

    @Inject
    @Optional
    private void restoreOpenProjectEventHandler(@Named(value="activeShell") Shell shell, @UIEventTopic(value="PROJECT/OPEN_LATEST") String projectPk) throws InvocationTargetException, InterruptedException {
        OpenProjectHandler.doOpenProject(shell, projectPk, this.sync, this.eventBroker, this.partService, this.modelService, this.application);
        this.eventBroker.post("PROJECT/RESTORE_SESSION", null);
    }

    public static void doOpenProject(Shell shell, final String projectPk, final UISynchronize syncService, final IEventBroker eventBrokerService, EPartService partService, final EModelService modelService, final MApplication application) throws InvocationTargetException, InterruptedException {
        ScopedPreferenceStore prefStore;
        boolean shouldShowWalkthroughDialog;
        if (!CloseProjectHandler.closeCurrentProject(partService, modelService, application, eventBrokerService)) {
            return;
        }
        new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(StringConstants.HAND_OPENING_PROJ, 10);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                    monitor.worked(1);
                    monitor.subTask(StringConstants.HAND_LOADING_PROJ);
                    final ProjectEntity project = ProjectController.getInstance().openProjectForUI(projectPk, (IProgressMonitor)progress.newChild(7, 1));
                    monitor.subTask(StringConstants.HAND_REFRESHING_EXPLORER);
                    syncService.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (project != null) {
                                    OpenProjectHandler.updateProjectTitle(project, modelService, application);
                                    Trackings.trackOpenProject((ProjectEntity)project);
                                }
                                eventBrokerService.post("EXPLORER/RELOAD_INPUT", (Object)TreeEntityUtil.getAllTreeEntity((ProjectEntity)project));
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                    eventBrokerService.post("GLOBAL_VARIABLE/REFRESH", null);
                    monitor.worked(1);
                    LauncherManager.refresh();
                    eventBrokerService.post("JOB/REFRESH", null);
                    eventBrokerService.post("CONSOLE_LOG/RESET", null);
                    monitor.worked(1);
                    TimeUnit.SECONDS.sleep(1L);
                    eventBrokerService.post("PROJECT/OPENED", null);
                    TimeUnit.SECONDS.sleep(1L);
                    return;
                }
                catch (Exception e) {
                    syncService.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_PROJ, (String)e.getClass().getSimpleName());
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                    return;
                }
                finally {
                    monitor.done();
                }
            }
        });
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null && project.getType().equals((Object)ProjectType.WEBUI) && (shouldShowWalkthroughDialog = (prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon")).getBoolean("general.showWalkthroughDialog"))) {
            Display.getDefault().asyncExec(() -> {
                WalkthroughDialog walkthroughDialog = new WalkthroughDialog("WebUiWalkthroughDialog", "Walkthrough for beginners", null, OpenProjectHandler.getItems(), "https://docs.katalon.com/katalon-studio/docs/index.html", "I am an experienced user");
                walkthroughDialog.open();
                if (walkthroughDialog.isIgnore()) {
                    prefStore.setValue("general.showWalkthroughDialog", false);
                }
            });
        }
    }

    public static void updateProjectTitle(ProjectEntity projectEntity, EModelService modelService, MApplication app) {
        MWindow win = (MWindow)modelService.find("com.kms.katalon.composer.window.main", (MUIElement)app);
        if (win != null) {
            win.setLabel(String.valueOf(win.getLabel().split(" - ")[0]) + " - " + projectEntity.getName() + " - [Location: " + projectEntity.getFolderLocation() + "]");
            win.updateLocalization();
        }
    }

    private static List<WalkthroughItem> getItems() {
        ArrayList<WalkthroughItem> items = new ArrayList<WalkthroughItem>();
        WalkthroughItem createTestCase = new WalkthroughItem("Create a test case", "TESTCASE/OPEN");
        ArrayList<WalkthroughItem.SecondaryLinkItem> createTestCaseLinks = new ArrayList<WalkthroughItem.SecondaryLinkItem>();
        createTestCaseLinks.add(new WalkthroughItem.SecondaryLinkItem("How to create test cases using script mode", "https://docs.katalon.com/katalon-studio/tutorials/create_test_case_using_record_playback.html"));
        createTestCaseLinks.add(new WalkthroughItem.SecondaryLinkItem("How to create test cases using Record & Playback", "https://docs.katalon.com/katalon-studio/tutorials/create_test_case_using_script_mode.html"));
        createTestCase.setSecondaryLinkItems(createTestCaseLinks);
        items.add(createTestCase);
        WalkthroughItem executeTestCase = new WalkthroughItem("Execute the test case", "EXECUTE/EXECUTE_TEST_CASE");
        ArrayList<WalkthroughItem.SecondaryLinkItem> executeTestCaseLinks = new ArrayList<WalkthroughItem.SecondaryLinkItem>();
        executeTestCaseLinks.add(new WalkthroughItem.SecondaryLinkItem("How to execute test cases", "https://docs.katalon.com/katalon-studio/docs/execute-a-test-case-or-a-test-suite.html"));
        executeTestCase.setSecondaryLinkItems(executeTestCaseLinks);
        items.add(executeTestCase);
        WalkthroughItem createTestSuite = new WalkthroughItem("Plan the test case to a test suite", "TESTSUITE/OPEN");
        ArrayList<WalkthroughItem.SecondaryLinkItem> createTestSuiteLinks = new ArrayList<WalkthroughItem.SecondaryLinkItem>();
        createTestSuiteLinks.add(new WalkthroughItem.SecondaryLinkItem("How to add test suites", "https://docs.katalon.com/katalon-studio/docs/test-suite.html"));
        createTestSuiteLinks.add(new WalkthroughItem.SecondaryLinkItem("How to design test suites", "https://docs.katalon.com/katalon-studio/docs/design-a-test-suite.html"));
        createTestSuite.setSecondaryLinkItems(createTestSuiteLinks);
        items.add(createTestSuite);
        WalkthroughItem executeTestSuite = new WalkthroughItem("Execute the test suite", "EXECUTE/EXECUTE_TEST_SUITE");
        ArrayList<WalkthroughItem.SecondaryLinkItem> executeTestSuiteLinks = new ArrayList<WalkthroughItem.SecondaryLinkItem>();
        executeTestSuiteLinks.add(new WalkthroughItem.SecondaryLinkItem("How to execute test suites", "https://docs.katalon.com/katalon-studio/docs/execute-a-test-case-or-a-test-suite.html"));
        executeTestSuiteLinks.add(new WalkthroughItem.SecondaryLinkItem("How to execute test suites in console mode", "https://docs.katalon.com/katalon-studio/docs/console-mode-execution.html#katalon-command-line-options"));
        executeTestSuite.setSecondaryLinkItems(executeTestSuiteLinks);
        items.add(executeTestSuite);
        return items;
    }
}

