/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CloseProjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("PROJECT/CLOSE", new EventHandler(){

            public void handleEvent(Event event) {
                CloseProjectHandler.this.eventBroker.send("PROJECT/SAVE_SESSION", null);
                CloseProjectHandler.this.execute(Display.getCurrent().getActiveShell());
            }
        });
    }

    public static boolean closeCurrentProject(EPartService partService, EModelService modelService, MApplication application, IEventBroker eventBroker) {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null) {
            if (partService.saveAll(true)) {
                CloseProjectHandler.closeProject(partService, eventBroker, project);
                return true;
            }
            return false;
        }
        return true;
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !LauncherManager.getInstance().isAnyLauncherRunning();
    }

    @Execute
    public void execute(Shell shell) {
        if (this.partService.saveAll(true)) {
            CloseProjectHandler.closeProject(this.partService, this.eventBroker, ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/RELOAD_INPUT", Collections.emptyList());
            this.eventBroker.send("GLOBAL_VARIABLE/REFRESH", null);
            this.eventBroker.post("CONSOLE_LOG/RESET", null);
            MPartStack consolePartStack = (MPartStack)this.modelService.find("com.kms.katalon.partstack.console", (MUIElement)this.application);
            consolePartStack.getTags().add("Minimized");
            MPartStack rightPartStack = (MPartStack)this.modelService.find("com.kms.katalon.partstack.outline", (MUIElement)this.application);
            rightPartStack.getTags().add("Minimized");
            this.partService.activate((MPart)this.modelService.find("com.kms.katalon.part.welcome", (MUIElement)this.application));
            MWindow win = (MWindow)this.modelService.find("com.kms.katalon.composer.window.main", (MUIElement)this.application);
            win.setLabel(GlobalStringConstants.APP_NAME);
        }
    }

    private static void closeProject(EPartService partService, IEventBroker eventBroker, ProjectEntity project) {
        LauncherManager.getInstance().removeAllTerminated();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false);
        for (MPart p : partService.getParts()) {
            if ((!p.getElementId().startsWith("com.kms.katalon.composer.content.") || !p.getElementId().endsWith(")")) && !"org.eclipse.e4.ui.compatibility.editor".equals(p.getElementId())) continue;
            partService.hidePart(p, true);
        }
        try {
            if (project != null) {
                ProjectController.getInstance().closeProject(project.getId(), null);
                eventBroker.send("PROJECT/CLOSED", (Object)project.getId());
            }
        }
        catch (Exception exception) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_UNABLE_TO_CLOSE_CURRENT_PROJ);
        }
    }
}

