/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.dialog;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.project.dialog.WalkthroughItem;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WalkthroughDialog
extends Dialog {
    private List<WalkthroughItem> walkthroughItems;
    private String learnMoreLink = "";
    private int uncheckedItem;
    private String ignoredCriteria = "";
    private boolean isIgnored = false;
    private String trackingId = "";
    private String dialogTitle = "";

    public WalkthroughDialog(String trackingId, String dialogTitle, Shell parentShell, List<WalkthroughItem> items, String learnMoreLink, String ignoreCriteria) {
        super(parentShell);
        this.walkthroughItems = items;
        this.learnMoreLink = learnMoreLink;
        this.uncheckedItem = this.walkthroughItems.size();
        this.ignoredCriteria = ignoreCriteria;
        this.trackingId = trackingId;
        this.dialogTitle = dialogTitle;
    }

    public List<WalkthroughItem> getWalkthroughItems() {
        return this.walkthroughItems;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(18528);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gdContainer = new GridData(4, 4, true, true);
        gdContainer.heightHint = 400;
        gdContainer.widthHint = 400;
        container.setLayoutData((Object)gdContainer);
        GridLayout glContainer = new GridLayout(1, false);
        container.setLayout((Layout)glContainer);
        final Label lblInfo = new Label(container, 0);
        lblInfo.setText("Let's go through these following Katalon Studio functions:");
        final Link lblXLeftToGo = new Link(container, 0);
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)lblXLeftToGo.getFont());
        descriptor = descriptor.setStyle(1);
        lblXLeftToGo.setFont(descriptor.createFont((Device)lblXLeftToGo.getDisplay()));
        lblXLeftToGo.setText(String.valueOf(this.uncheckedItem) + " more to go");
        if (this.walkthroughItems != null && !this.walkthroughItems.isEmpty()) {
            for (WalkthroughItem item : this.walkthroughItems) {
                Composite walkthroughItemContainer = new Composite(container, 0);
                GridData gdWalkthroughItemContainer = new GridData(4, 4, false, false);
                GridLayout glWalkthroughItemContainer = new GridLayout(1, false);
                walkthroughItemContainer.setLayout((Layout)glWalkthroughItemContainer);
                walkthroughItemContainer.setLayoutData((Object)gdWalkthroughItemContainer);
                final CLabel checkBox = new CLabel(walkthroughItemContainer, 0);
                checkBox.setText(item.getPrimaryInstruction());
                checkBox.setImage(ImageManager.getImage((String)"error_16_grey.png"));
                EventBrokerSingleton.getInstance().getEventBroker().subscribe(item.getRegisteredEvent(), new EventHandler(){

                    public void handleEvent(Event event) {
                        WalkthroughDialog.this.decreaseUncheckedItemCount();
                        UISynchronizeService.asyncExec(() -> {
                            checkBox.setFocus();
                            checkBox.setImage(ImageManager.getImage((String)"ok_16.png"));
                            if (WalkthroughDialog.this.getUncheckedItemCount() == 0) {
                                lblInfo.setText("Congratulations! You have gone through all the basics.");
                                lblXLeftToGo.setText("<a> Learn more </a>");
                                lblXLeftToGo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        Program.launch((String)WalkthroughDialog.this.learnMoreLink);
                                    }
                                });
                            } else {
                                int currentCount = WalkthroughDialog.this.getUncheckedItemCount();
                                lblXLeftToGo.setText(String.valueOf(currentCount) + " more to go");
                            }
                        });
                    }
                });
                Composite linkContainer = new Composite(walkthroughItemContainer, 0);
                GridData gdLinkContainer = new GridData(4, 4, true, true);
                linkContainer.setLayoutData((Object)gdLinkContainer);
                GridLayout glLinkContainer = new GridLayout(2, false);
                linkContainer.setLayout((Layout)glLinkContainer);
                for (final WalkthroughItem.SecondaryLinkItem linkItem : item.getSecondaryLinkItems()) {
                    new Label(linkContainer, 0).setText("\t");
                    Link thisLink = new Link(linkContainer, 0);
                    thisLink.setText("<a>" + linkItem.getText() + "</a>");
                    thisLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Program.launch((String)linkItem.getLink());
                            Trackings.trackClickWalkthroughDialogLink((String)WalkthroughDialog.this.trackingId, (String)linkItem.getText(), (String)linkItem.getLink());
                        }
                    });
                }
            }
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.ignoredCriteria, false);
        this.getButton(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WalkthroughDialog.this.isIgnored = true;
                Trackings.trackClickWalkthroughIgnoreButton((String)WalkthroughDialog.this.trackingId);
            }
        });
    }

    public boolean isIgnore() {
        return this.isIgnored;
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(Display.getCurrent().getClientArea().width, 0);
    }

    private void decreaseUncheckedItemCount() {
        --this.uncheckedItem;
    }

    private int getUncheckedItemCount() {
        return this.uncheckedItem;
    }
}

