/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.sample.SampleLocalProject;
import com.kms.katalon.composer.project.sample.SampleProject;
import com.kms.katalon.composer.project.sample.SampleProjectType;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectProvider;
import com.kms.katalon.composer.project.template.SampleProjectProvider;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.MarshalException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewProjectDialog
extends TitleAreaDialog {
    private static final String DEFAULT_PROJECT_LOCATION = String.valueOf(System.getProperty("user.home")) + File.separator + StringConstants.APP_NAME;
    private static final int PROJECT_DESC_TEXT_LEFT_MARGIN = 5;
    private static final int PROJECT_DESC_DISPLAY_LINE_NUMBER = 4;
    private static final String BLANK_PROJECT = StringConstants.BLANK_PROJECT;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private List<SampleProject> sampleProjects = new ArrayList<SampleProject>();
    private Text txtProjectName;
    private Text txtProjectLocation;
    private StyledText txtProjectDescription;
    private String name;
    private String loc;
    private String desc;
    private ProjectEntity project;
    private SampleProject initialSampleProject;
    private boolean showError;
    private Button btnFolderChooser;
    private String title;
    private Combo cbProjects;
    private Text txtRepoUrl;
    private Button rbWebServiceProjectType;
    private Button rbGenericProjectType;
    private Button rbWebProjectType;
    private Button rbMobileProjectType;
    private boolean okButtonClicked = false;

    public NewProjectDialog(Shell parentShell) {
        this(parentShell, (SampleProject)null);
    }

    public NewProjectDialog(Shell parentShell, SampleProject sampleProject) {
        super(parentShell);
        this.title = StringConstants.VIEW_TITLE_NEW_PROJ;
        this.initialSampleProject = sampleProject;
    }

    public NewProjectDialog(Shell parentShell, ProjectEntity project) {
        super(parentShell);
        this.project = project;
        this.title = StringConstants.VIEW_TITLE_PROJECT_PROPERTIES;
    }

    protected Control createDialogArea(Composite parent) {
        this.initSampleProjects();
        Composite area = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setMessage(StringConstants.VIEW_MSG_PLS_ENTER_PROJ_INFO);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout g = new GridLayout(2, false);
        container.setLayout((Layout)g);
        g.verticalSpacing = 15;
        g.horizontalSpacing = 15;
        g.marginHeight = 15;
        g.marginBottom = 15;
        g.marginLeft = 20;
        g.marginRight = 20;
        Label l = new Label(container, 0);
        l.setText(StringConstants.VIEW_LBL_NAME);
        this.txtProjectName = new Text(container, 2048);
        this.txtProjectName.setLayoutData((Object)new GridData(768));
        Label lblProjectType = new Label(container, 0);
        lblProjectType.setText("Type");
        Composite projectTypeComposite = new Composite(container, 0);
        projectTypeComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        projectTypeComposite.setLayout((Layout)new GridLayout(5, false));
        this.rbWebServiceProjectType = new Button(projectTypeComposite, 16);
        GridData gdWebServiceProjectType = new GridData(4, 4, true, false, 1, 1);
        this.rbWebServiceProjectType.setLayoutData((Object)gdWebServiceProjectType);
        this.rbWebServiceProjectType.setText(StringConstants.VIEW_OPTION_WEB_SERVICE_PROJECT);
        this.rbWebServiceProjectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectDialog.this.populateWebServiceProjects();
            }
        });
        this.rbWebProjectType = new Button(projectTypeComposite, 16);
        GridData WebProjectType = new GridData(4, 4, true, false, 1, 1);
        this.rbWebProjectType.setLayoutData((Object)WebProjectType);
        this.rbWebProjectType.setText(StringConstants.VIEW_OPTION_WEB_PROJECT);
        this.rbWebProjectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectDialog.this.populateWebProjects();
            }
        });
        this.rbMobileProjectType = new Button(projectTypeComposite, 16);
        GridData gdMobileProjectType = new GridData(4, 4, true, false, 1, 1);
        this.rbMobileProjectType.setLayoutData((Object)gdMobileProjectType);
        this.rbMobileProjectType.setText(StringConstants.VIEW_OPTION_MOBILE_PROJECT);
        this.rbMobileProjectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectDialog.this.populateMobileProjects();
            }
        });
        this.rbGenericProjectType = new Button(projectTypeComposite, 16);
        GridData gdGenericProjectType = new GridData(4, 4, true, false, 1, 1);
        this.rbGenericProjectType.setLayoutData((Object)gdGenericProjectType);
        this.rbGenericProjectType.setText(StringConstants.VIEW_OPTION_GENERIC_PROJECT);
        this.rbGenericProjectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectDialog.this.populateGenericProjects();
            }
        });
        new HelpCompositeForDialog(projectTypeComposite, DocumentationMessageConstants.MANAGE_TEST_PROJECT){

            protected GridData createGridData() {
                return new GridData(131072, 0x1000000, true, false);
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginBottom = 0;
                layout.marginWidth = 0;
                return layout;
            }
        };
        Label lblProject = new Label(container, 0);
        lblProject.setText(StringConstants.VIEW_LBL_PROJECT);
        this.cbProjects = new Combo(container, 2056);
        this.cbProjects.setLayoutData((Object)new GridData(768));
        Label lblRepoUrl = new Label(container, 0);
        lblRepoUrl.setText(StringConstants.VIEW_LBL_REPOSITORY_URL);
        this.txtRepoUrl = new Text(container, 2048);
        this.txtRepoUrl.setEditable(false);
        this.txtRepoUrl.setLayoutData((Object)new GridData(768));
        l = new Label(container, 0);
        l.setText(StringConstants.VIEW_LBL_LOCATION);
        this.createFileChooserComposite(container);
        l = new Label(container, 0);
        l.setText(StringConstants.VIEW_LBL_DESCRIPTION);
        this.txtProjectDescription = new StyledText(container, 2626);
        GridData layout = new GridData(1808);
        GC graphicContext = new GC((Drawable)this.txtProjectDescription);
        FontMetrics fm = graphicContext.getFontMetrics();
        layout.heightHint = 4 * fm.getHeight();
        this.txtProjectDescription.setLayoutData((Object)layout);
        graphicContext.dispose();
        this.txtProjectDescription.setLeftMargin(5);
        if (this.project != null) {
            this.txtProjectName.setText(this.project.getName());
            this.txtProjectLocation.setText(this.project.getFolderLocation());
            this.txtProjectDescription.setText(this.project.getDescription());
            this.txtProjectLocation.setEnabled(false);
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        if (this.initialSampleProject != null) {
            if (this.initialSampleProject.getType() == SampleProjectType.WEBUI) {
                this.populateWebProjects();
                this.rbWebProjectType.setSelection(true);
            } else if (this.initialSampleProject.getType() == SampleProjectType.MIXED) {
                this.populateGenericProjects();
                this.rbGenericProjectType.setSelection(true);
            } else if (this.initialSampleProject.getType() == SampleProjectType.MOBILE) {
                this.populateMobileProjects();
                this.rbMobileProjectType.setSelection(true);
            } else if (this.initialSampleProject.getType() == SampleProjectType.WS) {
                this.populateWebServiceProjects();
                this.rbWebServiceProjectType.setSelection(true);
            }
            this.cbProjects.select(this.cbProjects.indexOf(this.initialSampleProject.getName()));
        } else {
            this.populateWebServiceProjects();
            this.rbWebServiceProjectType.setSelection(true);
            this.cbProjects.select(0);
        }
        this.showRepoUrlBySelectedProject();
        this.addControlModifyListeners();
        return area;
    }

    private void initSampleProjects() {
        List<SampleRemoteProject> remoteSamples = SampleRemoteProjectProvider.getCachedProjects();
        if (remoteSamples.size() > 0) {
            this.sampleProjects.addAll(remoteSamples);
        } else {
            List<SampleLocalProject> localSamples = SampleProjectProvider.getInstance().getSampleProjects();
            this.sampleProjects.addAll(localSamples);
        }
    }

    private void populateGenericProjects() {
        this.populateProjects(SampleProjectType.WEBUI, SampleProjectType.MOBILE, SampleProjectType.WS, SampleProjectType.MIXED);
    }

    private void populateMobileProjects() {
        this.populateProjects(SampleProjectType.MOBILE);
    }

    private void populateWebServiceProjects() {
        this.populateProjects(SampleProjectType.WS);
    }

    private void populateWebProjects() {
        this.populateProjects(SampleProjectType.WEBUI, SampleProjectType.MIXED);
    }

    private void populateProjects(SampleProjectType ... sampleProjectTypes) {
        List<SampleProjectType> sampleProjectTypeList = Arrays.asList(sampleProjectTypes);
        this.cbProjects.removeAll();
        this.cbProjects.add(BLANK_PROJECT);
        this.sampleProjects.stream().filter(sample -> sampleProjectTypeList.contains((Object)sample.getType())).forEach(sample -> {
            this.cbProjects.add(sample.getName());
            this.cbProjects.setData(sample.getName(), sample);
        });
        this.cbProjects.select(0);
    }

    private Composite createFileChooserComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout theLayout = new GridLayout(this.project == null ? 2 : 1, false);
        theLayout.marginWidth = 0;
        container.setLayout((Layout)theLayout);
        this.txtProjectLocation = new Text(container, 2048);
        this.txtProjectLocation.setLayoutData((Object)new GridData(768));
        this.txtProjectLocation.setText(DEFAULT_PROJECT_LOCATION);
        if (this.project == null) {
            this.btnFolderChooser = new Button(container, 8);
            this.btnFolderChooser.setText(StringConstants.VIEW_BTN_BROWSE);
        }
        return container;
    }

    private void addControlModifyListeners() {
        this.txtProjectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectDialog.this.checkInput();
            }
        });
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectDialog.this.checkInput();
            }
        });
        if (this.btnFolderChooser == null) {
            return;
        }
        this.btnFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewProjectDialog.this.btnFolderChooser.getShell());
                dialog.setFilterPath(NewProjectDialog.this.getProjectLocationInput());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                NewProjectDialog.this.txtProjectLocation.setText(path);
            }
        });
        this.cbProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectDialog.this.showRepoUrlBySelectedProject();
            }
        });
    }

    private void showRepoUrlBySelectedProject() {
        Object sampleProject;
        this.txtRepoUrl.setText("");
        int selectionIdx = this.cbProjects.getSelectionIndex();
        String selectedProjectName = this.cbProjects.getItem(selectionIdx);
        if (!selectedProjectName.equals(BLANK_PROJECT) && (sampleProject = this.cbProjects.getData(selectedProjectName)) instanceof SampleRemoteProject) {
            this.txtRepoUrl.setText(((SampleRemoteProject)sampleProject).getSourceUrl());
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.showError) {
            super.setErrorMessage(newErrorMessage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.showError = false;
        this.checkInput();
        this.showError = true;
    }

    private boolean validateProjectFolderLocation() {
        String projectLocation = this.getProjectLocationInput();
        if (StringUtils.isBlank((String)projectLocation)) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_CANNOT_BE_BLANK);
            return false;
        }
        Path folderPath = null;
        try {
            folderPath = Paths.get(projectLocation, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_INVALID);
            return false;
        }
        File folderLocation = folderPath.toFile();
        if (!folderLocation.exists()) {
            return true;
        }
        if (!folderLocation.canRead()) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_NOT_READABLE);
            return false;
        }
        if (!folderLocation.canWrite()) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_NOT_WRITEABLE);
            return false;
        }
        try {
            String katalonFolderAbsolutePath = new File(Platform.getInstallLocation().getURL().getFile()).getAbsolutePath();
            String locFileAbsolutePath = new File(projectLocation).getAbsolutePath();
            if (locFileAbsolutePath.startsWith(katalonFolderAbsolutePath)) {
                this.setErrorMessage(StringConstants.CANNOT_CREATE_PROJECT_IN_KATALON_FOLDER);
                return false;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private String getProjectLocationInput() {
        if (this.txtProjectLocation == null || StringUtils.isBlank((String)this.txtProjectLocation.getText())) {
            return "";
        }
        String projectLocation = this.txtProjectLocation.getText().trim();
        if (!projectLocation.contains(File.separator)) {
            projectLocation = String.valueOf(DEFAULT_PROJECT_LOCATION) + File.separator + projectLocation;
        }
        return projectLocation;
    }

    private boolean validateProjectName() {
        if (StringUtils.isBlank((String)this.txtProjectName.getText())) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_NAME_CANNOT_BE_BLANK);
            return false;
        }
        return true;
    }

    private boolean validateProjectNameDuplication() {
        String projectLocation = this.getProjectLocationInput();
        String projectName = this.txtProjectName.getText().trim();
        try {
            if (!ProjectController.getInstance().validateNewProjectName(projectLocation, projectName)) {
                this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_NAME_EXISTED_IN_LOC);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    private void checkInput() {
        if (this.okButtonClicked) {
            return;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(this.validateProjectFolderLocation() && this.validateProjectName() && this.validateProjectNameDuplication());
    }

    protected void okPressed() {
        this.okButtonClicked = true;
        this.name = this.txtProjectName.getText();
        this.loc = this.getProjectLocationInput();
        this.desc = this.txtProjectDescription.getText();
        int selectionIdx = this.cbProjects.getSelectionIndex();
        String selectedProjectName = this.cbProjects.getItem(selectionIdx);
        if (!selectedProjectName.equals(BLANK_PROJECT)) {
            Object selectedSampleProject = this.cbProjects.getData(selectedProjectName);
            if (selectedSampleProject instanceof SampleRemoteProject) {
                this.handleCreatingSampleRemoteProject((SampleRemoteProject)selectedSampleProject);
            } else if (selectedSampleProject instanceof SampleLocalProject) {
                this.handleCreatingSampleBuiltInProject((SampleLocalProject)selectedSampleProject);
            }
        } else {
            this.handleCreatingBlankProject();
        }
        super.okPressed();
    }

    private void handleCreatingSampleRemoteProject(SampleRemoteProject sampleRemoteProject) {
        String projectName = this.getProjectName();
        String projectLocation = this.getProjectLocation();
        String projectDescription = this.getProjectDescription();
        ProjectType projectType = this.getSelectedProjectType();
        ProjectEntity projectEntity = new ProjectEntity();
        projectEntity.setName(projectName);
        projectEntity.setFolderLocation(projectLocation);
        projectEntity.setDescription(projectDescription);
        projectEntity.setType(projectType);
        EventBrokerSingleton.getInstance().getEventBroker().post("GIT/CLONE_REMOTE_PROJECT", (Object)new Object[]{sampleRemoteProject, projectEntity, false});
    }

    private void handleCreatingSampleBuiltInProject(SampleLocalProject sampleBuiltInProject) {
        try {
            String projectName = this.getProjectName();
            String projectParentLocation = this.getProjectLocation();
            String projectDescription = this.getProjectDescription();
            ProjectType projectType = this.getSelectedProjectType();
            String projectLocation = new File(projectParentLocation, projectName).getAbsolutePath();
            SampleProjectProvider.getInstance().extractSampleWebUIProject(sampleBuiltInProject, projectLocation);
            FileUtils.forceDelete((File)ProjectController.getInstance().getProjectFile(projectLocation));
            ProjectEntity newProject = ProjectController.getInstance().newProjectEntity(projectName, projectDescription, projectParentLocation, true);
            if (newProject == null) {
                return;
            }
            this.updateProjectType(newProject, projectType);
            this.eventBroker.send("PROJECT/CREATED", (Object)newProject);
            Trackings.trackCreatingSampleProject((String)sampleBuiltInProject.getName(), (String)newProject.getUUID(), (ProjectType)projectType);
            this.eventBroker.send("PROJECT/OPEN", (Object)newProject.getId());
            TimeUnit.SECONDS.sleep(1L);
            this.eventBroker.post("API/OPEN_QUICK_START_DIALOG", (Object)projectType);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void handleCreatingBlankProject() {
        try {
            String projectName = this.getProjectName();
            String projectLocation = this.getProjectLocation();
            String projectDescription = this.getProjectDescription();
            ProjectType projectType = this.getSelectedProjectType();
            ProjectEntity newProject = this.createNewProject(projectName, projectLocation, projectDescription);
            if (newProject == null) {
                return;
            }
            this.updateProjectType(newProject, projectType);
            this.eventBroker.send("PROJECT/CREATED", (Object)newProject);
            Trackings.trackCreatingProject((String)newProject.getUUID(), (ProjectType)projectType);
            this.eventBroker.send("PROJECT/OPEN", (Object)newProject.getId());
            TimeUnit.SECONDS.sleep(1L);
            if (this.getSelectedProjectType() != ProjectType.GENERIC) {
                this.eventBroker.post("API/OPEN_QUICK_START_DIALOG", (Object)projectType);
            }
        }
        catch (FilePathTooLongException ex) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)ex.getMessage());
        }
        catch (Exception ex) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)ex);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_NEW_PROJ);
        }
    }

    private ProjectEntity createNewProject(String projectName, String projectLocation, String projectDescription) throws Exception {
        try {
            ProjectEntity newProject = ProjectController.getInstance().addNewProject(projectName, projectDescription, projectLocation);
            return newProject;
        }
        catch (MarshalException ex) {
            if (!(ex.getLinkedException() instanceof FileNotFoundException)) {
                throw ex;
            }
            LoggerSingleton.getInstance().getLogger().error((Throwable)ex);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_NEW_PROJ_LOCATION_INVALID);
            return null;
        }
    }

    private void updateProjectType(ProjectEntity project, ProjectType type) throws Exception {
        project.setType(type);
        ProjectController.getInstance().updateProject(project);
    }

    private ProjectType getSelectedProjectType() {
        if (this.rbWebServiceProjectType.getSelection()) {
            return ProjectType.WEBSERVICE;
        }
        if (this.rbWebProjectType.getSelection()) {
            return ProjectType.WEBUI;
        }
        if (this.rbMobileProjectType.getSelection()) {
            return ProjectType.MOBILE;
        }
        return ProjectType.GENERIC;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(this.convertHorizontalDLUsToPixels(350), -1, true);
    }

    protected boolean isResizable() {
        return true;
    }

    public String getProjectName() {
        return this.name;
    }

    public String getProjectLocation() {
        return this.loc;
    }

    public String getProjectDescription() {
        return this.desc;
    }
}

