/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.kobiton.preferences;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.preferences.ComboFieldEditor;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerIntegrationKobitonMessageConstants;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerKobitonStringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.entity.KobitonLoginInfo;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class KobitonPreferencesPage
extends FieldEditorPreferencePageWithHelp {
    private static final char PASSWORD_ECHO_CHAR = '*';
    private ComboFieldEditor apiKeyComboEditor;
    private Button connectButton;
    private StringFieldEditor passwordFieldEditor;
    private StringFieldEditor userNameEditor;
    private BooleanFieldEditor enableKobitonIntegration;
    private Composite composite;
    private Group authenticateGroup;
    private StringFieldEditor serverEditor;
    private Link statusLabel;
    private String token;
    private Composite serverAndApiKeyComposite;

    public KobitonPreferencesPage() {
        this.setPreferenceStore((IPreferenceStore)PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.integration.kobiton"));
    }

    protected Control createContents(Composite parent) {
        this.composite = KobitonPreferencesPage.createComposite(parent, 2, 1, 768);
        this.enableKobitonIntegration = new BooleanFieldEditor("kobiton.integration.enable", ComposerIntegrationKobitonMessageConstants.LBL_ENABLE_KOBITON_INTEGRATION, this.composite);
        this.addField((FieldEditor)this.enableKobitonIntegration);
        this.authenticateGroup = KobitonPreferencesPage.createGroup(this.composite, ComposerIntegrationKobitonMessageConstants.LBL_AUTHENTICATE_GROUP, 2, 2, 768);
        this.userNameEditor = new StringFieldEditor("kobiton.authentication.username", ComposerIntegrationKobitonMessageConstants.LBL_USERNAME, (Composite)this.authenticateGroup);
        this.addField((FieldEditor)this.userNameEditor);
        this.passwordFieldEditor = new StringFieldEditor("kobiton.authentication.password", ComposerIntegrationKobitonMessageConstants.LBL_PASSWORD, (Composite)this.authenticateGroup);
        this.passwordFieldEditor.getTextControl((Composite)this.authenticateGroup).setEchoChar('*');
        this.addField((FieldEditor)this.passwordFieldEditor);
        Composite connectComposite = KobitonPreferencesPage.createComposite(this.composite, 2, 2, 768);
        this.connectButton = new Button(connectComposite, 0);
        this.connectButton.setLayoutData((Object)new GridData(16384, 16384, false, false, 1, 1));
        this.connectButton.setText(ComposerIntegrationKobitonMessageConstants.BTN_CONNECT);
        this.statusLabel = new Link(connectComposite, 0);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusLabel.setText("");
        this.serverAndApiKeyComposite = KobitonPreferencesPage.createComposite(this.composite, 2, 1, 768);
        this.serverEditor = new StringFieldEditor("kobiton.server.endpoint", ComposerIntegrationKobitonMessageConstants.LBL_SERVER_URL, this.serverAndApiKeyComposite);
        this.serverEditor.getTextControl(this.serverAndApiKeyComposite).setEditable(false);
        this.addField((FieldEditor)this.serverEditor);
        this.apiKeyComboEditor = new ComboFieldEditor("kobiton.apiKey", ComposerIntegrationKobitonMessageConstants.LBL_API_KEYS, (String[][])new String[0][], this.serverAndApiKeyComposite);
        this.addField((FieldEditor)this.apiKeyComboEditor);
        this.addListeners();
        this.initialize();
        this.checkState();
        return this.composite;
    }

    protected void initialize() {
        super.initialize();
        this.changeEnabledState();
        this.initKeyComboState();
    }

    private void initKeyComboState() {
        if (this.apiKeyComboEditor.isNamesAndValuesEmpty()) {
            String key = this.getPreferenceStore().getString("kobiton.apiKey");
            this.apiKeyComboEditor.changeNamesAndValues((String[][])new String[][]{{key, key}});
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.handleFieldEditorValueChanged(event);
        }
        super.propertyChange(event);
    }

    private void handleFieldEditorValueChanged(PropertyChangeEvent event) {
        if (event.getSource() == this.enableKobitonIntegration) {
            this.changeEnabledState();
        }
    }

    protected void performDefaults() {
        this.apiKeyComboEditor.changeNamesAndValues((String[][])new String[][]{{"", ""}});
        super.performDefaults();
        this.getPreferenceStore().setToDefault("kobiton.authentication.token");
        this.changeEnabledState();
    }

    private void setToken(String token) {
        this.token = token;
    }

    public boolean performOk() {
        boolean performOk = super.performOk();
        if (performOk && this.token != null) {
            this.getPreferenceStore().setValue("kobiton.authentication.token", this.token);
        }
        return performOk;
    }

    private void addListeners() {
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<KobitonApiKey> apiKeys = this.getApiKeys(KobitonPreferencesPage.this.userNameEditor.getStringValue(), KobitonPreferencesPage.this.passwordFieldEditor.getStringValue());
                if (apiKeys == null) {
                    return;
                }
                KobitonPreferencesPage.this.apiKeyComboEditor.changeNamesAndValues(this.getKeyValueArrayFromApiKeyList(apiKeys));
                if (apiKeys.isEmpty()) {
                    KobitonPreferencesPage.this.statusLabel.setText(String.valueOf(ComposerKobitonStringConstants.WARN) + ": " + ComposerIntegrationKobitonMessageConstants.KobitonPreferencesPage_WARN_MSG_NO_API_KEY);
                    KobitonPreferencesPage.this.statusLabel.setForeground(Display.getDefault().getSystemColor(8));
                }
                KobitonPreferencesPage.this.checkState();
            }

            private List<KobitonApiKey> getApiKeys(final String userName, final String password) {
                final ArrayList<KobitonApiKey> apiKeys = new ArrayList<KobitonApiKey>();
                try {
                    new ProgressMonitorDialog(KobitonPreferencesPage.this.getShell()).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                try {
                                    monitor.beginTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_RETRIEVING_KEYS, 2);
                                    monitor.subTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER);
                                    final KobitonLoginInfo loginInfo = KobitonApiProvider.login((String)userName, (String)password);
                                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            KobitonPreferencesPage.this.userNameEditor.setStringValue(loginInfo.getUser().getUsername());
                                        }
                                    });
                                    monitor.worked(1);
                                    monitor.subTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_GETTING_KEYS);
                                    apiKeys.addAll(KobitonApiProvider.getApiKeyList((String)loginInfo.getToken()));
                                    monitor.worked(1);
                                    KobitonPreferencesPage.this.setToken(loginInfo.getToken());
                                }
                                catch (KobitonApiException | IOException | URISyntaxException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                    KobitonPreferencesPage.this.statusLabel.setText(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_SUCCESSFULLY);
                    KobitonPreferencesPage.this.statusLabel.setForeground(Display.getDefault().getSystemColor(6));
                    return apiKeys;
                }
                catch (InvocationTargetException exception) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof KobitonApiException) {
                        KobitonPreferencesPage.this.statusLabel.setText(String.valueOf(ComposerKobitonStringConstants.ERROR) + ": " + cause.getMessage());
                        KobitonPreferencesPage.this.statusLabel.setForeground(Display.getDefault().getSystemColor(3));
                    } else {
                        LoggerSingleton.logError((Throwable)cause);
                    }
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }

            private String[][] getKeyValueArrayFromApiKeyList(List<KobitonApiKey> apiKeys) {
                String[][] apiKeysAndValues = new String[apiKeys.size()][2];
                int index = 0;
                while (index < apiKeys.size()) {
                    KobitonApiKey apiKey = apiKeys.get(index);
                    String key = apiKey.getKey();
                    String[] apiKeyAndValue = apiKeysAndValues[index];
                    apiKeyAndValue[0] = key;
                    apiKeyAndValue[1] = key;
                    ++index;
                }
                return apiKeysAndValues;
            }
        });
        this.statusLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Program.launch((String)e.text);
                }
                catch (IllegalArgumentException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
    }

    private void changeEnabledState() {
        boolean isKobitonIntegrated = this.enableKobitonIntegration.getBooleanValue();
        this.connectButton.setEnabled(isKobitonIntegrated);
        this.passwordFieldEditor.setEnabled(isKobitonIntegrated, (Composite)this.authenticateGroup);
        this.userNameEditor.setEnabled(isKobitonIntegrated, (Composite)this.authenticateGroup);
        this.serverEditor.setEnabled(isKobitonIntegrated, this.serverAndApiKeyComposite);
        this.apiKeyComboEditor.setEnabled(isKobitonIntegrated, this.serverAndApiKeyComposite);
    }

    protected void createFieldEditors() {
    }

    public static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(columns, false));
        group.setText(text);
        group.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        group.setLayoutData((Object)gd);
        return group;
    }

    public static Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(columns, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_KOBITON;
    }
}

