/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.kobiton.execution.handlers;

import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerIntegrationKobitonMessageConstants;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerKobitonStringConstants;
import com.kms.katalon.composer.integration.kobiton.dialog.KobitonAuthenticationDialog;
import com.kms.katalon.composer.integration.kobiton.dialog.KobitonDeviceDialog;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.integration.kobiton.configuration.KobitonRunConfiguration;
import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class KobitonExecutionHandler
extends AbstractExecutionHandler {
    protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException, ExecutionException, InterruptedException {
        KobitonRunConfiguration kobitonRunConfiguration = new KobitonRunConfiguration(projectDir);
        String kobitonUserName = this.getKobitonUserName();
        if (kobitonUserName == null) {
            return null;
        }
        kobitonRunConfiguration.setUserName(kobitonUserName);
        String kobitonApiKey = this.getKobitonApiKey();
        if (kobitonApiKey == null) {
            return null;
        }
        kobitonRunConfiguration.setApiKey(kobitonApiKey);
        KobitonDevice kobitonDevice = this.getKobitonDevice();
        if (kobitonDevice == null) {
            return null;
        }
        kobitonRunConfiguration.setKobitonDevice(kobitonDevice);
        return kobitonRunConfiguration;
    }

    private String getKobitonApiKey() {
        String kobitonApiKey = KobitonPreferencesProvider.getKobitonApiKey();
        if (StringUtils.isNotEmpty((CharSequence)kobitonApiKey)) {
            return kobitonApiKey;
        }
        final ArrayList apiKeys = new ArrayList();
        try {
            new ProgressMonitorDialog(this.getActiveShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_RETRIEVING_KEYS, 1);
                            apiKeys.addAll(KobitonApiProvider.getApiKeyList((String)KobitonPreferencesProvider.getKobitonToken()));
                            monitor.worked(1);
                        }
                        catch (KobitonApiException | IOException | URISyntaxException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KobitonApiException) {
                MessageDialog.openError((Shell)this.getActiveShell(), (String)ComposerKobitonStringConstants.ERROR, (String)cause.getMessage());
                return null;
            }
            LoggerSingleton.logError((Throwable)cause);
        }
        catch (InterruptedException interruptedException) {}
        if (apiKeys.isEmpty()) {
            MessageDialogWithLink.openWarning((Shell)this.getActiveShell(), (String)ComposerKobitonStringConstants.WARN, (String)ComposerIntegrationKobitonMessageConstants.KobitonPreferencesPage_WARN_MSG_NO_API_KEY);
            return null;
        }
        String apiKey = ((KobitonApiKey)apiKeys.get(0)).getKey();
        KobitonPreferencesProvider.saveKobitonApiKey((String)apiKey);
        return apiKey;
    }

    private String getKobitonUserName() {
        String savedUserName = KobitonPreferencesProvider.getKobitonUserName();
        String token = KobitonPreferencesProvider.getKobitonToken();
        if (StringUtils.isEmpty((CharSequence)savedUserName) || StringUtils.isEmpty((CharSequence)token)) {
            KobitonAuthenticationDialog authenticateDialog = new KobitonAuthenticationDialog(this.getActiveShell());
            if (authenticateDialog.open() != 0) {
                return null;
            }
            savedUserName = KobitonPreferencesProvider.getKobitonUserName();
        }
        return savedUserName;
    }

    private Shell getActiveShell() {
        return Display.getCurrent().getActiveShell();
    }

    private KobitonDevice getKobitonDevice() {
        KobitonDeviceDialog deviceDialog = new KobitonDeviceDialog(this.getActiveShell());
        if (deviceDialog.open() == 0) {
            return deviceDialog.getSelectedDevice();
        }
        return null;
    }
}

