/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.zendesk;

import com.kms.katalon.activation.dialog.ActivationDialog;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.zendesk.EmailNotValidException;
import com.kms.katalon.zendesk.ZendeskHTTPRequestHelper;
import com.kms.katalon.zendesk.ZendeskRequestException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ZendeskSubmitTicketDialog
extends TitleAreaDialog {
    private static final int MAXIMUM_ATTACHMENT_SIZE = 7;
    private static final String[] ATTACHMENT_FILTER_FILES_EXTENSIONS = new String[]{"*.*"};
    private static final String[] ATTACHMENT_FILTER_FILES_NAMES = new String[]{"All Files (*.*)"};
    private Text textSubject;
    private Text textDescription;
    private ListViewer listAttachments;
    private List<File> attachments = new ArrayList<File>();

    public ZendeskSubmitTicketDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblSubject = new Label(container, 0);
        lblSubject.setText(MessageConstants.LBL_DLG_SUBJECT);
        this.textSubject = new Text(container, 2048);
        this.textSubject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        Label lblDescription = new Label(container, 0);
        lblDescription.setText(MessageConstants.LBL_DLG_DESCRIPTION);
        this.textDescription = new Text(container, 2562);
        GridData gd_textDescription = new GridData(4, 4, true, true, 1, 1);
        gd_textDescription.heightHint = 107;
        this.textDescription.setLayoutData((Object)gd_textDescription);
        new Label(container, 0);
        Label lblAttachments = new Label(container, 0);
        lblAttachments.setText(MessageConstants.LBL_DLG_ATTACHMENTS);
        ToolBar attachmentToolBar = new ToolBar(container, 0x820000);
        attachmentToolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(attachmentToolBar, 0);
        tltmAdd.setText(MessageConstants.TOOLITEM_DLG_ADD);
        tltmAdd.setImage(ImageManager.getImage((String)"add_16.png"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZendeskSubmitTicketDialog.this.addAttachment();
            }
        });
        ToolItem tltmDelete = new ToolItem(attachmentToolBar, 0);
        tltmDelete.setText(MessageConstants.TOOLITEM_DLG_DELETE);
        tltmDelete.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZendeskSubmitTicketDialog.this.deleteSelectedAttachments();
            }
        });
        ToolItem tltmClear = new ToolItem(attachmentToolBar, 0);
        tltmClear.setText(MessageConstants.TOOLITEM_DLG_CLEAR);
        tltmClear.setImage(ImageManager.getImage((String)"clear_16.png"));
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZendeskSubmitTicketDialog.this.clearAttachments();
            }
        });
        this.listAttachments = new ListViewer(container, 2562);
        GridData gd_listAttachments = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_listAttachments.heightHint = 74;
        this.listAttachments.getList().setLayoutData((Object)gd_listAttachments);
        this.listAttachments.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listAttachments.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    return ((File)element).getName();
                }
                return super.getText(element);
            }
        });
        this.listAttachments.setInput(this.attachments);
        this.setMessage(MessageConstants.MSG_DLG_REPORT_ISSUE);
        this.setTitle(MessageConstants.DLG_TITLE_DLG_REPORT_ISSUE);
        return container;
    }

    private void clearAttachments() {
        this.attachments.clear();
        this.listAttachments.refresh();
    }

    private void deleteSelectedAttachments() {
        ISelection selection = this.listAttachments.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        for (Object object : structuredSelection) {
            if (!(object instanceof File)) continue;
            this.attachments.remove((File)object);
        }
        this.listAttachments.refresh();
    }

    private void addAttachment() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 2);
        fileDialog.setFilterNames(ATTACHMENT_FILTER_FILES_NAMES);
        fileDialog.setFilterExtensions(ATTACHMENT_FILTER_FILES_EXTENSIONS);
        String result = fileDialog.open();
        if (result == null) {
            return;
        }
        List<File> selectedFiles = ZendeskSubmitTicketDialog.getSelectedFiles(fileDialog);
        ArrayList duplicatedFiles = new ArrayList();
        selectedFiles.stream().forEach(selectedFile -> {
            if (this.verifySelectedFile((File)selectedFile)) {
                this.attachments.add((File)selectedFile);
            } else {
                duplicatedFiles.add(selectedFile);
            }
        });
        if (!duplicatedFiles.isEmpty()) {
            this.setErrorMessage(MessageFormat.format(MessageConstants.ERR_MSG_FILES_DUPLICATED_NAMES_X, duplicatedFiles.stream().map(file -> file.getName()).collect(Collectors.joining(", "))));
        }
        this.listAttachments.refresh();
    }

    private boolean verifySelectedFile(File selectedFile) {
        return !this.attachments.stream().filter(attachment -> attachment.getName().equals(selectedFile.getName())).findFirst().isPresent();
    }

    private static List<File> getSelectedFiles(FileDialog fileDialog) {
        String filterPath = fileDialog.getFilterPath();
        ArrayList<File> selectedFiles = new ArrayList<File>();
        String[] stringArray = fileDialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            StringBuffer stringBuilder = new StringBuffer();
            stringBuilder.append(filterPath);
            if (stringBuilder.charAt(stringBuilder.length() - 1) != File.separatorChar) {
                stringBuilder.append(File.separatorChar);
            }
            stringBuilder.append(fileName);
            selectedFiles.add(new File(stringBuilder.toString()));
            ++n2;
        }
        return selectedFiles;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        GridData data = new GridData(68);
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, MessageConstants.BTN_DLG_SUBMIT_TICKET, true);
    }

    protected void okPressed() {
        if (this.textSubject.getText().isEmpty()) {
            this.setErrorMessage(MessageConstants.ERR_MSG_SUBJECT_CANNOT_BE_BLANK);
            return;
        }
        if (this.textDescription.getText().isEmpty()) {
            this.setErrorMessage(MessageConstants.ERR_MSG_DSC_CANNOT_BE_BLANK);
            return;
        }
        if (!this.verifyAttachmentsSize()) {
            this.setErrorMessage(MessageFormat.format(MessageConstants.ERR_MSG_ATTACHMENTS_SIZE_MUST_BE_LESS_OR_EQUAL_X_MB, 7));
            return;
        }
        if (this.doCreateTicket(this.textSubject.getText(), this.textDescription.getText(), this.attachments)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)StringConstants.INFO, (String)MessageConstants.MSG_DLG_SUBMIT_ISSUE_SUCCESS);
            super.okPressed();
        }
    }

    private boolean verifyAttachmentsSize() {
        double sizeInMB = this.attachments.stream().mapToLong(attachment -> attachment.length()).sum() / 0x100000L;
        return sizeInMB <= 7.0;
    }

    private boolean doCreateTicket(final String subject, final String description, final List<File> attachments) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(MessageConstants.MSG_PRG_SUBMITTING_TICKET, -1);
                            ZendeskHTTPRequestHelper.createTicket(subject, description, attachments);
                        }
                        catch (ZendeskRequestException | IOException | GeneralSecurityException | ParseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof EmailNotValidException) {
                return this.requireActivationAndTryAgain(subject, description, attachments);
            }
            this.setErrorMessage(targetException.getMessage());
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private boolean requireActivationAndTryAgain(String subject, String description, List<File> attachments) {
        MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR, (String)MessageConstants.ERR_MSG_MISSING_EMAIL);
        ActivationDialog activationDialog = new ActivationDialog(this.getShell());
        activationDialog.setAllowOfflineActivation(false);
        if (activationDialog.open() == 1) {
            return false;
        }
        return this.doCreateTicket(subject, description, attachments);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(489, 482);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageConstants.TITLE_DLG_REPORT_ISSUE);
    }
}

