/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.zendesk;

import com.google.gson.Gson;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ApplicationProxyUtil;
import com.kms.katalon.core.webservice.support.UrlEncoder;
import com.kms.katalon.zendesk.EmailNotValidException;
import com.kms.katalon.zendesk.ZendeskCreateTicketRequest;
import com.kms.katalon.zendesk.ZendeskRequestException;
import com.kms.katalon.zendesk.ZendeskTicket;
import com.kms.katalon.zendesk.ZendeskUploadAttachmentResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.Platform;

public class ZendeskHTTPRequestHelper {
    private static final String PROTOCOL_TLS = "TLS";
    private static final String ZENDESK_API_ENDPOING = "https://katalonhelp.zendesk.com/api/v2/";
    private static final String AUTHORIZATION_STRING = "Basic b2xpdmVyaG93YXJkQGthdGFsb24uY29tL3Rva2VuOnFsRU5yYXFsVU1XYU01WGlRVU9YamF5Y3ZHeW43d1I4aVBpbEVnS1Y=";
    private static final String BINARY_BODY_NAME = "file";
    private static final String CONTENT_TYPE_IMAGE_JPEG = "image/jpeg";
    private static final String TOKEN_PARAM = "token";
    private static final String AND_PARAM = "&";
    private static final String WITH_PARAM_VALUE = "=";
    private static final String FILENAME_PARAM = "filename";
    private static final String WITH_PARAMS = "?";
    private static final String API_UPLOADS = "https://katalonhelp.zendesk.com/api/v2/uploads.json";
    private static final String API_CREATE_TICKET = "https://katalonhelp.zendesk.com/api/v2/tickets.json";
    private static final int STATUS_CODE_CREATED = 201;
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";

    public static ZendeskTicket createTicket(String summary, String description, List<File> attachments) throws ParseException, IOException, ZendeskRequestException, GeneralSecurityException {
        String responseContent;
        ZendeskCreateTicketRequest request = ZendeskHTTPRequestHelper.createZendeskCreateTicketRequest(summary, description, attachments);
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put(HTTP_HEADER_CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        HttpResponse response = ZendeskHTTPRequestHelper.doPost(API_CREATE_TICKET, (HttpEntity)new StringEntity(new Gson().toJson((Object)request)), additionalHeaders);
        HttpEntity resEntity = response.getEntity();
        String string = responseContent = resEntity != null ? EntityUtils.toString((HttpEntity)resEntity) : "";
        if (response.getStatusLine().getStatusCode() != 201) {
            throw new ZendeskRequestException(responseContent);
        }
        if (resEntity != null) {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        return (ZendeskTicket)new Gson().fromJson(responseContent, ZendeskTicket.class);
    }

    private static ZendeskCreateTicketRequest createZendeskCreateTicketRequest(String summary, String description, List<File> attachments) throws IOException, ZendeskRequestException, ParseException, GeneralSecurityException {
        ArrayList<File> clonedAttachments = new ArrayList<File>(attachments);
        clonedAttachments.add(new File(Platform.getLogFileLocation().toOSString()));
        ZendeskTicket ticket = ZendeskHTTPRequestHelper.createZendeskTicket(summary, description, clonedAttachments);
        return new ZendeskCreateTicketRequest(ticket);
    }

    private static ZendeskTicket createZendeskTicket(String summary, String description, List<File> attachments) throws IOException, ZendeskRequestException, ParseException, GeneralSecurityException {
        String email = ApplicationInfo.getAppProperty((String)"email");
        if (!EmailValidator.getInstance().isValid(email)) {
            throw new EmailNotValidException(email);
        }
        ZendeskTicket ticket = new ZendeskTicket(summary);
        ZendeskTicket.ZendeskTicketComment comment = ZendeskHTTPRequestHelper.createZendeskTicketComment(description, attachments);
        ticket.setComment(comment);
        ticket.setRequester(new ZendeskTicket.ZendeskCollaborator(email, email));
        return ticket;
    }

    private static ZendeskTicket.ZendeskTicketComment createZendeskTicketComment(String description, List<File> attachments) throws IOException, ZendeskRequestException, ParseException, GeneralSecurityException {
        ZendeskTicket.ZendeskTicketComment comment = new ZendeskTicket.ZendeskTicketComment(description);
        if (attachments != null && !attachments.isEmpty()) {
            ZendeskUploadAttachmentResponse uploadAttachmentResponse = ZendeskHTTPRequestHelper.uploadFiles(attachments);
            comment.setUploads(new String[]{uploadAttachmentResponse.getUpload().getToken()});
        }
        return comment;
    }

    private static ZendeskUploadAttachmentResponse uploadFiles(List<File> attachments) throws ParseException, IOException, ZendeskRequestException, GeneralSecurityException {
        ZendeskUploadAttachmentResponse response = null;
        for (File file : attachments) {
            if (!file.exists()) continue;
            response = ZendeskHTTPRequestHelper.uploadFile(file, response != null ? response.getUpload().getToken() : null);
        }
        return response;
    }

    private static ZendeskUploadAttachmentResponse uploadFile(File attachment, String previouseToken) throws ParseException, IOException, ZendeskRequestException, GeneralSecurityException {
        String responseContent;
        String fileName = attachment.getName();
        HttpResponse response = ZendeskHTTPRequestHelper.doPost(ZendeskHTTPRequestHelper.buildUploadAttachmentUrl(fileName, previouseToken), MultipartEntityBuilder.create().addBinaryBody(BINARY_BODY_NAME, attachment, ContentType.create((String)CONTENT_TYPE_IMAGE_JPEG), fileName).build(), null);
        HttpEntity resEntity = response.getEntity();
        String string = responseContent = resEntity != null ? EntityUtils.toString((HttpEntity)resEntity) : "";
        if (response.getStatusLine().getStatusCode() != 201) {
            throw new ZendeskRequestException(responseContent);
        }
        if (resEntity != null) {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        return (ZendeskUploadAttachmentResponse)new Gson().fromJson(responseContent, ZendeskUploadAttachmentResponse.class);
    }

    private static HttpResponse doPost(String url, HttpEntity httpEntity, Map<String, String> additionalHeaders) throws IOException, GeneralSecurityException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        ZendeskHTTPRequestHelper.addProxy(builder);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)ZendeskHTTPRequestHelper.createSslConnectionSocketFactory());
        CloseableHttpClient httpClient = builder.build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(httpEntity);
        httpPost.addHeader(HTTP_HEADER_AUTHORIZATION, AUTHORIZATION_STRING);
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            additionalHeaders.entrySet().stream().forEach(headerEntry -> httpPost.addHeader((String)headerEntry.getKey(), (String)headerEntry.getValue()));
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response;
    }

    private static SSLConnectionSocketFactory createSslConnectionSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).useProtocol(PROTOCOL_TLS).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        return sslsf;
    }

    private static void addProxy(HttpClientBuilder builder) throws IOException {
        Proxy proxy = ApplicationProxyUtil.getProxy();
        if (proxy != Proxy.NO_PROXY && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)proxy.address();
            builder.setProxy(new HttpHost(socketAddress.getHostName(), socketAddress.getPort(), proxy.type().toString()));
        }
    }

    private static String buildUploadAttachmentUrl(String fileName, String previouseToken) {
        return "https://katalonhelp.zendesk.com/api/v2/uploads.json?filename=" + UrlEncoder.encode((String)fileName) + (previouseToken != null ? "&token=" + previouseToken : "");
    }
}

