/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.processors;

import java.util.Comparator;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public class ToolbarProcessor {
    public static final String KATALON_TOOLITEM_NEW_ID = "com.kms.katalon.composer.toolbar.new";
    public static final String KATALON_MAIN_TOOLBAR_ID = "com.kms.katalon.composer.toolbar";
    public static final String KATALON_MAIN_GENERIC_TOOLBAR_ID = "com.kms.katalon.composer.toolbar.generic";
    public static final String KATALON_MAIN_WEBSERVICE_TOOLBAR_ID = "com.kms.katalon.composer.toolbar.webservice";
    public static final String KATALON_EXECUTION_TOOLBAR_ID = "com.kms.katalon.composer.toolbar.execution";
    public static final String KATALON_PLUGIN_TOOLBAR_ID = "com.kms.katalon.composer.toolbar.plugin";
    public static final String[] TOOLBAR_IDS = new String[]{"com.kms.katalon.composer.toolbar", "com.kms.katalon.composer.toolbar.webservice", "com.kms.katalon.composer.toolbar.generic", "com.kms.katalon.composer.toolbar.execution"};
    private static final String INDEX_KEY = "index";
    private MHandledToolItem newToolItem;
    @Inject
    private EModelService modelService;

    @Execute
    public void run(@Optional IEclipseContext context, MApplication app) {
        String[] stringArray = TOOLBAR_IDS;
        int n = TOOLBAR_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            MUIElement uiElement = this.modelService.find(id, (MUIElement)app);
            if (uiElement == null) {
                return;
            }
            EList toolItems = (EList)((MToolBar)uiElement).getChildren();
            ECollections.sort((EList)toolItems, (Comparator)new CustomComparator(toolItems.size()));
            toolItems.forEach(item -> {
                String disabledIconURI = (String)item.getPersistedState().get("e4_disabled_icon_image_key");
                if (disabledIconURI == null) {
                    return;
                }
                item.getTransientData().put("e4_disabled_icon_image_key", disabledIconURI);
                if (this.newToolItem == null && KATALON_TOOLITEM_NEW_ID.equals(item.getElementId())) {
                    this.newToolItem = (MHandledToolItem)item;
                }
            });
            if (this.newToolItem == null) {
                return;
            }
            MMenu mMenu = this.newToolItem.getMenu();
            if (mMenu == null) {
                return;
            }
            EList menuItems = (EList)mMenu.getChildren();
            ECollections.sort((EList)menuItems, (Comparator)new CustomComparator(menuItems.size()));
            context.set(KATALON_TOOLITEM_NEW_ID, (Object)this.newToolItem);
            ++n2;
        }
    }

    private class CustomComparator
    implements Comparator<MUIElement> {
        private int numberOfItem;

        public CustomComparator(int numberOfItem) {
            this.numberOfItem = numberOfItem;
        }

        @Override
        public int compare(MUIElement item1, MUIElement item2) {
            Map persistedState1 = item1.getPersistedState();
            Map persistedState2 = item2.getPersistedState();
            int index1 = this.numberOfItem;
            int index2 = this.numberOfItem;
            if (persistedState1.containsKey(ToolbarProcessor.INDEX_KEY)) {
                index1 = Integer.valueOf((String)persistedState1.get(ToolbarProcessor.INDEX_KEY));
            }
            if (persistedState2.containsKey(ToolbarProcessor.INDEX_KEY)) {
                index2 = Integer.valueOf((String)persistedState2.get(ToolbarProcessor.INDEX_KEY));
            }
            return index1 - index2;
        }
    }
}

