/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.util;

import com.kms.katalon.plugin.models.KStoreToken;
import com.kms.katalon.plugin.store.PluginPreferenceStore;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class KStoreTokenService {
    private static final int TOKEN_VALID_HOURS = 23;
    private static KStoreTokenService instance;
    private PluginPreferenceStore store = new PluginPreferenceStore();

    public static KStoreTokenService getInstance() {
        if (instance == null) {
            instance = new KStoreTokenService();
        }
        return instance;
    }

    private KStoreTokenService() {
    }

    public KStoreToken createNewToken(String tokenString) throws IOException {
        KStoreToken token = new KStoreToken();
        Date currentDate = new Date();
        token.setToken(tokenString);
        token.setExpirationDate(DateUtils.addHours((Date)currentDate, (int)23));
        this.store.setToken(token);
        return token;
    }

    public KStoreToken getToken() {
        return this.store.getToken();
    }

    public boolean isTokenExpired(KStoreToken token) {
        Date currentDate = new Date();
        return currentDate.after(token.getExpirationDate());
    }
}

