/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.service;

import com.katalon.platform.internal.api.PluginInstaller;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.CustomKeywordPluginFactory;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.util.ZipManager;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.plugin.models.KStoreClientException;
import com.kms.katalon.plugin.models.KStoreCredentials;
import com.kms.katalon.plugin.models.KStorePlugin;
import com.kms.katalon.plugin.models.ReloadPluginsException;
import com.kms.katalon.plugin.models.ResultItem;
import com.kms.katalon.plugin.service.KStoreRestClient;
import com.kms.katalon.plugin.store.PluginPreferenceStore;
import com.kms.katalon.plugin.util.PluginFactory;
import com.kms.katalon.plugin.util.PluginHelper;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class PluginService {
    private static final String EXCEPTION_UNAUTHORIZED_SINGAL = "Unauthorized";
    private static final String EXCEPTION_DUPLICATED_BUNDLE_SIGNAL = "A bundle is already installed";
    private static final String EXCEPTION_ANOTHER_SINGLETON_BUNDLE_SELECTED_SIGNAL = "Another singleton bundle selected";
    private static PluginService instance;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private PluginPreferenceStore pluginPrefStore = new PluginPreferenceStore();

    private PluginService() {
    }

    public static PluginService getInstance() {
        if (instance == null) {
            instance = new PluginService();
        }
        return instance;
    }

    public List<ResultItem> reloadPlugins(KStoreCredentials credentials, IProgressMonitor monitor) throws ReloadPluginsException, InterruptedException {
        try {
            ArrayList<ResultItem> results = new ArrayList<ResultItem>();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            subMonitor.beginTask("", 100);
            SubMonitor fetchDataMonitor = subMonitor.split(30, 0);
            fetchDataMonitor.beginTask("Fetching latest plugin info from Katalon Store...", 100);
            List<KStorePlugin> latestPlugins = this.fetchLatestPlugins(credentials);
            fetchDataMonitor.done();
            SubMonitor uninstallMonitor = subMonitor.split(20, 0);
            uninstallMonitor.beginTask("Uninstalling plugins...", 100);
            List<KStorePlugin> localPlugins = PluginFactory.getInstance().getPlugins();
            int totalUninstallWork = localPlugins.size();
            int uninstallWork = 0;
            for (KStorePlugin plugin : localPlugins) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String pluginPath = this.getPluginLocation(plugin);
                if (!StringUtils.isBlank((CharSequence)pluginPath)) {
                    this.platformUninstall(pluginPath);
                }
                this.markWork(++uninstallWork, totalUninstallWork, uninstallMonitor);
            }
            uninstallMonitor.done();
            SubMonitor installPluginMonitor = subMonitor.split(40, 0);
            installPluginMonitor.beginTask("Installing plugins...", 100);
            this.cleanUpDownloadDir();
            int totalInstallWork = latestPlugins.size();
            int installWork = 0;
            CustomKeywordPluginFactory.getInstance().clear();
            PluginFactory.getInstance().clear();
            for (KStorePlugin plugin : latestPlugins) {
                block18: {
                    File download;
                    ResultItem item;
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (plugin.isExpired()) {
                        item = new ResultItem();
                        item.setPlugin(plugin);
                        results.add(item);
                        continue;
                    }
                    if (plugin.getLatestCompatibleVersion() == null) {
                        item = new ResultItem();
                        item.setPlugin(plugin);
                        results.add(item);
                        continue;
                    }
                    String pluginPath = this.getPluginLocation(plugin);
                    if (!this.isPluginDownloaded(plugin) && (download = this.downloadAndExtractPlugin(plugin, credentials)) != null) {
                        pluginPath = download.getAbsolutePath();
                        this.savePluginLocation(plugin, pluginPath);
                    }
                    try {
                        if (this.isCustomKeywordPlugin(plugin)) {
                            String location = this.getPluginLocation(plugin);
                            CustomKeywordPluginFactory.getInstance().addPluginFile(new File(location));
                        } else {
                            this.platformInstall(pluginPath);
                        }
                        ResultItem item2 = new ResultItem();
                        item2.setPlugin(plugin);
                        item2.markPluginInstalled(true);
                        results.add(item2);
                        PluginFactory.getInstance().addPlugin(plugin);
                    }
                    catch (BundleException e) {
                        if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)EXCEPTION_DUPLICATED_BUNDLE_SIGNAL) || StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)EXCEPTION_ANOTHER_SINGLETON_BUNDLE_SELECTED_SIGNAL)) break block18;
                        throw e;
                    }
                }
                this.markWork(++installWork, totalInstallWork, installPluginMonitor);
            }
            installPluginMonitor.done();
            SubMonitor refreshClasspathMonitor = subMonitor.split(10, 0);
            ProjectController projectController = ProjectController.getInstance();
            ProjectEntity currentProject = projectController.getCurrentProject();
            if (currentProject != null) {
                GroovyUtil.initGroovyProjectClassPath((ProjectEntity)currentProject, (List)projectController.getCustomKeywordPlugins(currentProject), (boolean)false, (IProgressMonitor)refreshClasspathMonitor);
                KeywordController.getInstance().parseAllCustomKeywords(currentProject, null);
                if (ApplicationRunningMode.get() == RunningMode.GUI) {
                    this.eventBroker.post("KEYWORD_BROWSER/REFRESH", null);
                }
            }
            monitor.done();
            return results;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)EXCEPTION_UNAUTHORIZED_SINGAL)) {
                throw new ReloadPluginsException("Unexpected error occurs during executing reload plugins due to invalid API Key", e);
            }
            throw new ReloadPluginsException("Unexpected error occurs during executing reload plugins", e);
        }
    }

    private void cleanUpDownloadDir() throws IOException {
        File downloadDir = this.getRepoDownloadDir();
        downloadDir.mkdirs();
        FileUtils.cleanDirectory((File)downloadDir);
    }

    private List<KStorePlugin> fetchLatestPlugins(KStoreCredentials credentials) throws KStoreClientException {
        KStoreRestClient restClient = new KStoreRestClient(credentials);
        String appVersion = VersionUtil.getCurrentVersion().getVersion();
        List<KStorePlugin> latestPlugins = restClient.getLatestPlugins(appVersion);
        return latestPlugins;
    }

    private Bundle platformInstall(String pluginPath) throws BundleException {
        String bundlePath;
        BundleContext bundleContext = Platform.getBundle((String)"com.katalon.platform").getBundleContext();
        Bundle existingBundle = bundleContext.getBundle(bundlePath = new File(pluginPath).toURI().toString());
        if (existingBundle == null) {
            Bundle bundle = this.getPluginInstaller().installPlugin(bundleContext, bundlePath);
            if (bundle != null && bundle.getSymbolicName().equals("com.katalon.katalon-studio-jira-plugin") && ApplicationRunningMode.get() != RunningMode.CONSOLE) {
                this.eventBroker.post("PLUGIN/JIRA_INSTALLED", null);
            }
            return bundle;
        }
        return existingBundle;
    }

    private boolean existBundleWithSameSymbolicName(Bundle bundle) {
        BundleContext bundleContext = Platform.getBundle((String)"com.katalon.platform").getBundleContext();
        Bundle[] bundles = bundleContext.getBundles();
        int count = 0;
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle installedBundle = bundleArray[n2];
            if (StringUtils.equalsIgnoreCase((CharSequence)installedBundle.getSymbolicName(), (CharSequence)bundle.getSymbolicName()) && ++count >= 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void platformUninstall(String pluginPath) throws BundleException {
        Bundle bundle;
        String bundlePath;
        BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
        Bundle existingBundle = bundleContext.getBundle(bundlePath = new File(pluginPath).toURI().toString());
        if (existingBundle != null && (bundle = this.getPluginInstaller().uninstallPlugin(bundleContext, bundlePath)) != null && bundle.getSymbolicName().equals("com.katalon.katalon-studio-jira-plugin") && ApplicationRunningMode.get() != RunningMode.CONSOLE) {
            this.eventBroker.post("PLUGIN/JIRA_UNINSTALLED", null);
        }
    }

    private PluginInstaller getPluginInstaller() {
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        PluginInstaller pluginInstaller = (PluginInstaller)context.getService(context.getServiceReference(PluginInstaller.class));
        return pluginInstaller;
    }

    private boolean isPluginDownloaded(KStorePlugin plugin) throws IOException {
        String pluginLocation = this.getPluginLocation(plugin);
        return !StringUtils.isBlank((CharSequence)pluginLocation) && new File(pluginLocation).exists();
    }

    private String getPluginLocation(KStorePlugin plugin) throws IOException {
        return this.pluginPrefStore.getPluginLocation(plugin);
    }

    private void savePluginLocation(KStorePlugin plugin, String path) throws IOException {
        this.pluginPrefStore.setPluginLocation(plugin, path);
    }

    private boolean isCustomKeywordPlugin(KStorePlugin plugin) {
        return plugin.getProduct().getProductType().getName().equalsIgnoreCase("Custom Keywords Plugin");
    }

    private void markWork(int work, int totalWork, SubMonitor monitor) {
        int subwork = Math.round((float)work * 100.0f / (float)totalWork);
        monitor.worked(subwork);
    }

    private File downloadAndExtractPlugin(KStorePlugin plugin, KStoreCredentials credentials) throws Exception {
        this.trackDownloadPlugin(plugin, credentials);
        File downloadDir = this.getRepoDownloadDir();
        downloadDir.mkdirs();
        FileUtils.cleanDirectory((File)downloadDir);
        File downloadFile = this.getPluginDownloadFileInfo(plugin);
        downloadFile.createNewFile();
        KStoreRestClient restClient = this.getRestClient(credentials);
        restClient.downloadPlugin(plugin.getProduct().getId(), downloadFile, plugin.getLatestCompatibleVersion().getNumber());
        File pluginInstallDir = this.getPluginInstallDir(plugin);
        pluginInstallDir.mkdirs();
        ZipManager.unzip((File)downloadFile, (String)pluginInstallDir.getAbsolutePath());
        File jar = Arrays.stream(pluginInstallDir.listFiles()).filter(file -> {
            String name = file.getName().toLowerCase();
            return name.endsWith(".jar") && !name.endsWith("-javadoc.jar") && !name.endsWith("-sources.jar");
        }).findAny().orElse(null);
        return jar;
    }

    private void trackDownloadPlugin(KStorePlugin plugin, KStoreCredentials credentials) {
        String apiKey = credentials instanceof KStoreApiKeyCredentials ? ((KStoreApiKeyCredentials)credentials).getApiKey() : "";
        Trackings.trackDownloadPlugin((String)apiKey, (long)plugin.getProduct().getId(), (String)plugin.getProduct().getName(), (String)plugin.getLatestCompatibleVersion().getNumber(), (RunningMode)ApplicationRunningMode.get());
    }

    private KStoreRestClient getRestClient(KStoreCredentials credentials) {
        KStoreRestClient restClient = new KStoreRestClient(credentials);
        return restClient;
    }

    private File getPluginInstallDir(KStorePlugin plugin) {
        return new File(this.getRepoInstallDir(), String.valueOf(plugin.getId()) + File.separator + plugin.getLatestCompatibleVersion().getNumber());
    }

    private File getPluginDownloadFileInfo(KStorePlugin plugin) {
        String fileName = String.valueOf(PluginHelper.idAndVersionKey(plugin)) + ".zip";
        return new File(this.getRepoDownloadDir(), fileName);
    }

    private File getRepoDownloadDir() {
        return new File(this.getPluginRepoDir(), "download");
    }

    private File getRepoInstallDir() {
        return new File(this.getPluginRepoDir(), "install");
    }

    private File getPluginRepoDir() {
        return new File(GlobalStringConstants.APP_USER_DIR_LOCATION, "plugin");
    }
}

