/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.service;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.plugin.models.KStoreClientException;
import com.kms.katalon.plugin.models.KStoreCredentials;
import com.kms.katalon.plugin.models.KStorePlugin;
import com.kms.katalon.plugin.models.KStoreProduct;
import com.kms.katalon.plugin.models.KStoreToken;
import com.kms.katalon.plugin.util.KStoreTokenService;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.swt.program.Program;

public class KStoreRestClient {
    private static final String DEVELOPMENT_URL = "https://store-staging.katalon.com";
    private static final String PRODUCTION_URL = "https://store.katalon.com";
    private KStoreCredentials credentials;

    public KStoreRestClient(KStoreCredentials credentials) {
        this.credentials = credentials;
    }

    public List<KStorePlugin> getLatestPlugins(String appVersion) throws KStoreClientException {
        AtomicReference plugins = new AtomicReference();
        try {
            this.executeGetRequest(this.getPluginsAPIUrl(appVersion), this.credentials, response -> {
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new KStoreClientException("Failed to get latest plugin. No content returned from server.");
                    }
                    String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
                    responseContent = responseContent.replace("{}", "null");
                    plugins.set(this.parsePluginListJson(responseContent));
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing get latest plugins", e);
                }
            });
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing get latest plugins", e);
        }
        return (List)plugins.get();
    }

    private List<KStorePlugin> parsePluginListJson(String json) throws ParseException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Type listType = new TypeToken<List<KStorePlugin>>(){}.getType();
        return (List)gson.fromJson(json, listType);
    }

    public void downloadPlugin(long productId, File downloadFile, String pluginVersion) throws KStoreClientException {
        try {
            this.executeGetRequest(this.getPluginDownloadAPIUrl(productId, pluginVersion), this.credentials, response -> {
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new KStoreClientException("Failed to download plugin. No content returned from server.");
                    }
                    FileOutputStream outstream = new FileOutputStream(downloadFile);
                    entity.writeTo((OutputStream)outstream);
                    outstream.close();
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing download plugin", e);
                }
            });
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing download plugin", e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationResult authenticate() throws KStoreClientException {
        try {
            post = new HttpPost(this.getAuthenticateAPIUrl());
            this.addAuthenticationHeaders(this.credentials, (HttpRequestBase)post);
            content = JsonUtil.toJson((Object)this.credentials);
            requestEntity = new StringEntity(content);
            post.setEntity((HttpEntity)requestEntity);
            post.setHeader("Accept", "application/json");
            post.setHeader("Content-type", "application/json");
            var4_5 = null;
            var5_7 = null;
            try {
                block19: {
                    client = this.getHttpClient();
                    try {
                        block18: {
                            response = client.execute((HttpUriRequest)post);
                            try {
                                statusCode = response.getStatusLine().getStatusCode();
                                result = new AuthenticationResult();
                                if (statusCode == 200) {
                                    result.setAuthenticated(true);
                                    responseEntity = response.getEntity();
                                    if (responseEntity != null) {
                                        token = EntityUtils.toString((HttpEntity)responseEntity);
                                        result.setToken(token);
                                    }
                                    v0 = result;
                                    if (response == null) break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var4_6) {
                                if (response == null) throw var4_6;
                                response.close();
                                throw var4_6;
                            }
                            response.close();
                        }
                        if (client == null) return v0;
                    }
                    catch (Throwable var5_8) {
                        if (var4_5 == null) {
                            var4_5 = var5_8;
                        } else if (var4_5 != var5_8) {
                            var4_5.addSuppressed(var5_8);
                        }
                        if (client == null) throw var4_5;
                        client.close();
                        throw var4_5;
                    }
                    client.close();
                    return v0;
lbl-1000:
                    // 1 sources

                    {
                        if (statusCode != 401) ** GOTO lbl-1000
                        result.setAuthenticated(false);
                        result.setToken("");
                        v1 = result;
                        if (response == null) break block19;
                    }
                    response.close();
                }
                if (client == null) return v1;
                client.close();
                return v1;
lbl-1000:
                // 1 sources

                {
                    throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()}));
                }
            }
            catch (Throwable var5_9) {
                if (var4_5 == null) {
                    var4_5 = var5_9;
                    throw var4_5;
                }
                if (var4_5 == var5_9) throw var4_5;
                var4_5.addSuppressed(var5_9);
                throw var4_5;
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing authenticate", e);
        }
    }

    public void goToSearchPluginPage() throws KStoreClientException {
        try {
            KStoreToken token = this.getToken();
            if (token != null) {
                String searchPluginPageUrl = this.getSearchPluginUrl(token.getToken());
                Program.launch((String)searchPluginPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Search Plugins page", e);
        }
    }

    public void goToManagePluginsPage() throws KStoreClientException {
        try {
            KStoreToken token = this.getToken();
            if (token != null) {
                String managePluginsPageUrl = this.getManagePluginUrl(token.getToken());
                Program.launch((String)managePluginsPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToManageApiKeysPage() throws KStoreClientException {
        try {
            KStoreToken token = this.getToken();
            if (token != null) {
                String manageApiKeysPageUrl = this.getManageApiKeysPageUrl(token.getToken());
                Program.launch((String)manageApiKeysPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage API Keys page", e);
        }
    }

    public void goToProductPage(KStoreProduct product) throws KStoreClientException {
        try {
            KStoreToken token = this.getToken();
            if (token != null) {
                String productPageUrl = this.getProductPageUrl(product, token.getToken());
                Program.launch((String)productPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    private KStoreToken getToken() throws IOException, KStoreClientException {
        KStoreToken token = KStoreTokenService.getInstance().getToken();
        if (KStoreTokenService.getInstance().isTokenExpired(token)) {
            AuthenticationResult authenticateResult = this.authenticate();
            if (authenticateResult.isAuthenticated()) {
                String tokenString = authenticateResult.getToken();
                token = KStoreTokenService.getInstance().createNewToken(tokenString);
            } else {
                token = null;
            }
        }
        return token;
    }

    private void executeGetRequest(String url, KStoreCredentials credentials, OnRequestSuccessHandler requestSuccessHandler) throws URISyntaxException, IOException, GeneralSecurityException, KStoreClientException {
        HttpGet get = new HttpGet(url);
        this.addAuthenticationHeaders(credentials, (HttpRequestBase)get);
        CloseableHttpClient client = this.getHttpClient();
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        requestSuccessHandler.handleRequestSuccess(response);
        IOUtils.closeQuietly((Closeable)client);
        IOUtils.closeQuietly((Closeable)response);
    }

    private <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    private CloseableHttpClient getHttpClient() throws URISyntaxException, IOException, GeneralSecurityException {
        return HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getProxyInformation()).getClientBuilder().build();
    }

    private void addAuthenticationHeaders(KStoreCredentials credentials, HttpRequestBase request) {
        credentials.getAuthHeaders().entrySet().stream().forEach(entry -> request.addHeader((String)entry.getKey(), (String)entry.getValue()));
    }

    private String getSearchPluginUrl(String token) {
        return String.valueOf(this.getKatalonStoreUrl()) + "?token=" + token;
    }

    private String getManagePluginUrl(String token) {
        return String.valueOf(this.getKatalonStoreUrl()) + "/manage/products?token=" + token;
    }

    private String getManageApiKeysPageUrl(String token) {
        return String.valueOf(this.getKatalonStoreUrl()) + "/settings?token=" + token;
    }

    private String getProductPageUrl(KStoreProduct product, String token) {
        return String.valueOf(this.getKatalonStoreUrl()) + product.getUrl() + "?token=" + token;
    }

    private String getAuthenticateAPIUrl() {
        return String.valueOf(this.getKatalonStoreAPIUrl()) + "/authenticate";
    }

    private String getPluginsAPIUrl(String appVersion) {
        return String.valueOf(this.getKatalonStoreAPIUrl()) + "/products/ks?appVersion=" + appVersion;
    }

    private String getPluginDownloadAPIUrl(long pluginId, String pluginVersion) {
        return String.valueOf(this.getKatalonStoreAPIUrl()) + "/download/source/" + pluginId + "?version=" + pluginVersion;
    }

    private String getKatalonStoreAPIUrl() {
        return String.valueOf(this.getKatalonStoreUrl()) + "/api";
    }

    private String getKatalonStoreUrl() {
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return DEVELOPMENT_URL;
        }
        return PRODUCTION_URL;
    }

    public class AuthenticationResult {
        private boolean isAuthenticated;
        private String token;

        public boolean isAuthenticated() {
            return this.isAuthenticated;
        }

        public void setAuthenticated(boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }

    private static interface OnRequestSuccessHandler {
        public void handleRequestSuccess(CloseableHttpResponse var1) throws KStoreClientException;
    }
}

