/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.dialog;

import com.kms.katalon.composer.components.impl.providers.HyperLinkColumnLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.plugin.models.KStoreClientException;
import com.kms.katalon.plugin.models.KStorePlugin;
import com.kms.katalon.plugin.models.KStoreUsernamePasswordCredentials;
import com.kms.katalon.plugin.models.ResultItem;
import com.kms.katalon.plugin.service.KStoreRestClient;
import com.kms.katalon.plugin.store.PluginPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class KStorePluginsDialog
extends Dialog {
    private static final int CLMN_PLUGIN_NAME_IDX = 0;
    private static final int CLMN_UPDATE_LINK_IDX = 3;
    private List<ResultItem> results;

    protected KStorePluginsDialog(Shell parentShell) {
        super(parentShell);
    }

    public KStorePluginsDialog(Shell shell, List<ResultItem> results) {
        this(shell);
        this.results = results;
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 2048);
        body.setLayout((Layout)new GridLayout(1, false));
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComposite = new Composite(body, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new FillLayout());
        TableViewer pluginTableViewer = new TableViewer(tableComposite, 67586);
        pluginTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table pluginTable = pluginTableViewer.getTable();
        pluginTable.setHeaderVisible(true);
        pluginTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnPluginName = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnPluginName = tableViewerColumnPluginName.getColumn();
        tableColumnPluginName.setText(StringConstants.KStorePluginsDialog_COL_PLUGIN);
        tableViewerColumnPluginName.setLabelProvider((CellLabelProvider)new PluginNameColumnLabelProvider(0));
        TableViewerColumn tableViewerColumnStatus = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnStatus = tableViewerColumnStatus.getColumn();
        tableColumnStatus.setText(StringConstants.KStorePluginsDialog_COL_STATUS);
        tableViewerColumnStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResultItem item = (ResultItem)element;
                KStorePlugin plugin = item.getPlugin();
                if (item.isPluginInstalled()) {
                    return StringConstants.KStorePluginsDialog_STATUS_INSTALLED;
                }
                if (plugin.isExpired()) {
                    return StringConstants.KStorePluginsDialog_STATUS_EXPIRED;
                }
                return StringConstants.KStorePluginsDialog_STATUS_INCOMPATIBLE;
            }
        });
        TableViewerColumn tableViewerColumnVersion = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnVersion = tableViewerColumnVersion.getColumn();
        tableColumnVersion.setText(StringConstants.KStorePluginsDialog_COL_VERSION);
        tableViewerColumnVersion.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResultItem item = (ResultItem)element;
                return item.getPlugin().getLatestCompatibleVersion().getNumber();
            }
        });
        TableViewerColumn tableViewerColumnUpdateLink = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnUpdateLink = tableViewerColumnUpdateLink.getColumn();
        tableViewerColumnUpdateLink.setLabelProvider((CellLabelProvider)new UpdateLinkColumnLabelProvider(3));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tableColumnPluginName, (ColumnLayoutData)new ColumnWeightData(40, 40));
        tableLayout.setColumnData((Widget)tableColumnStatus, (ColumnLayoutData)new ColumnWeightData(20, 10));
        tableLayout.setColumnData((Widget)tableColumnVersion, (ColumnLayoutData)new ColumnWeightData(20, 20));
        tableLayout.setColumnData((Widget)tableColumnUpdateLink, (ColumnLayoutData)new ColumnWeightData(20, 30));
        tableComposite.setLayout((Layout)tableLayout);
        pluginTableViewer.setInput(this.collectInstalledAndExpiredPluginResults(this.results));
        Button btnClose = new Button(body, 0);
        btnClose.setLayoutData((Object)new GridData(131072, 4, false, false));
        btnClose.setText(IDialogConstants.CLOSE_LABEL);
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KStorePluginsDialog.this.setReturnCode(1);
                KStorePluginsDialog.this.close();
            }
        });
        return body;
    }

    private List<ResultItem> collectInstalledAndExpiredPluginResults(List<ResultItem> results) {
        return results.stream().filter(result -> result.isPluginInstalled() || result.getPlugin().isExpired()).collect(Collectors.toList());
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.KStorePluginsDialog_DIA_TITLE);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), Math.max(300, initialSize.y));
    }

    protected boolean isResizable() {
        return true;
    }

    private class PluginNameColumnLabelProvider
    extends HyperLinkColumnLabelProvider<ResultItem> {
        public PluginNameColumnLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
            try {
                ResultItem resultItem = (ResultItem)cell.getElement();
                PluginPreferenceStore pluginPrefStore = new PluginPreferenceStore();
                KStoreUsernamePasswordCredentials credentials = pluginPrefStore.getKStoreUsernamePasswordCredentials();
                KStoreRestClient restClient = new KStoreRestClient(credentials);
                restClient.goToProductPage(resultItem.getPlugin().getProduct());
            }
            catch (KStoreClientException | IOException | GeneralSecurityException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }

        protected Class<ResultItem> getElementType() {
            return ResultItem.class;
        }

        protected Image getImage(ResultItem element) {
            return null;
        }

        protected String getText(ResultItem element) {
            return element.getPlugin().getProduct().getName();
        }
    }

    private class UpdateLinkColumnLabelProvider
    extends HyperLinkColumnLabelProvider<ResultItem> {
        public UpdateLinkColumnLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
            try {
                ResultItem resultItem = (ResultItem)cell.getElement();
                PluginPreferenceStore pluginPrefStore = new PluginPreferenceStore();
                KStoreUsernamePasswordCredentials credentials = pluginPrefStore.getKStoreUsernamePasswordCredentials();
                KStoreRestClient restClient = new KStoreRestClient(credentials);
                restClient.goToProductPage(resultItem.getPlugin().getProduct());
            }
            catch (KStoreClientException | IOException | GeneralSecurityException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }

        protected Class<ResultItem> getElementType() {
            return ResultItem.class;
        }

        protected Image getImage(ResultItem element) {
            return null;
        }

        protected String getText(ResultItem element) {
            if (element.isNewVersionAvailable()) {
                return StringConstants.KStorePluginsDialog_LBL_UPDATE;
            }
            return "";
        }
    }
}

